/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.util;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.airlift.testing.Assertions;
import io.prestosql.plugin.hive.util.AsyncQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestAsyncQueue {
    private ExecutorService executor;

    @BeforeClass
    public void setUpClass() {
        this.executor = Executors.newFixedThreadPool(8, Threads.daemonThreadsNamed((String)"test-async-queue-%s"));
    }

    @AfterClass(alwaysRun=true)
    public void tearDownClass() {
        this.executor.shutdownNow();
    }

    @Test(timeOut=10000L)
    public void testGetPartial() throws Exception {
        AsyncQueue queue = new AsyncQueue(4, (Executor)this.executor);
        queue.offer((Object)"1");
        queue.offer((Object)"2");
        queue.offer((Object)"3");
        Assert.assertEquals((Collection)((Collection)queue.getBatchAsync(100).get()), (Collection)ImmutableList.of((Object)"1", (Object)"2", (Object)"3"));
        queue.finish();
        Assert.assertTrue((boolean)queue.isFinished());
    }

    @Test(timeOut=10000L)
    public void testFullQueue() throws Exception {
        AsyncQueue queue = new AsyncQueue(4, (Executor)this.executor);
        Assert.assertTrue((boolean)queue.offer((Object)"1").isDone());
        Assert.assertTrue((boolean)queue.offer((Object)"2").isDone());
        Assert.assertTrue((boolean)queue.offer((Object)"3").isDone());
        Assert.assertFalse((boolean)queue.offer((Object)"4").isDone());
        Assert.assertFalse((boolean)queue.offer((Object)"5").isDone());
        ListenableFuture offerFuture = queue.offer((Object)"6");
        Assert.assertFalse((boolean)offerFuture.isDone());
        Assert.assertEquals((Collection)((Collection)queue.getBatchAsync(2).get()), (Collection)ImmutableList.of((Object)"1", (Object)"2"));
        Assert.assertFalse((boolean)offerFuture.isDone());
        Assert.assertEquals((Collection)((Collection)queue.getBatchAsync(1).get()), (Collection)ImmutableList.of((Object)"3"));
        offerFuture.get();
        offerFuture = queue.offer((Object)"7");
        Assert.assertFalse((boolean)offerFuture.isDone());
        queue.finish();
        offerFuture.get();
        Assert.assertFalse((boolean)queue.isFinished());
        Assert.assertEquals((Collection)((Collection)queue.getBatchAsync(4).get()), (Collection)ImmutableList.of((Object)"4", (Object)"5", (Object)"6", (Object)"7"));
        Assert.assertTrue((boolean)queue.isFinished());
    }

    @Test(timeOut=10000L)
    public void testEmptyQueue() throws Exception {
        AsyncQueue queue = new AsyncQueue(4, (Executor)this.executor);
        Assert.assertTrue((boolean)queue.offer((Object)"1").isDone());
        Assert.assertTrue((boolean)queue.offer((Object)"2").isDone());
        Assert.assertTrue((boolean)queue.offer((Object)"3").isDone());
        Assert.assertEquals((Collection)((Collection)queue.getBatchAsync(2).get()), (Collection)ImmutableList.of((Object)"1", (Object)"2"));
        Assert.assertEquals((Collection)((Collection)queue.getBatchAsync(2).get()), (Collection)ImmutableList.of((Object)"3"));
        ListenableFuture batchFuture = queue.getBatchAsync(2);
        Assert.assertFalse((boolean)batchFuture.isDone());
        Assert.assertTrue((boolean)queue.offer((Object)"4").isDone());
        Assert.assertEquals((Object)batchFuture.get(), (Object)ImmutableList.of((Object)"4"));
        batchFuture = queue.getBatchAsync(2);
        Assert.assertFalse((boolean)batchFuture.isDone());
        queue.finish();
        batchFuture.get();
        Assert.assertTrue((boolean)queue.isFinished());
    }

    @Test(timeOut=10000L)
    public void testOfferAfterFinish() throws Exception {
        AsyncQueue queue = new AsyncQueue(4, (Executor)this.executor);
        Assert.assertTrue((boolean)queue.offer((Object)"1").isDone());
        Assert.assertTrue((boolean)queue.offer((Object)"2").isDone());
        Assert.assertTrue((boolean)queue.offer((Object)"3").isDone());
        Assert.assertFalse((boolean)queue.offer((Object)"4").isDone());
        queue.finish();
        Assert.assertTrue((boolean)queue.offer((Object)"5").isDone());
        Assert.assertTrue((boolean)queue.offer((Object)"6").isDone());
        Assert.assertTrue((boolean)queue.offer((Object)"7").isDone());
        Assert.assertFalse((boolean)queue.isFinished());
        Assert.assertEquals((Collection)((Collection)queue.getBatchAsync(100).get()), (Collection)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"4"));
        Assert.assertTrue((boolean)queue.isFinished());
    }

    @Test
    public void testBorrow() throws Exception {
        AsyncQueue queue = new AsyncQueue(4, (Executor)this.executor);
        queue.offer((Object)1);
        queue.offer((Object)2);
        queue.offer((Object)3);
        queue.offer((Object)4);
        queue.offer((Object)5);
        Runnable runnable = () -> {
            for (int i = 0; i < 700; ++i) {
                MoreFutures.getFutureValue((Future)queue.borrowBatchAsync(3, elements -> new AsyncQueue.BorrowResult(elements, null)));
            }
        };
        Future<?> future1 = this.executor.submit(runnable);
        Future<?> future2 = this.executor.submit(runnable);
        Future<?> future3 = this.executor.submit(runnable);
        future1.get();
        future2.get();
        future3.get();
        queue.finish();
        Assert.assertFalse((boolean)queue.isFinished());
        AtomicBoolean done = new AtomicBoolean();
        this.executor.submit(() -> {
            while (!done.get()) {
                Assert.assertFalse((queue.isFinished() || done.get() ? 1 : 0) != 0);
            }
        });
        future1 = this.executor.submit(runnable);
        future2 = this.executor.submit(runnable);
        future3 = this.executor.submit(runnable);
        future1.get();
        future2.get();
        future3.get();
        done.set(true);
        Assert.assertFalse((boolean)queue.isFinished());
        ArrayList list = new ArrayList((Collection)queue.getBatchAsync(100).get());
        list.sort(Integer::compare);
        Assert.assertEquals(list, (Collection)ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)5));
        Assert.assertTrue((boolean)queue.isFinished());
    }

    @Test
    public void testBorrowThrows() throws Exception {
        AsyncQueue queue = new AsyncQueue(4, (Executor)this.executor);
        queue.offer((Object)1);
        queue.offer((Object)2);
        queue.offer((Object)3);
        queue.offer((Object)4);
        queue.offer((Object)5);
        ListenableFuture future1 = queue.offer((Object)6);
        Assert.assertFalse((boolean)future1.isDone());
        Runnable runnable = () -> MoreFutures.getFutureValue((Future)queue.borrowBatchAsync(1, elements -> {
            throw new RuntimeException("test fail");
        }));
        try {
            this.executor.submit(runnable).get();
            Assert.fail((String)"expected failure");
        }
        catch (ExecutionException e) {
            Assertions.assertContains((String)e.getMessage(), (String)"test fail");
        }
        ListenableFuture future2 = queue.offer((Object)7);
        Assert.assertFalse((boolean)future1.isDone());
        Assert.assertFalse((boolean)future2.isDone());
        queue.finish();
        future1.get();
        future2.get();
        Assert.assertTrue((boolean)queue.offer((Object)8).isDone());
        try {
            this.executor.submit(runnable).get();
            Assert.fail((String)"expected failure");
        }
        catch (ExecutionException e) {
            Assertions.assertContains((String)e.getMessage(), (String)"test fail");
        }
        Assert.assertTrue((boolean)queue.offer((Object)9).isDone());
        Assert.assertFalse((boolean)queue.isFinished());
        ArrayList list = new ArrayList((Collection)queue.getBatchAsync(100).get());
        Assert.assertEquals(list, (Collection)ImmutableList.of((Object)3, (Object)4, (Object)5, (Object)6, (Object)7));
        Assert.assertTrue((boolean)queue.isFinished());
    }
}

