/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.util;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.testing.Closeables;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.util.FSDataInputStreamTail;
import io.prestosql.spi.PrestoException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestFSDataInputStreamTail {
    private File tempRoot;
    private Path tempFile;
    private RawLocalFileSystem fs;

    @BeforeClass
    public void setUp() throws Exception {
        this.fs = new RawLocalFileSystem();
        this.fs.initialize(this.fs.getUri(), new Configuration(false));
        this.tempRoot = Files.createTempDirectory("test_fsdatainputstream_tail", new FileAttribute[0]).toFile();
        this.tempFile = new Path(Files.createTempFile(this.tempRoot.toPath(), "tempfile", "txt", new FileAttribute[0]).toUri());
    }

    @BeforeMethod
    public void truncateTempFile() throws Exception {
        this.fs.truncate(this.tempFile, 0L);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        Closeables.closeAll((Closeable[])new Closeable[]{() -> this.fs.delete(new Path(this.tempRoot.toURI()), true), this.fs});
    }

    @Test
    public void testEmptyFileReadTail() throws Exception {
        try (FSDataInputStream is = this.fs.open(this.tempFile);){
            FSDataInputStreamTail tail = FSDataInputStreamTail.readTail((String)this.tempFile.toString(), (long)64L, (FSDataInputStream)is, (int)64);
            Assert.assertEquals((long)tail.getFileSize(), (long)0L);
            Assert.assertEquals((int)tail.getTailSlice().length(), (int)0);
            Assert.assertSame((Object)tail.getTailSlice(), (Object)Slices.EMPTY_SLICE);
        }
    }

    @Test(dataProvider="validFileSizeAndPaddedFileSize")
    public void testReadTailForFileSize(int fileSize, int paddedFileSize) throws Exception {
        this.fs.truncate(this.tempFile, 0L);
        if (fileSize > 0) {
            try (FSDataOutputStream os = this.fs.append(this.tempFile);){
                os.write(TestFSDataInputStreamTail.countingTestFileContentsWithLength(fileSize));
            }
        }
        Assert.assertEquals((long)this.fs.getFileLinkStatus(this.tempFile).getLen(), (long)fileSize);
        try (FSDataInputStream is = this.fs.open(this.tempFile);){
            Assert.assertEquals((long)FSDataInputStreamTail.readTailForFileSize((String)this.tempFile.toString(), (long)paddedFileSize, (FSDataInputStream)is), (long)fileSize);
        }
    }

    @Test(dataProvider="validFileSizeAndPaddedFileSize")
    public void testReadTailCompletely(int fileSize, int paddedFileSize) throws Exception {
        byte[] contents = TestFSDataInputStreamTail.countingTestFileContentsWithLength(fileSize);
        if (contents.length > 0) {
            try (FSDataOutputStream os = this.fs.append(this.tempFile);){
                os.write(contents);
            }
        }
        Assert.assertEquals((long)this.fs.getFileLinkStatus(this.tempFile).getLen(), (long)fileSize);
        try (FSDataInputStream is = this.fs.open(this.tempFile);){
            FSDataInputStreamTail tail = FSDataInputStreamTail.readTail((String)this.tempFile.toString(), (long)paddedFileSize, (FSDataInputStream)is, (int)fileSize);
            Assert.assertEquals((long)tail.getFileSize(), (long)fileSize);
            Slice tailSlice = tail.getTailSlice();
            Assert.assertEquals((int)tailSlice.length(), (int)fileSize);
            TestFSDataInputStreamTail.assertCountingTestFileContents(tailSlice.getBytes());
        }
    }

    @Test
    public void testReadTailPartial() throws Exception {
        byte[] contents = TestFSDataInputStreamTail.countingTestFileContentsWithLength(256);
        try (FSDataOutputStream os = this.fs.append(this.tempFile);){
            os.write(contents);
        }
        Assert.assertEquals((long)this.fs.getFileLinkStatus(this.tempFile).getLen(), (long)contents.length);
        try (FSDataInputStream is = this.fs.open(this.tempFile);){
            FSDataInputStreamTail tail = FSDataInputStreamTail.readTail((String)this.tempFile.toString(), (long)(contents.length + 32), (FSDataInputStream)is, (int)16);
            Assert.assertEquals((long)tail.getFileSize(), (long)contents.length);
            Slice tailSlice = tail.getTailSlice();
            Assert.assertTrue((tailSlice.length() < contents.length ? 1 : 0) != 0);
            Assert.assertEquals((Object)tailSlice.getBytes(), (Object)Arrays.copyOfRange(contents, contents.length - tailSlice.length(), contents.length));
        }
    }

    @Test(expectedExceptions={IOException.class}, expectedExceptionsMessageRegExp="Incorrect file size \\(.*\\) for file \\(end of stream not reached\\): file:.*")
    public void testReadTailNoEndOfFileFound() throws Exception {
        byte[] contents = TestFSDataInputStreamTail.countingTestFileContentsWithLength(256);
        try (FSDataOutputStream os = this.fs.append(this.tempFile);){
            os.write(contents);
        }
        Assert.assertEquals((long)this.fs.getFileLinkStatus(this.tempFile).getLen(), (long)contents.length);
        try (FSDataInputStream is = this.fs.open(this.tempFile);){
            FSDataInputStreamTail.readTail((String)this.tempFile.toString(), (long)128L, (FSDataInputStream)is, (int)16);
            Assert.fail((String)"Expected failure to find end of stream");
        }
        catch (PrestoException e) {
            Assert.assertEquals((Object)e.getErrorCode(), (Object)HiveErrorCode.HIVE_FILESYSTEM_ERROR.toErrorCode());
            throw e;
        }
    }

    @Test(expectedExceptions={IOException.class}, expectedExceptionsMessageRegExp="Incorrect file size \\(.*\\) for file \\(end of stream not reached\\): file:.*")
    public void testReadTailForFileSizeNoEndOfFileFound() throws Exception {
        byte[] contents = TestFSDataInputStreamTail.countingTestFileContentsWithLength(256);
        try (FSDataOutputStream os = this.fs.append(this.tempFile);){
            os.write(contents);
        }
        Assert.assertEquals((long)this.fs.getFileLinkStatus(this.tempFile).getLen(), (long)contents.length);
        try (FSDataInputStream is = this.fs.open(this.tempFile);){
            FSDataInputStreamTail.readTailForFileSize((String)this.tempFile.toString(), (long)128L, (FSDataInputStream)is);
            Assert.fail((String)"Expected failure to find end of stream");
        }
    }

    @DataProvider(name="validFileSizeAndPaddedFileSize")
    public static Object[][] validFileSizeAndPaddedFileSize() {
        return new Object[][]{{0, 0}, {0, 1}, {0, 15}, {0, 63}, {0, 64}, {63, 63}, {63, 64}, {64, 74}, {65, 129}};
    }

    private static void assertCountingTestFileContents(byte[] contents) {
        Assert.assertEquals((Object)contents, (Object)TestFSDataInputStreamTail.countingTestFileContentsWithLength(contents.length));
    }

    private static byte[] countingTestFileContentsWithLength(int length) {
        byte[] contents = new byte[length];
        int i = 0;
        int b = 0;
        while (i < contents.length) {
            if (b > 127) {
                b = 0;
            }
            contents[i] = (byte)b;
            ++i;
            ++b;
        }
        return contents;
    }
}

