/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.testing.Assertions;
import io.prestosql.plugin.hive.HiveTestUtils;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.spi.ErrorCode;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveTypeTranslator {
    private static final Map<Type, HiveType> TRANSLATION_MAP = ImmutableMap.builder().put((Object)BigintType.BIGINT, (Object)HiveType.HIVE_LONG).put((Object)IntegerType.INTEGER, (Object)HiveType.HIVE_INT).put((Object)SmallintType.SMALLINT, (Object)HiveType.HIVE_SHORT).put((Object)TinyintType.TINYINT, (Object)HiveType.HIVE_BYTE).put((Object)DoubleType.DOUBLE, (Object)HiveType.HIVE_DOUBLE).put((Object)VarcharType.createVarcharType((int)3), (Object)HiveType.valueOf((String)"varchar(3)")).put((Object)VarcharType.VARCHAR, (Object)HiveType.HIVE_STRING).put((Object)DateType.DATE, (Object)HiveType.HIVE_DATE).put((Object)TimestampType.TIMESTAMP_MILLIS, (Object)HiveType.HIVE_TIMESTAMP).put((Object)DecimalType.createDecimalType((int)5, (int)3), (Object)HiveType.valueOf((String)"decimal(5,3)")).put((Object)VarbinaryType.VARBINARY, (Object)HiveType.HIVE_BINARY).put((Object)new ArrayType((Type)TimestampType.TIMESTAMP_MILLIS), (Object)HiveType.valueOf((String)"array<timestamp>")).put((Object)HiveTestUtils.TYPE_MANAGER.getType(TypeSignature.mapType((TypeSignature)BooleanType.BOOLEAN.getTypeSignature(), (TypeSignature)VarbinaryType.VARBINARY.getTypeSignature())), (Object)HiveType.valueOf((String)"map<boolean,binary>")).put((Object)RowType.from(List.of(RowType.field((String)"col0", (Type)IntegerType.INTEGER), RowType.field((String)"col1", (Type)VarbinaryType.VARBINARY))), (Object)HiveType.valueOf((String)"struct<col0:int,col1:binary>")).build();

    @Test
    public void testTypeTranslator() {
        TRANSLATION_MAP.forEach(TestHiveTypeTranslator::assertTypeTranslation);
        TestHiveTypeTranslator.assertInvalidTypeTranslation((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarbinaryType.VARBINARY)), StandardErrorCode.NOT_SUPPORTED.toErrorCode(), "Anonymous row type is not supported in Hive. Please give each field a name: row(integer, varbinary)");
    }

    private static void assertTypeTranslation(Type type, HiveType hiveType) {
        Assert.assertEquals((Object)HiveType.toHiveType((Type)type), (Object)hiveType);
    }

    private static void assertInvalidTypeTranslation(Type type, ErrorCode errorCode, String message) {
        try {
            HiveType.toHiveType((Type)type);
            Assert.fail((String)"expected exception");
        }
        catch (PrestoException e) {
            try {
                Assert.assertEquals((Object)e.getErrorCode(), (Object)errorCode);
                Assertions.assertContains((String)e.getMessage(), (String)message);
            }
            catch (Throwable failure) {
                failure.addSuppressed(e);
                throw failure;
            }
        }
    }
}

