/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.util;

import io.airlift.testing.Assertions;
import io.prestosql.plugin.hive.HiveStorageFormat;
import io.prestosql.plugin.hive.util.HiveUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat;
import org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat;
import org.apache.hadoop.hive.serde2.thrift.ThriftDeserializer;
import org.apache.hadoop.hive.serde2.thrift.test.IntString;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveUtil {
    @Test
    public void testParseHiveTimestamp() {
        DateTime time = new DateTime(2011, 5, 6, 7, 8, 9, 123, DateTimeZone.UTC);
        Assert.assertEquals((long)TestHiveUtil.parse(time, "yyyy-MM-dd HH:mm:ss"), (long)TestHiveUtil.unixTime(time, 0));
        Assert.assertEquals((long)TestHiveUtil.parse(time, "yyyy-MM-dd HH:mm:ss.S"), (long)TestHiveUtil.unixTime(time, 1));
        Assert.assertEquals((long)TestHiveUtil.parse(time, "yyyy-MM-dd HH:mm:ss.SSS"), (long)TestHiveUtil.unixTime(time, 3));
        Assert.assertEquals((long)TestHiveUtil.parse(time, "yyyy-MM-dd HH:mm:ss.SSSSSSS"), (long)TestHiveUtil.unixTime(time, 6));
        Assert.assertEquals((long)TestHiveUtil.parse(time, "yyyy-MM-dd HH:mm:ss.SSSSSSSSS"), (long)TestHiveUtil.unixTime(time, 7));
    }

    @Test
    public void testGetThriftDeserializer() {
        Properties schema = new Properties();
        schema.setProperty("serialization.lib", ThriftDeserializer.class.getName());
        schema.setProperty("serialization.class", IntString.class.getName());
        schema.setProperty("serialization.format", TBinaryProtocol.class.getName());
        Assertions.assertInstanceOf((Object)HiveUtil.getDeserializer((Configuration)new Configuration(false), (Properties)schema), ThriftDeserializer.class);
    }

    @Test
    public void testToPartitionValues() throws MetaException {
        TestHiveUtil.assertToPartitionValues("ds=2015-12-30/event_type=QueryCompletion");
        TestHiveUtil.assertToPartitionValues("ds=2015-12-30");
        TestHiveUtil.assertToPartitionValues("a=1/b=2/c=3");
        TestHiveUtil.assertToPartitionValues("a=1");
        TestHiveUtil.assertToPartitionValues("pk=!@%23$%25%5E&%2A()%2F%3D");
        TestHiveUtil.assertToPartitionValues("pk=__HIVE_DEFAULT_PARTITION__");
    }

    @Test
    public void testGetInputFormat() {
        Configuration configuration = new Configuration(false);
        Properties avroSymlinkSchema = new Properties();
        avroSymlinkSchema.setProperty("file.inputformat", SymlinkTextInputFormat.class.getName());
        avroSymlinkSchema.setProperty("serialization.lib", HiveStorageFormat.AVRO.getSerDe());
        Assertions.assertInstanceOf((Object)HiveUtil.getInputFormat((Configuration)configuration, (Properties)avroSymlinkSchema, (boolean)false), SymlinkTextInputFormat.class);
        Assertions.assertInstanceOf((Object)HiveUtil.getInputFormat((Configuration)configuration, (Properties)avroSymlinkSchema, (boolean)true), AvroContainerInputFormat.class);
        Properties parquetSymlinkSchema = new Properties();
        parquetSymlinkSchema.setProperty("file.inputformat", SymlinkTextInputFormat.class.getName());
        parquetSymlinkSchema.setProperty("serialization.lib", HiveStorageFormat.PARQUET.getSerDe());
        Assertions.assertInstanceOf((Object)HiveUtil.getInputFormat((Configuration)configuration, (Properties)parquetSymlinkSchema, (boolean)false), SymlinkTextInputFormat.class);
        Assertions.assertInstanceOf((Object)HiveUtil.getInputFormat((Configuration)configuration, (Properties)parquetSymlinkSchema, (boolean)true), MapredParquetInputFormat.class);
        Properties parquetSchema = new Properties();
        parquetSchema.setProperty("file.inputformat", HiveStorageFormat.PARQUET.getInputFormat());
        Assertions.assertInstanceOf((Object)HiveUtil.getInputFormat((Configuration)configuration, (Properties)parquetSchema, (boolean)false), MapredParquetInputFormat.class);
        Assertions.assertInstanceOf((Object)HiveUtil.getInputFormat((Configuration)configuration, (Properties)parquetSchema, (boolean)true), MapredParquetInputFormat.class);
        Properties legacyParquetSchema = new Properties();
        legacyParquetSchema.setProperty("file.inputformat", "parquet.hive.MapredParquetInputFormat");
        Assertions.assertInstanceOf((Object)HiveUtil.getInputFormat((Configuration)configuration, (Properties)legacyParquetSchema, (boolean)false), MapredParquetInputFormat.class);
        Assertions.assertInstanceOf((Object)HiveUtil.getInputFormat((Configuration)configuration, (Properties)legacyParquetSchema, (boolean)true), MapredParquetInputFormat.class);
    }

    private static void assertToPartitionValues(String partitionName) throws MetaException {
        List actual = HiveUtil.toPartitionValues((String)partitionName);
        ArrayList expected = new ArrayList();
        actual.forEach(s -> expected.add(null));
        Warehouse.makeValsFromName((String)partitionName, expected);
        Assert.assertEquals((Collection)actual, expected);
    }

    private static long parse(DateTime time, String pattern) {
        return HiveUtil.parseHiveTimestamp((String)DateTimeFormat.forPattern((String)pattern).print((ReadableInstant)time));
    }

    private static long unixTime(DateTime time, int factionalDigits) {
        int factor = (int)Math.pow(10.0, Math.max(0, 3 - factionalDigits));
        return time.getMillis() / (long)factor * (long)factor * 1000L;
    }

    public static DateTimeZone nonDefaultTimeZone() {
        String defaultId = DateTimeZone.getDefault().getID();
        for (String id : DateTimeZone.getAvailableIDs()) {
            DateTimeZone zone;
            if (id.equals(defaultId) || (zone = DateTimeZone.forID((String)id)).getStandardOffset(0L) == 0) continue;
            return zone;
        }
        throw new IllegalStateException("no non-default timezone");
    }
}

