/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.util;

import com.google.common.collect.ImmutableMap;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazyMap;
import org.apache.hadoop.hive.serde2.lazy.LazyString;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyPrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.Text;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestLazyMap {
    private static final LazyStringObjectInspector LAZY_STRING_OBJECT_INSPECTOR = LazyPrimitiveObjectInspectorFactory.getLazyStringObjectInspector((boolean)false, (byte)0);

    @Test
    public void test() {
        TestLazyMap.assertMapDecode("\\N\u0003ignored", (Map<? extends Object, ? extends Object>)ImmutableMap.of());
        TestLazyMap.assertMapDecode("\\N\u0003ignored\u0002alice\u0003apple", (Map<? extends Object, ? extends Object>)ImmutableMap.of((Object)TestLazyMap.lazyString("alice"), (Object)TestLazyMap.lazyString("apple")));
        TestLazyMap.assertMapDecode("alice\u0003apple\u0002\\N\u0003ignored", (Map<? extends Object, ? extends Object>)ImmutableMap.of((Object)TestLazyMap.lazyString("alice"), (Object)TestLazyMap.lazyString("apple")));
        TestLazyMap.assertMapDecode("alice\u0003apple\u0002\\N\u0003ignored\u0002bob\u0003banana", (Map<? extends Object, ? extends Object>)ImmutableMap.of((Object)TestLazyMap.lazyString("alice"), (Object)TestLazyMap.lazyString("apple"), (Object)TestLazyMap.lazyString("bob"), (Object)TestLazyMap.lazyString("banana")));
        TestLazyMap.assertMapDecode("\\N\u0003ignored\u0002\u0003", (Map<? extends Object, ? extends Object>)ImmutableMap.of((Object)TestLazyMap.lazyString(""), (Object)TestLazyMap.lazyString("")));
        HashMap<String, Object> expectedMap = new HashMap<String, Object>();
        expectedMap.put("null", null);
        TestLazyMap.assertMapDecode("\\N\u0003ignored\u0002null\u0003\\N", expectedMap);
    }

    public static void assertMapDecode(String encodedMap, Map<? extends Object, ? extends Object> expectedMap) {
        LazyMap lazyMap = (LazyMap)LazyFactory.createLazyObject((ObjectInspector)LazyObjectInspectorFactory.getLazySimpleMapObjectInspector((ObjectInspector)LAZY_STRING_OBJECT_INSPECTOR, (ObjectInspector)LazyPrimitiveObjectInspectorFactory.getLazyStringObjectInspector((boolean)false, (byte)0), (byte)2, (byte)3, (Text)new Text("\\N"), (boolean)false, (byte)0));
        lazyMap.init(TestLazyMap.newByteArrayRef(encodedMap), 0, encodedMap.length());
        Map map = lazyMap.getMap();
        Assert.assertEquals((Map)map, expectedMap);
    }

    private static LazyString lazyString(String string) {
        LazyString lazyString = new LazyString(LAZY_STRING_OBJECT_INSPECTOR);
        lazyString.init(TestLazyMap.newByteArrayRef(string), 0, string.length());
        return lazyString;
    }

    public static ByteArrayRef newByteArrayRef(String encodedMap) {
        ByteArrayRef bytes = new ByteArrayRef();
        bytes.setData(encodedMap.getBytes(StandardCharsets.US_ASCII));
        return bytes;
    }
}

