/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.util;

import com.google.common.reflect.Reflection;
import io.prestosql.plugin.base.util.LoggingInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.testng.annotations.Test;

public class TestLoggingInvocationHandlerWithHiveMetastore {
    private static final String DURATION_PATTERN = "\\d+(\\.\\d+)?\\w{1,2}";

    @Test
    public void testWithThriftHiveMetastoreClient() throws Exception {
        ArrayList messages = new ArrayList();
        ThriftHiveMetastore.Iface proxy = (ThriftHiveMetastore.Iface)Reflection.newProxy(ThriftHiveMetastore.Iface.class, (InvocationHandler)new LoggingInvocationHandler((Object)TestLoggingInvocationHandlerWithHiveMetastore.dummyThriftHiveMetastoreClient(), (LoggingInvocationHandler.ParameterNamesProvider)new LoggingInvocationHandler.AirliftParameterNamesProvider(ThriftHiveMetastore.Iface.class, ThriftHiveMetastore.Client.class), messages::add));
        proxy.get_table("some_database", "some_table_name");
        ((ObjectAssert)((ListAssert)Assertions.assertThat(messages).hasSize(1)).element(0)).matches(message -> message.matches("\\QInvocation of get_table(dbname='some_database', tbl_name='some_table_name') succeeded in\\E \\d+(\\.\\d+)?\\w{1,2}"));
    }

    private static ThriftHiveMetastore.Iface dummyThriftHiveMetastoreClient() {
        return (ThriftHiveMetastore.Iface)Proxy.newProxyInstance(TestLoggingInvocationHandlerWithHiveMetastore.class.getClassLoader(), new Class[]{ThriftHiveMetastore.Iface.class}, (proxy, method, args) -> null);
    }
}

