/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.prestosql.block.BlockSerdeUtil;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.plugin.hive.HiveTestUtils;
import io.prestosql.plugin.hive.util.SerDeUtils;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.MapType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.testing.StructuralTestUtil;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.io.BytesWritable;
import org.joda.time.DateTime;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSerDeUtils {
    private final BlockEncodingSerde blockEncodingSerde = MetadataManager.createTestMetadataManager().getBlockEncodingSerde();

    private static synchronized ObjectInspector getInspector(Type type) {
        return ObjectInspectorFactory.getReflectionObjectInspector((Type)type, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
    }

    @Test
    public void testPrimitiveSlice() {
        Block expectedBoolean = VarbinaryType.VARBINARY.createBlockBuilder(null, 1).writeByte(1).closeEntry().build();
        Block actualBoolean = TestSerDeUtils.toBinaryBlock((io.prestosql.spi.type.Type)BooleanType.BOOLEAN, true, TestSerDeUtils.getInspector(Boolean.class));
        this.assertBlockEquals(actualBoolean, expectedBoolean);
        Block expectedByte = VarbinaryType.VARBINARY.createBlockBuilder(null, 1).writeByte(5).closeEntry().build();
        Block actualByte = TestSerDeUtils.toBinaryBlock((io.prestosql.spi.type.Type)TinyintType.TINYINT, (byte)5, TestSerDeUtils.getInspector(Byte.class));
        this.assertBlockEquals(actualByte, expectedByte);
        Block expectedShort = VarbinaryType.VARBINARY.createBlockBuilder(null, 1).writeShort(2).closeEntry().build();
        Block actualShort = TestSerDeUtils.toBinaryBlock((io.prestosql.spi.type.Type)SmallintType.SMALLINT, (short)2, TestSerDeUtils.getInspector(Short.class));
        this.assertBlockEquals(actualShort, expectedShort);
        Block expectedInt = VarbinaryType.VARBINARY.createBlockBuilder(null, 1).writeInt(1).closeEntry().build();
        Block actualInt = TestSerDeUtils.toBinaryBlock((io.prestosql.spi.type.Type)IntegerType.INTEGER, 1, TestSerDeUtils.getInspector(Integer.class));
        this.assertBlockEquals(actualInt, expectedInt);
        Block expectedLong = VarbinaryType.VARBINARY.createBlockBuilder(null, 1).writeLong(10L).closeEntry().build();
        Block actualLong = TestSerDeUtils.toBinaryBlock((io.prestosql.spi.type.Type)BigintType.BIGINT, 10L, TestSerDeUtils.getInspector(Long.class));
        this.assertBlockEquals(actualLong, expectedLong);
        Block expectedFloat = VarbinaryType.VARBINARY.createBlockBuilder(null, 1).writeInt(Float.floatToRawIntBits(20.0f)).closeEntry().build();
        Block actualFloat = TestSerDeUtils.toBinaryBlock((io.prestosql.spi.type.Type)RealType.REAL, Float.valueOf(20.0f), TestSerDeUtils.getInspector(Float.class));
        this.assertBlockEquals(actualFloat, expectedFloat);
        Block expectedDouble = VarbinaryType.VARBINARY.createBlockBuilder(null, 1).writeLong(Double.doubleToLongBits(30.12)).closeEntry().build();
        Block actualDouble = TestSerDeUtils.toBinaryBlock((io.prestosql.spi.type.Type)DoubleType.DOUBLE, 30.12, TestSerDeUtils.getInspector(Double.class));
        this.assertBlockEquals(actualDouble, expectedDouble);
        Block expectedString = VarbinaryType.VARBINARY.createBlockBuilder(null, 1).writeBytes(Slices.utf8Slice((String)"abdd"), 0, 4).closeEntry().build();
        Block actualString = TestSerDeUtils.toBinaryBlock((io.prestosql.spi.type.Type)VarcharType.createUnboundedVarcharType(), "abdd", TestSerDeUtils.getInspector(String.class));
        this.assertBlockEquals(actualString, expectedString);
        int date = Math.toIntExact(LocalDate.of(2008, 10, 28).toEpochDay());
        Block expectedDate = VarbinaryType.VARBINARY.createBlockBuilder(null, 1).writeInt(date).closeEntry().build();
        Block actualDate = TestSerDeUtils.toBinaryBlock((io.prestosql.spi.type.Type)DateType.DATE, Date.ofEpochDay((int)date), TestSerDeUtils.getInspector(Date.class));
        this.assertBlockEquals(actualDate, expectedDate);
        DateTime dateTime = new DateTime(2008, 10, 28, 16, 7, 15, 123);
        Block expectedTimestamp = VarbinaryType.VARBINARY.createBlockBuilder(null, 1).writeLong(dateTime.getMillis() * 1000L).closeEntry().build();
        Block actualTimestamp = TestSerDeUtils.toBinaryBlock((io.prestosql.spi.type.Type)TimestampType.TIMESTAMP_MILLIS, Timestamp.ofEpochMilli((long)dateTime.getMillis()), TestSerDeUtils.getInspector(Timestamp.class));
        this.assertBlockEquals(actualTimestamp, expectedTimestamp);
        byte[] byteArray = new byte[]{81, 82, 84, 85};
        Block expectedBinary = VarbinaryType.VARBINARY.createBlockBuilder(null, 1).writeBytes(Slices.wrappedBuffer((byte[])byteArray), 0, 4).closeEntry().build();
        Block actualBinary = TestSerDeUtils.toBinaryBlock((io.prestosql.spi.type.Type)VarbinaryType.VARBINARY, byteArray, TestSerDeUtils.getInspector(byte[].class));
        this.assertBlockEquals(actualBinary, expectedBinary);
    }

    @Test
    public void testListBlock() {
        ArrayList<InnerStruct> array = new ArrayList<InnerStruct>(2);
        array.add(new InnerStruct(8, 9L));
        array.add(new InnerStruct(10, 11L));
        ListHolder listHolder = new ListHolder();
        listHolder.array = array;
        RowType rowType = RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)BigintType.BIGINT));
        RowType arrayOfRowType = RowType.anonymous((List)ImmutableList.of((Object)new ArrayType((io.prestosql.spi.type.Type)rowType)));
        Block actual = TestSerDeUtils.toBinaryBlock((io.prestosql.spi.type.Type)arrayOfRowType, listHolder, TestSerDeUtils.getInspector(ListHolder.class));
        BlockBuilder blockBuilder = rowType.createBlockBuilder(null, 1024);
        rowType.writeObject(blockBuilder, (Object)StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)BigintType.BIGINT), (Object[])new Object[]{8, 9L}));
        rowType.writeObject(blockBuilder, (Object)StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)BigintType.BIGINT), (Object[])new Object[]{10, 11L}));
        Block expected = StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)new ArrayType((io.prestosql.spi.type.Type)rowType)), (Object[])new Object[]{blockBuilder.build()});
        this.assertBlockEquals(actual, expected);
    }

    @Test
    public void testMapBlock() {
        MapHolder holder = new MapHolder();
        holder.map = new TreeMap<String, InnerStruct>();
        holder.map.put("twelve", new InnerStruct(13, 14L));
        holder.map.put("fifteen", new InnerStruct(16, 17L));
        RowType rowType = RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)BigintType.BIGINT));
        RowType rowOfMapOfVarcharRowType = RowType.anonymous((List)ImmutableList.of((Object)HiveTestUtils.mapType((io.prestosql.spi.type.Type)VarcharType.VARCHAR, (io.prestosql.spi.type.Type)rowType)));
        Block actual = TestSerDeUtils.toBinaryBlock((io.prestosql.spi.type.Type)rowOfMapOfVarcharRowType, holder, TestSerDeUtils.getInspector(MapHolder.class));
        Block mapBlock = StructuralTestUtil.mapBlockOf((io.prestosql.spi.type.Type)VarcharType.VARCHAR, (io.prestosql.spi.type.Type)rowType, (Object[])new Object[]{Slices.utf8Slice((String)"fifteen"), Slices.utf8Slice((String)"twelve")}, (Object[])new Object[]{StructuralTestUtil.rowBlockOf((List)rowType.getTypeParameters(), (Object[])new Object[]{16, 17L}), StructuralTestUtil.rowBlockOf((List)rowType.getTypeParameters(), (Object[])new Object[]{13, 14L})});
        Block expected = StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)HiveTestUtils.mapType((io.prestosql.spi.type.Type)VarcharType.VARCHAR, (io.prestosql.spi.type.Type)rowType)), (Object[])new Object[]{mapBlock});
        this.assertBlockEquals(actual, expected);
    }

    @Test
    public void testStructBlock() {
        InnerStruct innerStruct = new InnerStruct(13, 14L);
        RowType rowType = RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)BigintType.BIGINT));
        Block actual = TestSerDeUtils.toBinaryBlock((io.prestosql.spi.type.Type)rowType, innerStruct, TestSerDeUtils.getInspector(InnerStruct.class));
        Block expected = StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)BigintType.BIGINT), (Object[])new Object[]{13, 14L});
        this.assertBlockEquals(actual, expected);
        OuterStruct outerStruct = new OuterStruct();
        outerStruct.byteVal = 1;
        outerStruct.shortVal = 2;
        outerStruct.intVal = 3;
        outerStruct.longVal = 4L;
        outerStruct.floatVal = Float.valueOf(5.01f);
        outerStruct.doubleVal = 6.001;
        outerStruct.stringVal = "seven";
        outerStruct.byteArray = new byte[]{50};
        InnerStruct is1 = new InnerStruct(2, -5L);
        InnerStruct is2 = new InnerStruct(-10, 0L);
        outerStruct.structArray = new ArrayList<InnerStruct>(2);
        outerStruct.structArray.add(is1);
        outerStruct.structArray.add(is2);
        outerStruct.map = new TreeMap<String, InnerStruct>();
        outerStruct.map.put("twelve", new InnerStruct(0, 5L));
        outerStruct.map.put("fifteen", new InnerStruct(-5, -10L));
        outerStruct.innerStruct = new InnerStruct(18, 19L);
        RowType innerRowType = RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)BigintType.BIGINT));
        ArrayType arrayOfInnerRowType = new ArrayType((io.prestosql.spi.type.Type)innerRowType);
        MapType mapOfInnerRowType = HiveTestUtils.mapType((io.prestosql.spi.type.Type)VarcharType.createUnboundedVarcharType(), (io.prestosql.spi.type.Type)innerRowType);
        ImmutableList outerRowParameterTypes = ImmutableList.of((Object)TinyintType.TINYINT, (Object)SmallintType.SMALLINT, (Object)IntegerType.INTEGER, (Object)BigintType.BIGINT, (Object)RealType.REAL, (Object)DoubleType.DOUBLE, (Object)VarcharType.createUnboundedVarcharType(), (Object)VarcharType.createUnboundedVarcharType(), (Object)arrayOfInnerRowType, (Object)mapOfInnerRowType, (Object)innerRowType);
        RowType outerRowType = RowType.anonymous((List)outerRowParameterTypes);
        actual = TestSerDeUtils.toBinaryBlock((io.prestosql.spi.type.Type)outerRowType, outerStruct, TestSerDeUtils.getInspector(OuterStruct.class));
        ImmutableList.Builder outerRowValues = ImmutableList.builder();
        outerRowValues.add((Object)1);
        outerRowValues.add((Object)2);
        outerRowValues.add((Object)3);
        outerRowValues.add((Object)4L);
        outerRowValues.add((Object)Float.valueOf(5.01f));
        outerRowValues.add((Object)6.001);
        outerRowValues.add((Object)"seven");
        outerRowValues.add((Object)new byte[]{50});
        outerRowValues.add((Object)StructuralTestUtil.arrayBlockOf((io.prestosql.spi.type.Type)innerRowType, (Object[])new Object[]{StructuralTestUtil.rowBlockOf((List)innerRowType.getTypeParameters(), (Object[])new Object[]{2, -5L}), StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)BigintType.BIGINT), (Object[])new Object[]{-10, 0L})}));
        outerRowValues.add((Object)StructuralTestUtil.mapBlockOf((io.prestosql.spi.type.Type)VarcharType.VARCHAR, (io.prestosql.spi.type.Type)innerRowType, (Object[])new Object[]{Slices.utf8Slice((String)"fifteen"), Slices.utf8Slice((String)"twelve")}, (Object[])new Object[]{StructuralTestUtil.rowBlockOf((List)innerRowType.getTypeParameters(), (Object[])new Object[]{-5, -10L}), StructuralTestUtil.rowBlockOf((List)innerRowType.getTypeParameters(), (Object[])new Object[]{0, 5L})}));
        outerRowValues.add((Object)StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)BigintType.BIGINT), (Object[])new Object[]{18, 19L}));
        this.assertBlockEquals(actual, StructuralTestUtil.rowBlockOf((List)outerRowParameterTypes, (Object[])outerRowValues.build().toArray()));
    }

    @Test
    public void testReuse() {
        BytesWritable value = new BytesWritable();
        byte[] first = "hello world".getBytes(StandardCharsets.UTF_8);
        value.set(first, 0, first.length);
        byte[] second = "bye".getBytes(StandardCharsets.UTF_8);
        value.set(second, 0, second.length);
        Type type = new TypeToken<Map<BytesWritable, Long>>(){}.getType();
        ObjectInspector inspector = TestSerDeUtils.getInspector(type);
        Block actual = SerDeUtils.getBlockObject((io.prestosql.spi.type.Type)HiveTestUtils.mapType((io.prestosql.spi.type.Type)VarcharType.createUnboundedVarcharType(), (io.prestosql.spi.type.Type)BigintType.BIGINT), (Object)ImmutableMap.of((Object)value, (Object)0L), (ObjectInspector)inspector);
        Block expected = StructuralTestUtil.mapBlockOf((io.prestosql.spi.type.Type)VarcharType.createUnboundedVarcharType(), (io.prestosql.spi.type.Type)BigintType.BIGINT, (Object)"bye", (Object)0L);
        this.assertBlockEquals(actual, expected);
    }

    private void assertBlockEquals(Block actual, Block expected) {
        Assert.assertEquals((Object)this.blockToSlice(actual), (Object)this.blockToSlice(expected));
    }

    private Slice blockToSlice(Block block) {
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(1000);
        BlockSerdeUtil.writeBlock((BlockEncodingSerde)this.blockEncodingSerde, (SliceOutput)sliceOutput, (Block)block);
        return sliceOutput.slice();
    }

    private static Block toBinaryBlock(io.prestosql.spi.type.Type type, Object object, ObjectInspector inspector) {
        if (inspector.getCategory() == ObjectInspector.Category.PRIMITIVE) {
            return TestSerDeUtils.getPrimitiveBlock(type, object, inspector);
        }
        return SerDeUtils.getBlockObject((io.prestosql.spi.type.Type)type, (Object)object, (ObjectInspector)inspector);
    }

    private static Block getPrimitiveBlock(io.prestosql.spi.type.Type type, Object object, ObjectInspector inspector) {
        BlockBuilder builder = VarbinaryType.VARBINARY.createBlockBuilder(null, 1);
        SerDeUtils.serializeObject((io.prestosql.spi.type.Type)type, (BlockBuilder)builder, (Object)object, (ObjectInspector)inspector);
        return builder.build();
    }

    private static class MapHolder {
        Map<String, InnerStruct> map;

        private MapHolder() {
        }
    }

    private static class OuterStruct {
        Byte byteVal;
        Short shortVal;
        Integer intVal;
        Long longVal;
        Float floatVal;
        Double doubleVal;
        String stringVal;
        byte[] byteArray;
        List<InnerStruct> structArray;
        Map<String, InnerStruct> map;
        InnerStruct innerStruct;

        private OuterStruct() {
        }
    }

    private static class InnerStruct {
        Integer intVal;
        Long longVal;

        public InnerStruct(Integer intVal, Long longVal) {
            this.intVal = intVal;
            this.longVal = longVal;
        }
    }

    private static class ListHolder {
        List<InnerStruct> array;

        private ListHolder() {
        }
    }
}

