/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.util;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.prestosql.plugin.hive.util.AsyncQueue;
import io.prestosql.plugin.hive.util.ThrottledAsyncQueue;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestThrottledAsyncQueue {
    private ExecutorService executor;

    @BeforeClass
    public void setUpClass() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"TestThrottledAsyncQueue-%s"));
    }

    @AfterClass(alwaysRun=true)
    public void tearDownClass() {
        this.executor.shutdownNow();
        this.executor = null;
    }

    @Test(timeOut=10000L)
    public void testThrottle() {
        ThrottledAsyncQueue queue = new ThrottledAsyncQueue(3, 10, (Executor)this.executor);
        Assert.assertTrue((boolean)queue.offer((Object)1).isDone());
        Assert.assertTrue((boolean)queue.offer((Object)2).isDone());
        Assert.assertTrue((boolean)queue.offer((Object)3).isDone());
        Assert.assertTrue((boolean)queue.offer((Object)4).isDone());
        Assert.assertTrue((boolean)queue.offer((Object)5).isDone());
        Assert.assertTrue((boolean)queue.offer((Object)6).isDone());
        queue.finish();
        ListenableFuture future1 = queue.getBatchAsync(2);
        Assert.assertTrue((boolean)future1.isDone());
        Assert.assertEquals((Collection)((Collection)MoreFutures.getFutureValue((Future)future1)), (Collection)ImmutableList.of((Object)1, (Object)2));
        Assert.assertFalse((boolean)queue.isFinished());
        ListenableFuture future2 = queue.getBatchAsync(2);
        Assert.assertFalse((boolean)future2.isDone());
        Assert.assertEquals((Collection)((Collection)MoreFutures.getFutureValue((Future)future2)), (Collection)ImmutableList.of((Object)3, (Object)4));
        Assert.assertFalse((boolean)queue.isFinished());
        ListenableFuture future3 = queue.getBatchAsync(2);
        Assert.assertFalse((boolean)future3.isDone());
        Assert.assertEquals((Collection)((Collection)MoreFutures.getFutureValue((Future)future3)), (Collection)ImmutableList.of((Object)5, (Object)6));
        Assert.assertTrue((boolean)queue.isFinished());
    }

    @Test(timeOut=10000L)
    public void testThrottleEmptyQueue() throws Exception {
        ThrottledAsyncQueue queue = new ThrottledAsyncQueue(2, 10, (Executor)this.executor);
        Assert.assertTrue((boolean)queue.offer((Object)1).isDone());
        Assert.assertTrue((boolean)queue.offer((Object)2).isDone());
        ListenableFuture future1 = queue.getBatchAsync(2);
        Assert.assertTrue((boolean)future1.isDone());
        Assert.assertEquals((Collection)((Collection)MoreFutures.getFutureValue((Future)future1)), (Collection)ImmutableList.of((Object)1, (Object)2));
        Assert.assertFalse((boolean)queue.isFinished());
        ListenableFuture future2 = queue.getBatchAsync(2);
        Assert.assertFalse((boolean)future2.isDone());
        Thread.sleep(1000L);
        Assert.assertFalse((boolean)future2.isDone());
        Assert.assertTrue((boolean)queue.offer((Object)3).isDone());
        queue.finish();
        Assert.assertEquals((Collection)((Collection)MoreFutures.getFutureValue((Future)future2)), (Collection)ImmutableList.of((Object)3));
        Assert.assertTrue((boolean)queue.isFinished());
    }

    @Test(timeOut=10000L)
    public void testBorrowThrows() throws Exception {
        ThrottledAsyncQueue queue = new ThrottledAsyncQueue(100, 4, (Executor)this.executor);
        queue.offer((Object)1);
        queue.offer((Object)2);
        queue.offer((Object)3);
        queue.offer((Object)4);
        queue.offer((Object)5);
        ListenableFuture future1 = queue.offer((Object)6);
        Assert.assertFalse((boolean)future1.isDone());
        Runnable runnable = () -> TestThrottledAsyncQueue.lambda$testBorrowThrows$1((AsyncQueue)queue);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.executor.submit(runnable).get()).isInstanceOf(ExecutionException.class)).hasMessageContaining("test fail");
        ListenableFuture future2 = queue.offer((Object)7);
        Assert.assertFalse((boolean)future1.isDone());
        Assert.assertFalse((boolean)future2.isDone());
        queue.finish();
        future1.get();
        future2.get();
        Assert.assertTrue((boolean)queue.offer((Object)8).isDone());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.executor.submit(runnable).get()).isInstanceOf(ExecutionException.class)).hasMessageContaining("test fail");
        Assert.assertTrue((boolean)queue.offer((Object)9).isDone());
        Assert.assertFalse((boolean)queue.isFinished());
        Assert.assertEquals((Collection)((Collection)queue.getBatchAsync(100).get()), (Collection)ImmutableList.of((Object)3, (Object)4, (Object)5, (Object)6, (Object)7));
        Assert.assertTrue((boolean)queue.isFinished());
    }

    @Test(timeOut=10000L)
    public void testGetPartial() throws Exception {
        ThrottledAsyncQueue queue = new ThrottledAsyncQueue(100, 4, (Executor)this.executor);
        queue.offer((Object)"1");
        queue.offer((Object)"2");
        queue.offer((Object)"3");
        Assert.assertEquals((Collection)((Collection)queue.getBatchAsync(100).get()), (Collection)ImmutableList.of((Object)"1", (Object)"2", (Object)"3"));
        queue.finish();
        Assert.assertTrue((boolean)queue.isFinished());
    }

    @Test(timeOut=10000L)
    public void testFullQueue() throws Exception {
        ThrottledAsyncQueue queue = new ThrottledAsyncQueue(100, 4, (Executor)this.executor);
        Assert.assertTrue((boolean)queue.offer((Object)"1").isDone());
        Assert.assertTrue((boolean)queue.offer((Object)"2").isDone());
        Assert.assertTrue((boolean)queue.offer((Object)"3").isDone());
        Assert.assertFalse((boolean)queue.offer((Object)"4").isDone());
        Assert.assertFalse((boolean)queue.offer((Object)"5").isDone());
        ListenableFuture offerFuture = queue.offer((Object)"6");
        Assert.assertFalse((boolean)offerFuture.isDone());
        Assert.assertEquals((Collection)((Collection)queue.getBatchAsync(2).get()), (Collection)ImmutableList.of((Object)"1", (Object)"2"));
        Assert.assertFalse((boolean)offerFuture.isDone());
        Assert.assertEquals((Collection)((Collection)queue.getBatchAsync(1).get()), (Collection)ImmutableList.of((Object)"3"));
        offerFuture.get();
        offerFuture = queue.offer((Object)"7");
        Assert.assertFalse((boolean)offerFuture.isDone());
        queue.finish();
        offerFuture.get();
        Assert.assertFalse((boolean)queue.isFinished());
        Assert.assertEquals((Collection)((Collection)queue.getBatchAsync(4).get()), (Collection)ImmutableList.of((Object)"4", (Object)"5", (Object)"6", (Object)"7"));
        Assert.assertTrue((boolean)queue.isFinished());
    }

    @Test(timeOut=10000L)
    public void testEmptyQueue() throws Exception {
        ThrottledAsyncQueue queue = new ThrottledAsyncQueue(100, 4, (Executor)this.executor);
        Assert.assertTrue((boolean)queue.offer((Object)"1").isDone());
        Assert.assertTrue((boolean)queue.offer((Object)"2").isDone());
        Assert.assertTrue((boolean)queue.offer((Object)"3").isDone());
        Assert.assertEquals((Collection)((Collection)queue.getBatchAsync(2).get()), (Collection)ImmutableList.of((Object)"1", (Object)"2"));
        Assert.assertEquals((Collection)((Collection)queue.getBatchAsync(2).get()), (Collection)ImmutableList.of((Object)"3"));
        ListenableFuture batchFuture = queue.getBatchAsync(2);
        Assert.assertFalse((boolean)batchFuture.isDone());
        Assert.assertTrue((boolean)queue.offer((Object)"4").isDone());
        Assert.assertEquals((Object)batchFuture.get(), (Object)ImmutableList.of((Object)"4"));
        batchFuture = queue.getBatchAsync(2);
        Assert.assertFalse((boolean)batchFuture.isDone());
        queue.finish();
        batchFuture.get();
        Assert.assertTrue((boolean)queue.isFinished());
    }

    @Test(timeOut=10000L)
    public void testOfferAfterFinish() throws Exception {
        ThrottledAsyncQueue queue = new ThrottledAsyncQueue(100, 4, (Executor)this.executor);
        Assert.assertTrue((boolean)queue.offer((Object)"1").isDone());
        Assert.assertTrue((boolean)queue.offer((Object)"2").isDone());
        Assert.assertTrue((boolean)queue.offer((Object)"3").isDone());
        Assert.assertFalse((boolean)queue.offer((Object)"4").isDone());
        queue.finish();
        Assert.assertTrue((boolean)queue.offer((Object)"5").isDone());
        Assert.assertTrue((boolean)queue.offer((Object)"6").isDone());
        Assert.assertTrue((boolean)queue.offer((Object)"7").isDone());
        Assert.assertFalse((boolean)queue.isFinished());
        Assert.assertEquals((Collection)((Collection)queue.getBatchAsync(100).get()), (Collection)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"4"));
        Assert.assertTrue((boolean)queue.isFinished());
    }

    private static /* synthetic */ void lambda$testBorrowThrows$1(AsyncQueue queue) {
        MoreFutures.getFutureValue((Future)queue.borrowBatchAsync(1, elements -> {
            throw new RuntimeException("test fail");
        }));
    }
}

