/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.hadoop.TextLineLengthLimitExceededException;
import io.prestosql.plugin.base.type.DecodedTimestamp;
import io.prestosql.plugin.base.type.PrestoTimestampEncoder;
import io.prestosql.plugin.base.type.PrestoTimestampEncoderFactory;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.util.HiveUtil;
import io.prestosql.plugin.hive.util.SerDeUtils;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.connector.RecordCursor;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.CharType;
import io.prestosql.spi.type.Chars;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.spi.type.Varchars;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.RecordReader;
import org.joda.time.DateTimeZone;

public class GenericHiveRecordCursor<K, V extends Writable>
implements RecordCursor {
    private final Path path;
    private final RecordReader<K, V> recordReader;
    private final K key;
    private final V value;
    private final Deserializer deserializer;
    private final Type[] types;
    private final HiveType[] hiveTypes;
    private final StructObjectInspector rowInspector;
    private final ObjectInspector[] fieldInspectors;
    private final StructField[] structFields;
    private final boolean[] loaded;
    private final boolean[] booleans;
    private final long[] longs;
    private final double[] doubles;
    private final Slice[] slices;
    private final Object[] objects;
    private final boolean[] nulls;
    private final PrestoTimestampEncoder<?>[] timestampEncoders;
    private final long totalBytes;
    private long completedBytes;
    private Object rowData;
    private boolean closed;

    public GenericHiveRecordCursor(Configuration configuration, Path path, RecordReader<K, V> recordReader, long totalBytes, Properties splitSchema, List<HiveColumnHandle> columns) {
        Objects.requireNonNull(path, "path is null");
        Objects.requireNonNull(recordReader, "recordReader is null");
        Preconditions.checkArgument((totalBytes >= 0L ? 1 : 0) != 0, (Object)"totalBytes is negative");
        Objects.requireNonNull(splitSchema, "splitSchema is null");
        Objects.requireNonNull(columns, "columns is null");
        this.path = path;
        this.recordReader = recordReader;
        this.totalBytes = totalBytes;
        this.key = recordReader.createKey();
        this.value = (Writable)recordReader.createValue();
        this.deserializer = HiveUtil.getDeserializer(configuration, splitSchema);
        this.rowInspector = HiveUtil.getTableObjectInspector(this.deserializer);
        int size = columns.size();
        this.types = new Type[size];
        this.hiveTypes = new HiveType[size];
        this.structFields = new StructField[size];
        this.fieldInspectors = new ObjectInspector[size];
        this.loaded = new boolean[size];
        this.booleans = new boolean[size];
        this.longs = new long[size];
        this.doubles = new double[size];
        this.slices = new Slice[size];
        this.objects = new Object[size];
        this.nulls = new boolean[size];
        this.timestampEncoders = new PrestoTimestampEncoder[size];
        for (int i = 0; i < columns.size(); ++i) {
            StructField field;
            Type columnType;
            HiveColumnHandle column = columns.get(i);
            Preconditions.checkState((column.getColumnType() == HiveColumnHandle.ColumnType.REGULAR ? 1 : 0) != 0, (Object)"column type must be regular");
            this.types[i] = columnType = column.getType();
            if (columnType instanceof TimestampType) {
                this.timestampEncoders[i] = PrestoTimestampEncoderFactory.createTimestampEncoder((TimestampType)((TimestampType)columnType), (DateTimeZone)DateTimeZone.UTC);
            }
            this.hiveTypes[i] = column.getHiveType();
            this.structFields[i] = field = this.rowInspector.getStructFieldRef(column.getName());
            this.fieldInspectors[i] = field.getFieldObjectInspector();
        }
    }

    public long getCompletedBytes() {
        if (!this.closed) {
            this.updateCompletedBytes();
        }
        return this.completedBytes;
    }

    public long getReadTimeNanos() {
        return 0L;
    }

    private void updateCompletedBytes() {
        try {
            long newCompletedBytes = (long)((float)this.totalBytes * this.recordReader.getProgress());
            this.completedBytes = Math.min(this.totalBytes, Math.max(this.completedBytes, newCompletedBytes));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Type getType(int field) {
        return this.types[field];
    }

    public boolean advanceNextPosition() {
        try {
            if (this.closed || !this.recordReader.next(this.key, this.value)) {
                this.close();
                return false;
            }
            Arrays.fill(this.loaded, false);
            this.rowData = this.deserializer.deserialize(this.value);
            return true;
        }
        catch (IOException | RuntimeException | SerDeException e) {
            HiveUtil.closeWithSuppression(this, e);
            if (e instanceof TextLineLengthLimitExceededException) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, "Line too long in text file: " + this.path, e);
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, e);
        }
    }

    public boolean getBoolean(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, Boolean.TYPE);
        if (!this.loaded[fieldId]) {
            this.parseBooleanColumn(fieldId);
        }
        return this.booleans[fieldId];
    }

    private void parseBooleanColumn(int column) {
        this.loaded[column] = true;
        Object fieldData = this.rowInspector.getStructFieldData(this.rowData, this.structFields[column]);
        if (fieldData == null) {
            this.nulls[column] = true;
        } else {
            Object fieldValue = ((PrimitiveObjectInspector)this.fieldInspectors[column]).getPrimitiveJavaObject(fieldData);
            Preconditions.checkState((fieldValue != null ? 1 : 0) != 0, (Object)"fieldValue should not be null");
            this.booleans[column] = (Boolean)fieldValue;
            this.nulls[column] = false;
        }
    }

    public long getLong(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, Long.TYPE);
        if (!this.loaded[fieldId]) {
            this.parseLongColumn(fieldId);
        }
        return this.longs[fieldId];
    }

    private void parseLongColumn(int column) {
        this.loaded[column] = true;
        Object fieldData = this.rowInspector.getStructFieldData(this.rowData, this.structFields[column]);
        if (fieldData == null) {
            this.nulls[column] = true;
        } else {
            Object fieldValue = ((PrimitiveObjectInspector)this.fieldInspectors[column]).getPrimitiveJavaObject(fieldData);
            Preconditions.checkState((fieldValue != null ? 1 : 0) != 0, (Object)"fieldValue should not be null");
            this.longs[column] = this.getLongExpressedValue(fieldValue, column);
            this.nulls[column] = false;
        }
    }

    private long getLongExpressedValue(Object value, int column) {
        if (value instanceof Date) {
            return ((Date)value).toEpochDay();
        }
        if (value instanceof Timestamp) {
            return this.shortTimestamp((Timestamp)value, column);
        }
        if (value instanceof Float) {
            return Float.floatToRawIntBits(((Float)value).floatValue());
        }
        return ((Number)value).longValue();
    }

    public double getDouble(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, Double.TYPE);
        if (!this.loaded[fieldId]) {
            this.parseDoubleColumn(fieldId);
        }
        return this.doubles[fieldId];
    }

    private void parseDoubleColumn(int column) {
        this.loaded[column] = true;
        Object fieldData = this.rowInspector.getStructFieldData(this.rowData, this.structFields[column]);
        if (fieldData == null) {
            this.nulls[column] = true;
        } else {
            Object fieldValue = ((PrimitiveObjectInspector)this.fieldInspectors[column]).getPrimitiveJavaObject(fieldData);
            Preconditions.checkState((fieldValue != null ? 1 : 0) != 0, (Object)"fieldValue should not be null");
            this.doubles[column] = ((Number)fieldValue).doubleValue();
            this.nulls[column] = false;
        }
    }

    public Slice getSlice(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, Slice.class);
        if (!this.loaded[fieldId]) {
            this.parseStringColumn(fieldId);
        }
        return this.slices[fieldId];
    }

    private void parseStringColumn(int column) {
        this.loaded[column] = true;
        Object fieldData = this.rowInspector.getStructFieldData(this.rowData, this.structFields[column]);
        if (fieldData == null) {
            this.nulls[column] = true;
        } else {
            PrimitiveObjectInspector inspector = (PrimitiveObjectInspector)this.fieldInspectors[column];
            Slice value = inspector.preferWritable() ? GenericHiveRecordCursor.parseStringFromPrimitiveWritableObjectValue(this.types[column], inspector.getPrimitiveWritableObject(fieldData)) : GenericHiveRecordCursor.parseStringFromPrimitiveJavaObjectValue(this.types[column], inspector.getPrimitiveJavaObject(fieldData));
            this.slices[column] = value;
            this.nulls[column] = false;
        }
    }

    private static Slice trimStringToCharacterLimits(Type type, Slice value) {
        if (type instanceof VarcharType) {
            return Varchars.truncateToLength((Slice)value, (Type)type);
        }
        if (type instanceof CharType) {
            return Chars.truncateToLengthAndTrimSpaces((Slice)value, (Type)type);
        }
        return value;
    }

    private static Slice parseStringFromPrimitiveWritableObjectValue(Type type, Object fieldValue) {
        Text hiveValue;
        Preconditions.checkState((fieldValue != null ? 1 : 0) != 0, (Object)"fieldValue should not be null");
        if (fieldValue instanceof Text) {
            hiveValue = (Text)fieldValue;
        } else if (fieldValue instanceof BytesWritable) {
            hiveValue = (BytesWritable)fieldValue;
        } else if (fieldValue instanceof HiveVarcharWritable) {
            hiveValue = ((HiveVarcharWritable)fieldValue).getTextValue();
        } else if (fieldValue instanceof HiveCharWritable) {
            hiveValue = ((HiveCharWritable)fieldValue).getTextValue();
        } else {
            throw new IllegalStateException("unsupported string field type: " + fieldValue.getClass().getName());
        }
        Slice value = GenericHiveRecordCursor.trimStringToCharacterLimits(type, Slices.wrappedBuffer((byte[])hiveValue.getBytes(), (int)0, (int)hiveValue.getLength()));
        return Slices.copyOf((Slice)value);
    }

    private static Slice parseStringFromPrimitiveJavaObjectValue(Type type, Object fieldValue) {
        Slice value;
        Preconditions.checkState((fieldValue != null ? 1 : 0) != 0, (Object)"fieldValue should not be null");
        if (fieldValue instanceof String) {
            value = Slices.utf8Slice((String)((String)fieldValue));
        } else if (fieldValue instanceof byte[]) {
            value = Slices.wrappedBuffer((byte[])((byte[])fieldValue));
        } else if (fieldValue instanceof HiveVarchar) {
            value = Slices.utf8Slice((String)((HiveVarchar)fieldValue).getValue());
        } else if (fieldValue instanceof HiveChar) {
            value = Slices.utf8Slice((String)((HiveChar)fieldValue).getValue());
        } else {
            throw new IllegalStateException("unsupported string field type: " + fieldValue.getClass().getName());
        }
        value = GenericHiveRecordCursor.trimStringToCharacterLimits(type, value);
        if (!value.isCompact()) {
            return Slices.copyOf((Slice)value);
        }
        return value;
    }

    private void parseDecimalColumn(int column) {
        this.loaded[column] = true;
        Object fieldData = this.rowInspector.getStructFieldData(this.rowData, this.structFields[column]);
        if (fieldData == null) {
            this.nulls[column] = true;
        } else {
            Object fieldValue = ((PrimitiveObjectInspector)this.fieldInspectors[column]).getPrimitiveJavaObject(fieldData);
            Preconditions.checkState((fieldValue != null ? 1 : 0) != 0, (Object)"fieldValue should not be null");
            HiveDecimal decimal = (HiveDecimal)fieldValue;
            DecimalType columnType = (DecimalType)this.types[column];
            BigInteger unscaledDecimal = Decimals.rescale((BigInteger)decimal.unscaledValue(), (int)decimal.scale(), (int)columnType.getScale());
            if (columnType.isShort()) {
                this.longs[column] = unscaledDecimal.longValue();
            } else {
                this.slices[column] = Decimals.encodeUnscaledValue((BigInteger)unscaledDecimal);
            }
            this.nulls[column] = false;
        }
    }

    public Object getObject(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        if (!this.loaded[fieldId]) {
            this.parseObjectColumn(fieldId);
        }
        return this.objects[fieldId];
    }

    private void parseObjectColumn(int column) {
        this.loaded[column] = true;
        Object fieldData = this.rowInspector.getStructFieldData(this.rowData, this.structFields[column]);
        if (fieldData == null) {
            this.nulls[column] = true;
        } else {
            Type type = this.types[column];
            if (type.getJavaType() == Block.class) {
                this.objects[column] = SerDeUtils.getBlockObject(type, fieldData, this.fieldInspectors[column]);
            } else if (type instanceof TimestampType) {
                Timestamp timestamp = (Timestamp)((PrimitiveObjectInspector)this.fieldInspectors[column]).getPrimitiveJavaObject(fieldData);
                this.objects[column] = this.longTimestamp(timestamp, column);
            } else {
                throw new IllegalStateException("Unsupported type: " + type);
            }
            this.nulls[column] = false;
        }
    }

    public boolean isNull(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        if (!this.loaded[fieldId]) {
            this.parseColumn(fieldId);
        }
        return this.nulls[fieldId];
    }

    private void parseColumn(int column) {
        Type type = this.types[column];
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            this.parseBooleanColumn(column);
        } else if (BigintType.BIGINT.equals((Object)type)) {
            this.parseLongColumn(column);
        } else if (IntegerType.INTEGER.equals((Object)type)) {
            this.parseLongColumn(column);
        } else if (SmallintType.SMALLINT.equals((Object)type)) {
            this.parseLongColumn(column);
        } else if (TinyintType.TINYINT.equals((Object)type)) {
            this.parseLongColumn(column);
        } else if (RealType.REAL.equals((Object)type)) {
            this.parseLongColumn(column);
        } else if (DoubleType.DOUBLE.equals((Object)type)) {
            this.parseDoubleColumn(column);
        } else if (type instanceof VarcharType || VarbinaryType.VARBINARY.equals((Object)type)) {
            this.parseStringColumn(column);
        } else if (type instanceof CharType) {
            this.parseStringColumn(column);
        } else if (HiveUtil.isStructuralType(this.hiveTypes[column])) {
            this.parseObjectColumn(column);
        } else if (DateType.DATE.equals((Object)type)) {
            this.parseLongColumn(column);
        } else if (type instanceof TimestampType) {
            if (((TimestampType)type).isShort()) {
                this.parseLongColumn(column);
            } else {
                this.parseObjectColumn(column);
            }
        } else if (type instanceof DecimalType) {
            this.parseDecimalColumn(column);
        } else {
            throw new UnsupportedOperationException("Unsupported column type: " + type);
        }
    }

    private void validateType(int fieldId, Class<?> type) {
        if (!this.types[fieldId].getJavaType().equals(type)) {
            throw new IllegalArgumentException(String.format("Expected field to be %s, actual %s (field %s)", type, this.types[fieldId], fieldId));
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.updateCompletedBytes();
        try {
            this.recordReader.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private long shortTimestamp(Timestamp value, int column) {
        PrestoTimestampEncoder<?> encoder = this.timestampEncoders[column];
        return (Long)encoder.getTimestamp(new DecodedTimestamp(value.toEpochSecond(), value.getNanos()));
    }

    private LongTimestamp longTimestamp(Timestamp value, int column) {
        PrestoTimestampEncoder<?> encoder = this.timestampEncoders[column];
        return (LongTimestamp)encoder.getTimestamp(new DecodedTimestamp(value.toEpochSecond(), value.getNanos()));
    }
}

