/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Shorts;
import io.prestosql.hadoop.HadoopNative;
import io.prestosql.plugin.hive.HdfsConfig;
import io.prestosql.plugin.hive.HdfsConfiguration;
import io.prestosql.plugin.hive.authentication.GenericExceptionAction;
import io.prestosql.plugin.hive.authentication.HdfsAuthentication;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.security.ConnectorIdentity;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;

public class HdfsEnvironment {
    private final HdfsConfiguration hdfsConfiguration;
    private final HdfsAuthentication hdfsAuthentication;
    private final FsPermission newDirectoryPermissions;
    private final boolean newFileInheritOwnership;
    private final boolean verifyChecksum;

    @Inject
    public HdfsEnvironment(HdfsConfiguration hdfsConfiguration, HdfsConfig config, HdfsAuthentication hdfsAuthentication) {
        this.hdfsConfiguration = Objects.requireNonNull(hdfsConfiguration, "hdfsConfiguration is null");
        Objects.requireNonNull(config, "config is null");
        this.newDirectoryPermissions = FsPermission.createImmutable((short)Shorts.checkedCast((long)Integer.parseUnsignedInt(config.getNewDirectoryPermissions(), 8)));
        this.newFileInheritOwnership = config.isNewFileInheritOwnership();
        this.verifyChecksum = config.isVerifyChecksum();
        this.hdfsAuthentication = Objects.requireNonNull(hdfsAuthentication, "hdfsAuthentication is null");
    }

    public Configuration getConfiguration(HdfsContext context, Path path) {
        return this.hdfsConfiguration.getConfiguration(context, path.toUri());
    }

    public FileSystem getFileSystem(HdfsContext context, Path path) throws IOException {
        return this.getFileSystem(context.getIdentity().getUser(), path, this.getConfiguration(context, path));
    }

    public FileSystem getFileSystem(String user, Path path, Configuration configuration) throws IOException {
        return this.hdfsAuthentication.doAs(user, () -> {
            FileSystem fileSystem = path.getFileSystem(configuration);
            fileSystem.setVerifyChecksum(this.verifyChecksum);
            return fileSystem;
        });
    }

    public FsPermission getNewDirectoryPermissions() {
        return this.newDirectoryPermissions;
    }

    public boolean isNewFileInheritOwnership() {
        return this.newFileInheritOwnership;
    }

    public <R, E extends Exception> R doAs(String user, GenericExceptionAction<R, E> action) throws E {
        return this.hdfsAuthentication.doAs(user, action);
    }

    public void doAs(String user, Runnable action) {
        this.hdfsAuthentication.doAs(user, action);
    }

    static {
        HadoopNative.requireHadoopNative();
    }

    public static class HdfsContext {
        private final ConnectorIdentity identity;
        private final Optional<String> source;
        private final Optional<String> queryId;
        private final Optional<String> schemaName;
        private final Optional<String> tableName;

        public HdfsContext(ConnectorIdentity identity) {
            this.identity = Objects.requireNonNull(identity, "identity is null");
            this.source = Optional.empty();
            this.queryId = Optional.empty();
            this.schemaName = Optional.empty();
            this.tableName = Optional.empty();
        }

        public HdfsContext(ConnectorSession session, String schemaName) {
            Objects.requireNonNull(session, "session is null");
            Objects.requireNonNull(schemaName, "schemaName is null");
            this.identity = Objects.requireNonNull(session.getIdentity(), "session.getIdentity() is null");
            this.source = Objects.requireNonNull(session.getSource(), "session.getSource()");
            this.queryId = Optional.of(session.getQueryId());
            this.schemaName = Optional.of(schemaName);
            this.tableName = Optional.empty();
        }

        public HdfsContext(ConnectorSession session, String schemaName, String tableName) {
            Objects.requireNonNull(session, "session is null");
            Objects.requireNonNull(schemaName, "schemaName is null");
            Objects.requireNonNull(tableName, "tableName is null");
            this.identity = Objects.requireNonNull(session.getIdentity(), "session.getIdentity() is null");
            this.source = Objects.requireNonNull(session.getSource(), "session.getSource()");
            this.queryId = Optional.of(session.getQueryId());
            this.schemaName = Optional.of(schemaName);
            this.tableName = Optional.of(tableName);
        }

        public ConnectorIdentity getIdentity() {
            return this.identity;
        }

        public Optional<String> getSource() {
            return this.source;
        }

        public Optional<String> getQueryId() {
            return this.queryId;
        }

        public Optional<String> getSchemaName() {
            return this.schemaName;
        }

        public Optional<String> getTableName() {
            return this.tableName;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).omitNullValues().add("user", (Object)this.identity).add("source", this.source.orElse(null)).add("queryId", this.queryId.orElse(null)).add("schemaName", this.schemaName.orElse(null)).add("tableName", this.tableName.orElse(null)).toString();
        }
    }
}

