/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HiveSessionProperties;
import io.prestosql.plugin.hive.LocationHandle;
import io.prestosql.plugin.hive.LocationService;
import io.prestosql.plugin.hive.metastore.Partition;
import io.prestosql.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.plugin.hive.util.HiveWriteUtils;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ConnectorSession;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.AcidUtils;

public class HiveLocationService
implements LocationService {
    private final HdfsEnvironment hdfsEnvironment;

    @Inject
    public HiveLocationService(HdfsEnvironment hdfsEnvironment) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
    }

    @Override
    public LocationHandle forNewTable(SemiTransactionalHiveMetastore metastore, ConnectorSession session, String schemaName, String tableName, Optional<Path> externalLocation) {
        HdfsEnvironment.HdfsContext context = new HdfsEnvironment.HdfsContext(session, schemaName, tableName);
        Path targetPath = externalLocation.orElseGet(() -> HiveWriteUtils.getTableDefaultLocation(context, metastore, this.hdfsEnvironment, schemaName, tableName));
        if (HiveWriteUtils.pathExists(context, this.hdfsEnvironment, targetPath)) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PATH_ALREADY_EXISTS, String.format("Target directory for table '%s.%s' already exists: %s", schemaName, tableName, targetPath));
        }
        if (this.shouldUseTemporaryDirectory(session, context, targetPath, externalLocation)) {
            Path writePath = HiveWriteUtils.createTemporaryPath(session, context, this.hdfsEnvironment, targetPath);
            return new LocationHandle(targetPath, writePath, false, LocationHandle.WriteMode.STAGE_AND_MOVE_TO_TARGET_DIRECTORY);
        }
        return new LocationHandle(targetPath, targetPath, false, LocationHandle.WriteMode.DIRECT_TO_TARGET_NEW_DIRECTORY);
    }

    @Override
    public LocationHandle forExistingTable(SemiTransactionalHiveMetastore metastore, ConnectorSession session, Table table) {
        Path targetPath;
        HdfsEnvironment.HdfsContext context = new HdfsEnvironment.HdfsContext(session, table.getDatabaseName(), table.getTableName());
        if (this.shouldUseTemporaryDirectory(session, context, targetPath = new Path(table.getStorage().getLocation()), Optional.empty()) && !AcidUtils.isTransactionalTable(table.getParameters())) {
            Path writePath = HiveWriteUtils.createTemporaryPath(session, context, this.hdfsEnvironment, targetPath);
            return new LocationHandle(targetPath, writePath, true, LocationHandle.WriteMode.STAGE_AND_MOVE_TO_TARGET_DIRECTORY);
        }
        return new LocationHandle(targetPath, targetPath, true, LocationHandle.WriteMode.DIRECT_TO_TARGET_EXISTING_DIRECTORY);
    }

    private boolean shouldUseTemporaryDirectory(ConnectorSession session, HdfsEnvironment.HdfsContext context, Path path, Optional<Path> externalLocation) {
        return HiveSessionProperties.isTemporaryStagingDirectoryEnabled(session) && !HiveWriteUtils.isS3FileSystem(context, this.hdfsEnvironment, path) && !HiveWriteUtils.isHdfsEncrypted(context, this.hdfsEnvironment, path) && !externalLocation.isPresent();
    }

    @Override
    public LocationService.WriteInfo getQueryWriteInfo(LocationHandle locationHandle) {
        return new LocationService.WriteInfo(locationHandle.getTargetPath(), locationHandle.getWritePath(), locationHandle.getWriteMode());
    }

    @Override
    public LocationService.WriteInfo getTableWriteInfo(LocationHandle locationHandle, boolean overwrite) {
        if (overwrite && locationHandle.getWriteMode() != LocationHandle.WriteMode.STAGE_AND_MOVE_TO_TARGET_DIRECTORY) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Overwriting unpartitioned table not supported when writing directly to target directory");
        }
        return new LocationService.WriteInfo(locationHandle.getTargetPath(), locationHandle.getWritePath(), locationHandle.getWriteMode());
    }

    @Override
    public LocationService.WriteInfo getPartitionWriteInfo(LocationHandle locationHandle, Optional<Partition> partition, String partitionName) {
        if (partition.isPresent()) {
            Path writePath;
            LocationHandle.WriteMode writeMode = locationHandle.getWriteMode();
            Path targetPath = new Path(partition.get().getStorage().getLocation());
            switch (writeMode) {
                case STAGE_AND_MOVE_TO_TARGET_DIRECTORY: {
                    writePath = new Path(locationHandle.getWritePath(), partitionName);
                    break;
                }
                case DIRECT_TO_TARGET_EXISTING_DIRECTORY: {
                    writePath = targetPath;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("inserting into existing partition is not supported for %s", new Object[]{writeMode}));
                }
            }
            return new LocationService.WriteInfo(targetPath, writePath, writeMode);
        }
        return new LocationService.WriteInfo(new Path(locationHandle.getTargetPath(), partitionName), new Path(locationHandle.getWritePath(), partitionName), locationHandle.getWriteMode());
    }
}

