/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.json.JsonCodec;
import io.airlift.units.Duration;
import io.prestosql.plugin.base.CatalogName;
import io.prestosql.plugin.hive.ForHiveTransactionHeartbeats;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.HiveMetadata;
import io.prestosql.plugin.hive.HiveMetastoreClosure;
import io.prestosql.plugin.hive.HivePartitionManager;
import io.prestosql.plugin.hive.LocationService;
import io.prestosql.plugin.hive.NodeVersion;
import io.prestosql.plugin.hive.PartitionUpdate;
import io.prestosql.plugin.hive.TransactionalMetadata;
import io.prestosql.plugin.hive.TransactionalMetadataFactory;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.plugin.hive.metastore.MetastoreConfig;
import io.prestosql.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.prestosql.plugin.hive.metastore.cache.CachingHiveMetastore;
import io.prestosql.plugin.hive.security.AccessControlMetadataFactory;
import io.prestosql.plugin.hive.statistics.MetastoreHiveStatisticsProvider;
import io.prestosql.spi.type.TypeManager;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;

public class HiveMetadataFactory
implements TransactionalMetadataFactory {
    private final CatalogName catalogName;
    private final boolean skipDeletionForAlter;
    private final boolean skipTargetCleanupOnRollback;
    private final boolean writesToNonManagedTablesEnabled;
    private final boolean createsOfNonManagedTablesEnabled;
    private final boolean translateHiveViews;
    private final boolean hideDeltaLakeTables;
    private final long perTransactionCacheMaximumSize;
    private final HiveMetastore metastore;
    private final HdfsEnvironment hdfsEnvironment;
    private final HivePartitionManager partitionManager;
    private final TypeManager typeManager;
    private final LocationService locationService;
    private final JsonCodec<PartitionUpdate> partitionUpdateCodec;
    private final BoundedExecutor renameExecution;
    private final BoundedExecutor dropExecutor;
    private final Executor updateExecutor;
    private final String prestoVersion;
    private final AccessControlMetadataFactory accessControlMetadataFactory;
    private final Optional<Duration> hiveTransactionHeartbeatInterval;
    private final ScheduledExecutorService heartbeatService;

    @Inject
    public HiveMetadataFactory(CatalogName catalogName, HiveConfig hiveConfig, MetastoreConfig metastoreConfig, HiveMetastore metastore, HdfsEnvironment hdfsEnvironment, HivePartitionManager partitionManager, ExecutorService executorService, @ForHiveTransactionHeartbeats ScheduledExecutorService heartbeatService, TypeManager typeManager, LocationService locationService, JsonCodec<PartitionUpdate> partitionUpdateCodec, NodeVersion nodeVersion, AccessControlMetadataFactory accessControlMetadataFactory) {
        this(catalogName, metastore, hdfsEnvironment, partitionManager, hiveConfig.getMaxConcurrentFileRenames(), hiveConfig.getMaxConcurrentMetastoreDrops(), hiveConfig.getMaxConcurrentMetastoreUpdates(), hiveConfig.isSkipDeletionForAlter(), hiveConfig.isSkipTargetCleanupOnRollback(), hiveConfig.getWritesToNonManagedTablesEnabled(), hiveConfig.getCreatesOfNonManagedTablesEnabled(), hiveConfig.isTranslateHiveViews(), hiveConfig.getPerTransactionMetastoreCacheMaximumSize(), hiveConfig.getHiveTransactionHeartbeatInterval(), metastoreConfig.isHideDeltaLakeTables(), typeManager, locationService, partitionUpdateCodec, executorService, heartbeatService, nodeVersion.toString(), accessControlMetadataFactory);
    }

    public HiveMetadataFactory(CatalogName catalogName, HiveMetastore metastore, HdfsEnvironment hdfsEnvironment, HivePartitionManager partitionManager, int maxConcurrentFileRenames, int maxConcurrentMetastoreDrops, int maxConcurrentMetastoreUpdates, boolean skipDeletionForAlter, boolean skipTargetCleanupOnRollback, boolean writesToNonManagedTablesEnabled, boolean createsOfNonManagedTablesEnabled, boolean translateHiveViews, long perTransactionCacheMaximumSize, Optional<Duration> hiveTransactionHeartbeatInterval, boolean hideDeltaLakeTables, TypeManager typeManager, LocationService locationService, JsonCodec<PartitionUpdate> partitionUpdateCodec, ExecutorService executorService, ScheduledExecutorService heartbeatService, String prestoVersion, AccessControlMetadataFactory accessControlMetadataFactory) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.skipDeletionForAlter = skipDeletionForAlter;
        this.skipTargetCleanupOnRollback = skipTargetCleanupOnRollback;
        this.writesToNonManagedTablesEnabled = writesToNonManagedTablesEnabled;
        this.createsOfNonManagedTablesEnabled = createsOfNonManagedTablesEnabled;
        this.translateHiveViews = translateHiveViews;
        this.hideDeltaLakeTables = hideDeltaLakeTables;
        this.perTransactionCacheMaximumSize = perTransactionCacheMaximumSize;
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.partitionManager = Objects.requireNonNull(partitionManager, "partitionManager is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.locationService = Objects.requireNonNull(locationService, "locationService is null");
        this.partitionUpdateCodec = Objects.requireNonNull(partitionUpdateCodec, "partitionUpdateCodec is null");
        this.prestoVersion = Objects.requireNonNull(prestoVersion, "prestoVersion is null");
        this.accessControlMetadataFactory = Objects.requireNonNull(accessControlMetadataFactory, "accessControlMetadataFactory is null");
        this.hiveTransactionHeartbeatInterval = Objects.requireNonNull(hiveTransactionHeartbeatInterval, "hiveTransactionHeartbeatInterval is null");
        this.renameExecution = new BoundedExecutor((Executor)executorService, maxConcurrentFileRenames);
        this.dropExecutor = new BoundedExecutor((Executor)executorService, maxConcurrentMetastoreDrops);
        this.updateExecutor = maxConcurrentMetastoreUpdates == 1 ? MoreExecutors.directExecutor() : new BoundedExecutor((Executor)executorService, maxConcurrentMetastoreUpdates);
        this.heartbeatService = Objects.requireNonNull(heartbeatService, "heartbeatService is null");
    }

    @Override
    public TransactionalMetadata create() {
        SemiTransactionalHiveMetastore metastore = new SemiTransactionalHiveMetastore(this.hdfsEnvironment, new HiveMetastoreClosure(CachingHiveMetastore.memoizeMetastore(this.metastore, this.perTransactionCacheMaximumSize)), (Executor)this.renameExecution, (Executor)this.dropExecutor, this.updateExecutor, this.skipDeletionForAlter, this.skipTargetCleanupOnRollback, this.hiveTransactionHeartbeatInterval, this.heartbeatService);
        return new HiveMetadata(this.catalogName, metastore, this.hdfsEnvironment, this.partitionManager, this.writesToNonManagedTablesEnabled, this.createsOfNonManagedTablesEnabled, this.translateHiveViews, this.hideDeltaLakeTables, this.typeManager, this.locationService, this.partitionUpdateCodec, this.prestoVersion, new MetastoreHiveStatisticsProvider(metastore), this.accessControlMetadataFactory.create(metastore));
    }
}

