/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.prestosql.plugin.hive.HiveBucketValidationRecordCursor;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveColumnProjectionInfo;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HivePageSourceProvider;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.ReaderProjectionsAdapter;
import io.prestosql.plugin.hive.coercions.DecimalCoercers;
import io.prestosql.plugin.hive.coercions.DoubleToFloatCoercer;
import io.prestosql.plugin.hive.coercions.FloatToDoubleCoercer;
import io.prestosql.plugin.hive.coercions.IntegerNumberToVarcharCoercer;
import io.prestosql.plugin.hive.coercions.IntegerNumberUpscaleCoercer;
import io.prestosql.plugin.hive.coercions.VarcharCoercer;
import io.prestosql.plugin.hive.coercions.VarcharToIntegerNumberCoercer;
import io.prestosql.plugin.hive.util.HiveBucketing;
import io.prestosql.plugin.hive.util.HiveUtil;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.Page;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.ArrayBlock;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.ColumnarArray;
import io.prestosql.spi.block.ColumnarMap;
import io.prestosql.spi.block.ColumnarRow;
import io.prestosql.spi.block.DictionaryBlock;
import io.prestosql.spi.block.LazyBlock;
import io.prestosql.spi.block.LazyBlockLoader;
import io.prestosql.spi.block.RowBlock;
import io.prestosql.spi.block.RunLengthEncodedBlock;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.RecordCursor;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.CharType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.MapType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.joda.time.DateTimeZone;

public class HivePageSource
implements ConnectorPageSource {
    private final List<HivePageSourceProvider.ColumnMapping> columnMappings;
    private final Optional<BucketAdapter> bucketAdapter;
    private final Optional<BucketValidator> bucketValidator;
    private final Object[] prefilledValues;
    private final Type[] types;
    private final List<Optional<Function<Block, Block>>> coercers;
    private final Optional<ReaderProjectionsAdapter> projectionsAdapter;
    private final ConnectorPageSource delegate;

    public HivePageSource(List<HivePageSourceProvider.ColumnMapping> columnMappings, Optional<HivePageSourceProvider.BucketAdaptation> bucketAdaptation, Optional<BucketValidator> bucketValidator, Optional<ReaderProjectionsAdapter> projectionsAdapter, TypeManager typeManager, ConnectorPageSource delegate) {
        Objects.requireNonNull(columnMappings, "columnMappings is null");
        Objects.requireNonNull(typeManager, "typeManager is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.columnMappings = columnMappings;
        this.bucketAdapter = bucketAdaptation.map(BucketAdapter::new);
        this.bucketValidator = Objects.requireNonNull(bucketValidator, "bucketValidator is null");
        this.projectionsAdapter = Objects.requireNonNull(projectionsAdapter, "projectionsAdapter is null");
        int size = columnMappings.size();
        this.prefilledValues = new Object[size];
        this.types = new Type[size];
        ImmutableList.Builder coercers = ImmutableList.builder();
        for (int columnIndex = 0; columnIndex < size; ++columnIndex) {
            Comparable<Boolean> prefilledValue;
            Type type;
            HivePageSourceProvider.ColumnMapping columnMapping = columnMappings.get(columnIndex);
            HiveColumnHandle column = columnMapping.getHiveColumnHandle();
            String name = column.getName();
            this.types[columnIndex] = type = column.getType();
            if (columnMapping.getKind() != HivePageSourceProvider.ColumnMappingKind.EMPTY && columnMapping.getBaseTypeCoercionFrom().isPresent()) {
                List dereferenceIndices = column.getHiveColumnProjectionInfo().map(HiveColumnProjectionInfo::getDereferenceIndices).orElse((List)ImmutableList.of());
                HiveType fromType = columnMapping.getBaseTypeCoercionFrom().get().getHiveTypeForDereferences(dereferenceIndices).get();
                HiveType toType = columnMapping.getHiveColumnHandle().getHiveType();
                coercers.add(HivePageSource.createCoercer(typeManager, fromType, toType));
            } else {
                coercers.add(Optional.empty());
            }
            if (columnMapping.getKind() == HivePageSourceProvider.ColumnMappingKind.EMPTY || HiveColumnHandle.isRowIdColumnHandle(column)) {
                this.prefilledValues[columnIndex] = null;
                continue;
            }
            if (columnMapping.getKind() != HivePageSourceProvider.ColumnMappingKind.PREFILLED) continue;
            String columnValue = columnMapping.getPrefilledValue();
            byte[] bytes = columnValue.getBytes(StandardCharsets.UTF_8);
            if (HiveUtil.isHiveNull(bytes)) {
                prefilledValue = null;
            } else if (type.equals(BooleanType.BOOLEAN)) {
                prefilledValue = HiveUtil.booleanPartitionKey(columnValue, name);
            } else if (type.equals(BigintType.BIGINT)) {
                prefilledValue = HiveUtil.bigintPartitionKey(columnValue, name);
            } else if (type.equals(IntegerType.INTEGER)) {
                prefilledValue = HiveUtil.integerPartitionKey(columnValue, name);
            } else if (type.equals(SmallintType.SMALLINT)) {
                prefilledValue = HiveUtil.smallintPartitionKey(columnValue, name);
            } else if (type.equals(TinyintType.TINYINT)) {
                prefilledValue = HiveUtil.tinyintPartitionKey(columnValue, name);
            } else if (type.equals(RealType.REAL)) {
                prefilledValue = HiveUtil.floatPartitionKey(columnValue, name);
            } else if (type.equals(DoubleType.DOUBLE)) {
                prefilledValue = HiveUtil.doublePartitionKey(columnValue, name);
            } else if (type instanceof VarcharType) {
                prefilledValue = HiveUtil.varcharPartitionKey(columnValue, name, type);
            } else if (type instanceof CharType) {
                prefilledValue = HiveUtil.charPartitionKey(columnValue, name, type);
            } else if (type.equals(DateType.DATE)) {
                prefilledValue = HiveUtil.datePartitionKey(columnValue, name);
            } else if (type.equals(TimestampType.TIMESTAMP_MILLIS)) {
                prefilledValue = HiveUtil.timestampPartitionKey(columnValue, name);
            } else if (type.equals(TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS)) {
                prefilledValue = DateTimeEncoding.packDateTimeWithZone((long)HiveUtil.timestampPartitionKey(columnValue, name), (String)DateTimeZone.getDefault().getID());
            } else if (Decimals.isShortDecimal((Type)type)) {
                prefilledValue = HiveUtil.shortDecimalPartitionKey(columnValue, (DecimalType)type, name);
            } else if (Decimals.isLongDecimal((Type)type)) {
                prefilledValue = HiveUtil.longDecimalPartitionKey(columnValue, (DecimalType)type, name);
            } else if (type.equals(VarbinaryType.VARBINARY)) {
                prefilledValue = Slices.utf8Slice((String)columnValue);
            } else {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported column type %s for prefilled column: %s", type.getDisplayName(), name));
            }
            this.prefilledValues[columnIndex] = prefilledValue;
        }
        this.coercers = coercers.build();
    }

    public ConnectorPageSource getDelegate() {
        return this.delegate;
    }

    public long getCompletedBytes() {
        return this.delegate.getCompletedBytes();
    }

    public long getReadTimeNanos() {
        return this.delegate.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.delegate.isFinished();
    }

    public Page getNextPage() {
        try {
            Page dataPage = this.delegate.getNextPage();
            if (dataPage == null) {
                return null;
            }
            if (this.projectionsAdapter.isPresent()) {
                dataPage = this.projectionsAdapter.get().adaptPage(dataPage);
            }
            if (this.bucketAdapter.isPresent() && (dataPage = this.bucketAdapter.get().filterPageToEligibleRowsOrDiscard(dataPage)) == null) {
                return null;
            }
            int batchSize = dataPage.getPositionCount();
            ArrayList<Block> blocks = new ArrayList<Block>();
            block8: for (int fieldId = 0; fieldId < this.columnMappings.size(); ++fieldId) {
                HivePageSourceProvider.ColumnMapping columnMapping = this.columnMappings.get(fieldId);
                switch (columnMapping.getKind()) {
                    case PREFILLED: 
                    case EMPTY: {
                        blocks.add(RunLengthEncodedBlock.create((Type)this.types[fieldId], (Object)this.prefilledValues[fieldId], (int)batchSize));
                        continue block8;
                    }
                    case REGULAR: 
                    case SYNTHESIZED: {
                        Block block = dataPage.getBlock(columnMapping.getIndex());
                        Optional<Function<Block, Block>> coercer = this.coercers.get(fieldId);
                        if (coercer.isPresent()) {
                            block = new LazyBlock(batchSize, (LazyBlockLoader)new CoercionLazyBlockLoader(block, coercer.get()));
                        }
                        blocks.add(block);
                        continue block8;
                    }
                    case INTERIM: {
                        continue block8;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            Page page = new Page(batchSize, blocks.toArray(new Block[0]));
            if (this.bucketAdapter.isEmpty()) {
                this.bucketValidator.ifPresent(validator -> validator.validate(page));
            }
            return page;
        }
        catch (PrestoException e) {
            this.closeWithSuppression(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.closeWithSuppression(e);
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, (Throwable)e);
        }
    }

    public void close() {
        try {
            this.delegate.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String toString() {
        return this.delegate.toString();
    }

    public long getSystemMemoryUsage() {
        return this.delegate.getSystemMemoryUsage();
    }

    protected void closeWithSuppression(Throwable throwable) {
        block2: {
            Objects.requireNonNull(throwable, "throwable is null");
            try {
                this.close();
            }
            catch (RuntimeException e) {
                if (throwable == e) break block2;
                throwable.addSuppressed(e);
            }
        }
    }

    public ConnectorPageSource getPageSource() {
        return this.delegate;
    }

    private static Optional<Function<Block, Block>> createCoercer(TypeManager typeManager, HiveType fromHiveType, HiveType toHiveType) {
        if (fromHiveType.equals(toHiveType)) {
            return Optional.empty();
        }
        Type fromType = fromHiveType.getType(typeManager);
        Type toType = toHiveType.getType(typeManager);
        if (toType instanceof VarcharType && (fromHiveType.equals(HiveType.HIVE_BYTE) || fromHiveType.equals(HiveType.HIVE_SHORT) || fromHiveType.equals(HiveType.HIVE_INT) || fromHiveType.equals(HiveType.HIVE_LONG))) {
            return Optional.of(new IntegerNumberToVarcharCoercer<Type>(fromType, (VarcharType)toType));
        }
        if (fromType instanceof VarcharType && (toHiveType.equals(HiveType.HIVE_BYTE) || toHiveType.equals(HiveType.HIVE_SHORT) || toHiveType.equals(HiveType.HIVE_INT) || toHiveType.equals(HiveType.HIVE_LONG))) {
            return Optional.of(new VarcharToIntegerNumberCoercer<Type>((VarcharType)fromType, toType));
        }
        if (fromType instanceof VarcharType && toType instanceof VarcharType) {
            VarcharType toVarcharType = (VarcharType)toType;
            VarcharType fromVarcharType = (VarcharType)fromType;
            if (HivePageSource.narrowerThan(toVarcharType, fromVarcharType)) {
                return Optional.of(new VarcharCoercer(fromVarcharType, toVarcharType));
            }
            return Optional.empty();
        }
        if (fromHiveType.equals(HiveType.HIVE_BYTE) && (toHiveType.equals(HiveType.HIVE_SHORT) || toHiveType.equals(HiveType.HIVE_INT) || toHiveType.equals(HiveType.HIVE_LONG))) {
            return Optional.of(new IntegerNumberUpscaleCoercer<Type, Type>(fromType, toType));
        }
        if (fromHiveType.equals(HiveType.HIVE_SHORT) && (toHiveType.equals(HiveType.HIVE_INT) || toHiveType.equals(HiveType.HIVE_LONG))) {
            return Optional.of(new IntegerNumberUpscaleCoercer<Type, Type>(fromType, toType));
        }
        if (fromHiveType.equals(HiveType.HIVE_INT) && toHiveType.equals(HiveType.HIVE_LONG)) {
            return Optional.of(new IntegerNumberUpscaleCoercer<Type, Type>(fromType, toType));
        }
        if (fromHiveType.equals(HiveType.HIVE_FLOAT) && toHiveType.equals(HiveType.HIVE_DOUBLE)) {
            return Optional.of(new FloatToDoubleCoercer());
        }
        if (fromHiveType.equals(HiveType.HIVE_DOUBLE) && toHiveType.equals(HiveType.HIVE_FLOAT)) {
            return Optional.of(new DoubleToFloatCoercer());
        }
        if (fromType instanceof DecimalType && toType instanceof DecimalType) {
            return Optional.of(DecimalCoercers.createDecimalToDecimalCoercer((DecimalType)fromType, (DecimalType)toType));
        }
        if (fromType instanceof DecimalType && toType == DoubleType.DOUBLE) {
            return Optional.of(DecimalCoercers.createDecimalToDoubleCoercer((DecimalType)fromType));
        }
        if (fromType instanceof DecimalType && toType == RealType.REAL) {
            return Optional.of(DecimalCoercers.createDecimalToRealCoercer((DecimalType)fromType));
        }
        if (fromType == DoubleType.DOUBLE && toType instanceof DecimalType) {
            return Optional.of(DecimalCoercers.createDoubleToDecimalCoercer((DecimalType)toType));
        }
        if (fromType == RealType.REAL && toType instanceof DecimalType) {
            return Optional.of(DecimalCoercers.createRealToDecimalCoercer((DecimalType)toType));
        }
        if (HiveUtil.isArrayType(fromType) && HiveUtil.isArrayType(toType)) {
            return Optional.of(new ListCoercer(typeManager, fromHiveType, toHiveType));
        }
        if (HiveUtil.isMapType(fromType) && HiveUtil.isMapType(toType)) {
            return Optional.of(new MapCoercer(typeManager, fromHiveType, toHiveType));
        }
        if (HiveUtil.isRowType(fromType) && HiveUtil.isRowType(toType)) {
            return Optional.of(new StructCoercer(typeManager, fromHiveType, toHiveType));
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported coercion from %s to %s", fromHiveType, toHiveType));
    }

    public static boolean narrowerThan(VarcharType first, VarcharType second) {
        Objects.requireNonNull(first, "first is null");
        Objects.requireNonNull(second, "second is null");
        if (first.isUnbounded() || second.isUnbounded()) {
            return !first.isUnbounded();
        }
        return first.getBoundedLength() < second.getBoundedLength();
    }

    public static class BucketValidator {
        public static final int VALIDATION_STRIDE = 97;
        private final Path path;
        private final int[] bucketColumnIndices;
        private final List<TypeInfo> bucketColumnTypes;
        private final HiveBucketing.BucketingVersion bucketingVersion;
        private final int bucketCount;
        private final int expectedBucket;

        public BucketValidator(Path path, int[] bucketColumnIndices, List<TypeInfo> bucketColumnTypes, HiveBucketing.BucketingVersion bucketingVersion, int bucketCount, int expectedBucket) {
            this.path = Objects.requireNonNull(path, "path is null");
            this.bucketColumnIndices = Objects.requireNonNull(bucketColumnIndices, "bucketColumnIndices is null");
            this.bucketColumnTypes = Objects.requireNonNull(bucketColumnTypes, "bucketColumnTypes is null");
            this.bucketingVersion = Objects.requireNonNull(bucketingVersion, "bucketingVersion is null");
            this.bucketCount = bucketCount;
            this.expectedBucket = expectedBucket;
            Preconditions.checkArgument((bucketColumnIndices.length == bucketColumnTypes.size() ? 1 : 0) != 0, (Object)"indices and types counts mismatch");
        }

        public void validate(Page page) {
            Page bucketColumnsPage = page.getColumns(this.bucketColumnIndices);
            for (int position = 0; position < page.getPositionCount(); position += 97) {
                int bucket = HiveBucketing.getHiveBucket(this.bucketingVersion, this.bucketCount, this.bucketColumnTypes, bucketColumnsPage, position);
                if (bucket == this.expectedBucket) continue;
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_BUCKET_FILES, String.format("Hive table is corrupt. File '%s' is for bucket %s, but contains a row for bucket %s.", this.path, this.expectedBucket, bucket));
            }
        }

        public RecordCursor wrapRecordCursor(RecordCursor delegate, TypeManager typeManager) {
            return new HiveBucketValidationRecordCursor(this.path, this.bucketColumnIndices, (List)this.bucketColumnTypes.stream().map(HiveType::toHiveType).collect(ImmutableList.toImmutableList()), this.bucketingVersion, this.bucketCount, this.expectedBucket, typeManager, delegate);
        }
    }

    public static class BucketAdapter {
        private final int[] bucketColumns;
        private final HiveBucketing.BucketingVersion bucketingVersion;
        private final int bucketToKeep;
        private final int tableBucketCount;
        private final int partitionBucketCount;
        private final List<TypeInfo> typeInfoList;

        public BucketAdapter(HivePageSourceProvider.BucketAdaptation bucketAdaptation) {
            this.bucketColumns = bucketAdaptation.getBucketColumnIndices();
            this.bucketingVersion = bucketAdaptation.getBucketingVersion();
            this.bucketToKeep = bucketAdaptation.getBucketToKeep();
            this.typeInfoList = (List)bucketAdaptation.getBucketColumnHiveTypes().stream().map(HiveType::getTypeInfo).collect(ImmutableList.toImmutableList());
            this.tableBucketCount = bucketAdaptation.getTableBucketCount();
            this.partitionBucketCount = bucketAdaptation.getPartitionBucketCount();
        }

        @Nullable
        public Page filterPageToEligibleRowsOrDiscard(Page page) {
            IntArrayList ids = new IntArrayList(page.getPositionCount());
            Page bucketColumnsPage = page.getColumns(this.bucketColumns);
            for (int position = 0; position < page.getPositionCount(); ++position) {
                int bucket = HiveBucketing.getHiveBucket(this.bucketingVersion, this.tableBucketCount, this.typeInfoList, bucketColumnsPage, position);
                if ((bucket - this.bucketToKeep) % this.partitionBucketCount != 0) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_BUCKET_FILES, String.format("A row that is supposed to be in bucket %s is encountered. Only rows in bucket %s (modulo %s) are expected", bucket, this.bucketToKeep % this.partitionBucketCount, this.partitionBucketCount));
                }
                if (bucket != this.bucketToKeep) continue;
                ids.add(position);
            }
            int retainedRowCount = ids.size();
            if (retainedRowCount == 0) {
                return null;
            }
            if (retainedRowCount == page.getPositionCount()) {
                return page;
            }
            return page.getPositions(ids.elements(), 0, retainedRowCount);
        }
    }

    private static final class CoercionLazyBlockLoader
    implements LazyBlockLoader {
        private final Function<Block, Block> coercer;
        private Block block;

        public CoercionLazyBlockLoader(Block block, Function<Block, Block> coercer) {
            this.block = Objects.requireNonNull(block, "block is null");
            this.coercer = Objects.requireNonNull(coercer, "coercer is null");
        }

        public Block load() {
            Preconditions.checkState((this.block != null ? 1 : 0) != 0, (Object)"Already loaded");
            Block loaded = this.coercer.apply(this.block.getLoadedBlock());
            this.block = null;
            return loaded;
        }
    }

    private static class StructCoercer
    implements Function<Block, Block> {
        private final List<Optional<Function<Block, Block>>> coercers;
        private final Block[] nullBlocks;

        public StructCoercer(TypeManager typeManager, HiveType fromHiveType, HiveType toHiveType) {
            Objects.requireNonNull(typeManager, "typeManage is null");
            Objects.requireNonNull(fromHiveType, "fromHiveType is null");
            Objects.requireNonNull(toHiveType, "toHiveType is null");
            List<HiveType> fromFieldTypes = HiveUtil.extractStructFieldTypes(fromHiveType);
            List<HiveType> toFieldTypes = HiveUtil.extractStructFieldTypes(toHiveType);
            ImmutableList.Builder coercers = ImmutableList.builder();
            this.nullBlocks = new Block[toFieldTypes.size()];
            for (int i = 0; i < toFieldTypes.size(); ++i) {
                if (i >= fromFieldTypes.size()) {
                    this.nullBlocks[i] = toFieldTypes.get(i).getType(typeManager).createBlockBuilder(null, 1).appendNull().build();
                    coercers.add(Optional.empty());
                    continue;
                }
                coercers.add(HivePageSource.createCoercer(typeManager, fromFieldTypes.get(i), toFieldTypes.get(i)));
            }
            this.coercers = coercers.build();
        }

        @Override
        public Block apply(Block block) {
            ColumnarRow rowBlock = ColumnarRow.toColumnarRow((Block)block);
            Block[] fields = new Block[this.coercers.size()];
            int[] ids = new int[rowBlock.getField(0).getPositionCount()];
            for (int i = 0; i < this.coercers.size(); ++i) {
                Optional<Function<Block, Block>> coercer = this.coercers.get(i);
                fields[i] = coercer.isPresent() ? coercer.get().apply(rowBlock.getField(i)) : (i < rowBlock.getFieldCount() ? rowBlock.getField(i) : new DictionaryBlock(this.nullBlocks[i], ids));
            }
            boolean[] valueIsNull = new boolean[rowBlock.getPositionCount()];
            for (int i = 0; i < rowBlock.getPositionCount(); ++i) {
                valueIsNull[i] = rowBlock.isNull(i);
            }
            return RowBlock.fromFieldBlocks((int)valueIsNull.length, Optional.of(valueIsNull), (Block[])fields);
        }
    }

    private static class MapCoercer
    implements Function<Block, Block> {
        private final Type toType;
        private final Optional<Function<Block, Block>> keyCoercer;
        private final Optional<Function<Block, Block>> valueCoercer;

        public MapCoercer(TypeManager typeManager, HiveType fromHiveType, HiveType toHiveType) {
            Objects.requireNonNull(typeManager, "typeManage is null");
            Objects.requireNonNull(fromHiveType, "fromHiveType is null");
            this.toType = Objects.requireNonNull(toHiveType, "toHiveType is null").getType(typeManager);
            HiveType fromKeyHiveType = HiveType.valueOf(((MapTypeInfo)fromHiveType.getTypeInfo()).getMapKeyTypeInfo().getTypeName());
            HiveType fromValueHiveType = HiveType.valueOf(((MapTypeInfo)fromHiveType.getTypeInfo()).getMapValueTypeInfo().getTypeName());
            HiveType toKeyHiveType = HiveType.valueOf(((MapTypeInfo)toHiveType.getTypeInfo()).getMapKeyTypeInfo().getTypeName());
            HiveType toValueHiveType = HiveType.valueOf(((MapTypeInfo)toHiveType.getTypeInfo()).getMapValueTypeInfo().getTypeName());
            this.keyCoercer = HivePageSource.createCoercer(typeManager, fromKeyHiveType, toKeyHiveType);
            this.valueCoercer = HivePageSource.createCoercer(typeManager, fromValueHiveType, toValueHiveType);
        }

        @Override
        public Block apply(Block block) {
            ColumnarMap mapBlock = ColumnarMap.toColumnarMap((Block)block);
            Block keysBlock = this.keyCoercer.isEmpty() ? mapBlock.getKeysBlock() : this.keyCoercer.get().apply(mapBlock.getKeysBlock());
            Block valuesBlock = this.valueCoercer.isEmpty() ? mapBlock.getValuesBlock() : this.valueCoercer.get().apply(mapBlock.getValuesBlock());
            boolean[] valueIsNull = new boolean[mapBlock.getPositionCount()];
            int[] offsets = new int[mapBlock.getPositionCount() + 1];
            for (int i = 0; i < mapBlock.getPositionCount(); ++i) {
                valueIsNull[i] = mapBlock.isNull(i);
                offsets[i + 1] = offsets[i] + mapBlock.getEntryCount(i);
            }
            return ((MapType)this.toType).createBlockFromKeyValue(Optional.of(valueIsNull), offsets, keysBlock, valuesBlock);
        }
    }

    private static class ListCoercer
    implements Function<Block, Block> {
        private final Optional<Function<Block, Block>> elementCoercer;

        public ListCoercer(TypeManager typeManager, HiveType fromHiveType, HiveType toHiveType) {
            Objects.requireNonNull(typeManager, "typeManager is null");
            Objects.requireNonNull(fromHiveType, "fromHiveType is null");
            Objects.requireNonNull(toHiveType, "toHiveType is null");
            HiveType fromElementHiveType = HiveType.valueOf(((ListTypeInfo)fromHiveType.getTypeInfo()).getListElementTypeInfo().getTypeName());
            HiveType toElementHiveType = HiveType.valueOf(((ListTypeInfo)toHiveType.getTypeInfo()).getListElementTypeInfo().getTypeName());
            this.elementCoercer = HivePageSource.createCoercer(typeManager, fromElementHiveType, toElementHiveType);
        }

        @Override
        public Block apply(Block block) {
            if (this.elementCoercer.isEmpty()) {
                return block;
            }
            ColumnarArray arrayBlock = ColumnarArray.toColumnarArray((Block)block);
            Block elementsBlock = this.elementCoercer.get().apply(arrayBlock.getElementsBlock());
            boolean[] valueIsNull = new boolean[arrayBlock.getPositionCount()];
            int[] offsets = new int[arrayBlock.getPositionCount() + 1];
            for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
                valueIsNull[i] = arrayBlock.isNull(i);
                offsets[i + 1] = offsets[i] + arrayBlock.getLength(i);
            }
            return ArrayBlock.fromElementBlock((int)arrayBlock.getPositionCount(), Optional.of(valueIsNull), (int[])offsets, (Block)elementsBlock);
        }
    }
}

