/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import java.util.Iterator;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;

public final class HiveQlToPrestoTranslator {
    private final PeekingIterator<Character> input;
    private final StringBuilder output = new StringBuilder();

    public static String translateHiveViewToPresto(String hiveStatement) {
        HiveQlToPrestoTranslator translator = new HiveQlToPrestoTranslator(hiveStatement);
        return translator.translateQuotedLiterals();
    }

    private HiveQlToPrestoTranslator(String hiveQl) {
        this.input = Iterators.peekingIterator((Iterator)Lists.charactersOf((String)hiveQl).iterator());
    }

    private String translateQuotedLiterals() {
        block4: while (this.input.hasNext()) {
            char c = ((Character)this.input.next()).charValue();
            switch (c) {
                case '\"': 
                case '\'': {
                    this.translateString(c);
                    continue block4;
                }
                case '`': {
                    this.translateQuotedIdentifier();
                    continue block4;
                }
            }
            this.output.append(c);
        }
        return this.output.toString();
    }

    private void translateString(char delimiter) {
        StringBuilder string = new StringBuilder(String.valueOf(delimiter));
        while (this.input.hasNext()) {
            char c = ((Character)this.input.next()).charValue();
            if (c == delimiter) {
                string.append(delimiter);
                String unescaped = BaseSemanticAnalyzer.unescapeSQLString((String)string.toString());
                this.output.append("'");
                this.output.append(unescaped.replace("'", "''"));
                this.output.append("'");
                return;
            }
            string.append(c);
            if (c != '\\') continue;
            if (!this.input.hasNext()) break;
            string.append(this.input.next());
        }
        throw HiveQlToPrestoTranslator.hiveViewParseError("unexpected end of input in string");
    }

    private void translateQuotedIdentifier() {
        this.output.append('\"');
        while (this.input.hasNext()) {
            char c = ((Character)this.input.next()).charValue();
            if (c == '\"') {
                this.output.append("\"\"");
                continue;
            }
            if (c == '`' && this.input.hasNext() && ((Character)this.input.peek()).charValue() == '`') {
                this.output.append('`');
                this.input.next();
                continue;
            }
            if (c == '`') {
                this.output.append('\"');
                return;
            }
            this.output.append(c);
        }
        throw HiveQlToPrestoTranslator.hiveViewParseError("unexpected end of input in identifier");
    }

    private static PrestoException hiveViewParseError(String message) {
        return new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_VIEW_TRANSLATION_ERROR, "Error translating Hive view to Presto: " + message);
    }
}

