/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.stats.CounterStat;
import io.airlift.units.DataSize;
import io.prestosql.plugin.hive.BackgroundHiveSplitLoader;
import io.prestosql.plugin.hive.DirectoryLister;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveBucketHandle;
import io.prestosql.plugin.hive.HiveBucketProperty;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HiveNotReadableException;
import io.prestosql.plugin.hive.HivePartition;
import io.prestosql.plugin.hive.HivePartitionManager;
import io.prestosql.plugin.hive.HivePartitionMetadata;
import io.prestosql.plugin.hive.HiveSessionProperties;
import io.prestosql.plugin.hive.HiveSplitSource;
import io.prestosql.plugin.hive.HiveTableHandle;
import io.prestosql.plugin.hive.HiveTransactionHandle;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.HiveTypeName;
import io.prestosql.plugin.hive.NamenodeStats;
import io.prestosql.plugin.hive.TableToPartitionMapping;
import io.prestosql.plugin.hive.authentication.HiveIdentity;
import io.prestosql.plugin.hive.metastore.Column;
import io.prestosql.plugin.hive.metastore.MetastoreUtil;
import io.prestosql.plugin.hive.metastore.Partition;
import io.prestosql.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.plugin.hive.util.HiveBucketing;
import io.prestosql.plugin.hive.util.HiveCoercionPolicy;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.VersionEmbedder;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.connector.ConnectorSplitSource;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.DynamicFilter;
import io.prestosql.spi.connector.FixedSplitSource;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.TableNotFoundException;
import io.prestosql.spi.type.TypeManager;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class HiveSplitManager
implements ConnectorSplitManager {
    public static final String PRESTO_OFFLINE = "presto_offline";
    public static final String OBJECT_NOT_READABLE = "object_not_readable";
    private final Function<HiveTransactionHandle, SemiTransactionalHiveMetastore> metastoreProvider;
    private final HivePartitionManager partitionManager;
    private final NamenodeStats namenodeStats;
    private final HdfsEnvironment hdfsEnvironment;
    private final DirectoryLister directoryLister;
    private final Executor executor;
    private final int maxOutstandingSplits;
    private final DataSize maxOutstandingSplitsSize;
    private final int minPartitionBatchSize;
    private final int maxPartitionBatchSize;
    private final int maxInitialSplits;
    private final int splitLoaderConcurrency;
    private final int maxSplitsPerSecond;
    private final boolean recursiveDfsWalkerEnabled;
    private final CounterStat highMemorySplitSourceCounter;
    private final TypeManager typeManager;

    @Inject
    public HiveSplitManager(HiveConfig hiveConfig, Function<HiveTransactionHandle, SemiTransactionalHiveMetastore> metastoreProvider, HivePartitionManager partitionManager, NamenodeStats namenodeStats, HdfsEnvironment hdfsEnvironment, DirectoryLister directoryLister, ExecutorService executorService, VersionEmbedder versionEmbedder, TypeManager typeManager) {
        this(metastoreProvider, partitionManager, namenodeStats, hdfsEnvironment, directoryLister, versionEmbedder.embedVersion((Executor)new BoundedExecutor((Executor)executorService, hiveConfig.getMaxSplitIteratorThreads())), new CounterStat(), hiveConfig.getMaxOutstandingSplits(), hiveConfig.getMaxOutstandingSplitsSize(), hiveConfig.getMinPartitionBatchSize(), hiveConfig.getMaxPartitionBatchSize(), hiveConfig.getMaxInitialSplits(), hiveConfig.getSplitLoaderConcurrency(), hiveConfig.getMaxSplitsPerSecond(), hiveConfig.getRecursiveDirWalkerEnabled(), typeManager);
    }

    public HiveSplitManager(Function<HiveTransactionHandle, SemiTransactionalHiveMetastore> metastoreProvider, HivePartitionManager partitionManager, NamenodeStats namenodeStats, HdfsEnvironment hdfsEnvironment, DirectoryLister directoryLister, Executor executor, CounterStat highMemorySplitSourceCounter, int maxOutstandingSplits, DataSize maxOutstandingSplitsSize, int minPartitionBatchSize, int maxPartitionBatchSize, int maxInitialSplits, int splitLoaderConcurrency, @Nullable Integer maxSplitsPerSecond, boolean recursiveDfsWalkerEnabled, TypeManager typeManager) {
        this.metastoreProvider = Objects.requireNonNull(metastoreProvider, "metastore is null");
        this.partitionManager = Objects.requireNonNull(partitionManager, "partitionManager is null");
        this.namenodeStats = Objects.requireNonNull(namenodeStats, "namenodeStats is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.directoryLister = Objects.requireNonNull(directoryLister, "directoryLister is null");
        this.executor = new ErrorCodedExecutor(executor);
        this.highMemorySplitSourceCounter = Objects.requireNonNull(highMemorySplitSourceCounter, "highMemorySplitSourceCounter is null");
        Preconditions.checkArgument((maxOutstandingSplits >= 1 ? 1 : 0) != 0, (Object)"maxOutstandingSplits must be at least 1");
        this.maxOutstandingSplits = maxOutstandingSplits;
        this.maxOutstandingSplitsSize = maxOutstandingSplitsSize;
        this.minPartitionBatchSize = minPartitionBatchSize;
        this.maxPartitionBatchSize = maxPartitionBatchSize;
        this.maxInitialSplits = maxInitialSplits;
        this.splitLoaderConcurrency = splitLoaderConcurrency;
        this.maxSplitsPerSecond = (Integer)MoreObjects.firstNonNull((Object)maxSplitsPerSecond, (Object)Integer.MAX_VALUE);
        this.recursiveDfsWalkerEnabled = recursiveDfsWalkerEnabled;
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle tableHandle, ConnectorSplitManager.SplitSchedulingStrategy splitSchedulingStrategy, DynamicFilter dynamicFilter) {
        HiveSplitSource splitSource;
        HiveTableHandle hiveTable = (HiveTableHandle)tableHandle;
        SchemaTableName tableName = hiveTable.getSchemaTableName();
        SemiTransactionalHiveMetastore metastore = this.metastoreProvider.apply((HiveTransactionHandle)transaction);
        Table table = metastore.getTable(new HiveIdentity(session), tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        String tableNotReadable = table.getParameters().get(OBJECT_NOT_READABLE);
        if (!Strings.isNullOrEmpty((String)tableNotReadable)) {
            throw new HiveNotReadableException(tableName, Optional.empty(), tableNotReadable);
        }
        List partitions = this.partitionManager.getOrLoadPartitions(metastore, new HiveIdentity(session), hiveTable);
        if (partitions.isEmpty()) {
            return new FixedSplitSource((Iterable)ImmutableList.of());
        }
        Optional<HiveBucketing.HiveBucketFilter> bucketFilter = hiveTable.getBucketFilter();
        Optional<HiveBucketHandle> bucketHandle = hiveTable.getBucketHandle();
        if (splitSchedulingStrategy == ConnectorSplitManager.SplitSchedulingStrategy.GROUPED_SCHEDULING && bucketHandle.isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "SchedulingPolicy is bucketed, but BucketHandle is not present");
        }
        partitions = Ordering.natural().onResultOf(HivePartition::getPartitionId).reverse().sortedCopy(partitions);
        Iterable<HivePartitionMetadata> hivePartitions = this.getPartitionMetadata(session, metastore, table, tableName, partitions, bucketHandle.map(HiveBucketHandle::toTableBucketProperty));
        int concurrency = AcidUtils.isTransactionalTable(table.getParameters()) ? this.splitLoaderConcurrency : Math.min(this.splitLoaderConcurrency, partitions.size());
        BackgroundHiveSplitLoader hiveSplitLoader = new BackgroundHiveSplitLoader(table, hiveTable.getTransaction(), hivePartitions, hiveTable.getCompactEffectivePredicate(), dynamicFilter, HiveSessionProperties.getDynamicFilteringProbeBlockingTimeout(session), this.typeManager, BackgroundHiveSplitLoader.BucketSplitInfo.createBucketSplitInfo(bucketHandle, bucketFilter), session, this.hdfsEnvironment, this.namenodeStats, this.directoryLister, this.executor, concurrency, this.recursiveDfsWalkerEnabled, !hiveTable.getPartitionColumns().isEmpty() && HiveSessionProperties.isIgnoreAbsentPartitions(session), HiveSessionProperties.isOptimizeSymlinkListing(session), metastore.getValidWriteIds(session, hiveTable).map(validTxnWriteIdList -> validTxnWriteIdList.getTableValidWriteIdList(table.getDatabaseName() + "." + table.getTableName())));
        switch (splitSchedulingStrategy) {
            case UNGROUPED_SCHEDULING: {
                splitSource = HiveSplitSource.allAtOnce(session, table.getDatabaseName(), table.getTableName(), this.maxInitialSplits, this.maxOutstandingSplits, this.maxOutstandingSplitsSize, this.maxSplitsPerSecond, hiveSplitLoader, this.executor, this.highMemorySplitSourceCounter);
                break;
            }
            case GROUPED_SCHEDULING: {
                splitSource = HiveSplitSource.bucketed(session, table.getDatabaseName(), table.getTableName(), this.maxInitialSplits, this.maxOutstandingSplits, this.maxOutstandingSplitsSize, this.maxSplitsPerSecond, hiveSplitLoader, this.executor, this.highMemorySplitSourceCounter);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown splitSchedulingStrategy: " + splitSchedulingStrategy);
            }
        }
        hiveSplitLoader.start(splitSource);
        return splitSource;
    }

    @Managed
    @Nested
    public CounterStat getHighMemorySplitSource() {
        return this.highMemorySplitSourceCounter;
    }

    private Iterable<HivePartitionMetadata> getPartitionMetadata(ConnectorSession session, SemiTransactionalHiveMetastore metastore, Table table, SchemaTableName tableName, List<HivePartition> hivePartitions, Optional<HiveBucketProperty> bucketProperty) {
        HivePartition firstPartition;
        if (hivePartitions.isEmpty()) {
            return ImmutableList.of();
        }
        if (hivePartitions.size() == 1 && (firstPartition = (HivePartition)Iterables.getOnlyElement(hivePartitions)).getPartitionId().equals("<UNPARTITIONED>")) {
            return ImmutableList.of((Object)new HivePartitionMetadata(firstPartition, Optional.empty(), TableToPartitionMapping.empty()));
        }
        Iterable<List<HivePartition>> partitionNameBatches = HiveSplitManager.partitionExponentially(hivePartitions, this.minPartitionBatchSize, this.maxPartitionBatchSize);
        Iterable partitionBatches = Iterables.transform(partitionNameBatches, partitionBatch -> {
            Map<String, Optional<Partition>> batch = metastore.getPartitionsByNames(new HiveIdentity(session), tableName.getSchemaName(), tableName.getTableName(), Lists.transform((List)partitionBatch, HivePartition::getPartitionId));
            ImmutableMap.Builder partitionBuilder = ImmutableMap.builder();
            for (Map.Entry<String, Optional<Partition>> entry : batch.entrySet()) {
                if (entry.getValue().isEmpty()) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_DROPPED_DURING_QUERY, "Partition no longer exists: " + entry.getKey());
                }
                partitionBuilder.put((Object)entry.getKey(), (Object)entry.getValue().get());
            }
            ImmutableMap partitions = partitionBuilder.build();
            if (partitionBatch.size() != partitions.size()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Expected %s partitions but found %s", partitionBatch.size(), partitions.size()));
            }
            ImmutableList.Builder results = ImmutableList.builder();
            for (HivePartition hivePartition : partitionBatch) {
                Partition partition = (Partition)partitions.get(hivePartition.getPartitionId());
                if (partition == null) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Partition not loaded: " + hivePartition);
                }
                String partName = MetastoreUtil.makePartitionName(table, partition);
                MetastoreUtil.verifyOnline(tableName, Optional.of(partName), MetastoreUtil.getProtectMode(partition), partition.getParameters());
                String partitionNotReadable = partition.getParameters().get(OBJECT_NOT_READABLE);
                if (!Strings.isNullOrEmpty((String)partitionNotReadable)) {
                    throw new HiveNotReadableException(tableName, Optional.of(partName), partitionNotReadable);
                }
                List<Column> tableColumns = table.getDataColumns();
                List<Column> partitionColumns = partition.getColumns();
                if (tableColumns == null || partitionColumns == null) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Table '%s' or partition '%s' has null columns", tableName, partName));
                }
                TableToPartitionMapping tableToPartitionMapping = this.getTableToPartitionMapping(session, tableName, partName, tableColumns, partitionColumns);
                if (bucketProperty.isPresent()) {
                    List<String> partitionBucketColumns;
                    Optional<HiveBucketProperty> partitionBucketProperty = partition.getStorage().getBucketProperty();
                    if (partitionBucketProperty.isEmpty()) {
                        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH, String.format("Hive table (%s) is bucketed but partition (%s) is not bucketed", hivePartition.getTableName(), hivePartition.getPartitionId()));
                    }
                    int tableBucketCount = ((HiveBucketProperty)bucketProperty.get()).getBucketCount();
                    int partitionBucketCount = partitionBucketProperty.get().getBucketCount();
                    List<String> tableBucketColumns = ((HiveBucketProperty)bucketProperty.get()).getBucketedBy();
                    if (!tableBucketColumns.equals(partitionBucketColumns = partitionBucketProperty.get().getBucketedBy()) || !HiveSplitManager.isBucketCountCompatible(tableBucketCount, partitionBucketCount)) {
                        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH, String.format("Hive table (%s) bucketing (columns=%s, buckets=%s) is not compatible with partition (%s) bucketing (columns=%s, buckets=%s)", hivePartition.getTableName(), tableBucketColumns, tableBucketCount, hivePartition.getPartitionId(), partitionBucketColumns, partitionBucketCount));
                    }
                }
                results.add((Object)new HivePartitionMetadata(hivePartition, Optional.of(partition), tableToPartitionMapping));
            }
            return results.build();
        });
        return Iterables.concat((Iterable)partitionBatches);
    }

    private TableToPartitionMapping getTableToPartitionMapping(ConnectorSession session, SchemaTableName tableName, String partName, List<Column> tableColumns, List<Column> partitionColumns) {
        if (HiveSessionProperties.isPartitionUseColumnNames(session)) {
            return this.getTableToPartitionMappingByColumnNames(tableName, partName, tableColumns, partitionColumns);
        }
        ImmutableMap.Builder columnCoercions = ImmutableMap.builder();
        for (int i = 0; i < Math.min(partitionColumns.size(), tableColumns.size()); ++i) {
            HiveType partitionType;
            HiveType tableType = tableColumns.get(i).getType();
            if (tableType.equals(partitionType = partitionColumns.get(i).getType())) continue;
            if (!HiveCoercionPolicy.canCoerce(this.typeManager, partitionType, tableType)) {
                throw this.tablePartitionColumnMismatchException(tableName, partName, tableColumns.get(i).getName(), tableType, partitionColumns.get(i).getName(), partitionType);
            }
            columnCoercions.put((Object)i, (Object)partitionType.getHiveTypeName());
        }
        return TableToPartitionMapping.mapColumnsByIndex((Map<Integer, HiveTypeName>)columnCoercions.build());
    }

    private TableToPartitionMapping getTableToPartitionMappingByColumnNames(SchemaTableName tableName, String partName, List<Column> tableColumns, List<Column> partitionColumns) {
        ImmutableMap.Builder partitionColumnIndexesBuilder = ImmutableMap.builder();
        for (int i = 0; i < partitionColumns.size(); ++i) {
            partitionColumnIndexesBuilder.put((Object)partitionColumns.get(i).getName().toLowerCase(Locale.ENGLISH), (Object)i);
        }
        ImmutableMap partitionColumnsByIndex = partitionColumnIndexesBuilder.build();
        ImmutableMap.Builder columnCoercions = ImmutableMap.builder();
        ImmutableMap.Builder tableToPartitionColumns = ImmutableMap.builder();
        for (int tableColumnIndex = 0; tableColumnIndex < tableColumns.size(); ++tableColumnIndex) {
            Column tableColumn = tableColumns.get(tableColumnIndex);
            HiveType tableType = tableColumn.getType();
            Integer partitionColumnIndex = (Integer)partitionColumnsByIndex.get(tableColumn.getName().toLowerCase(Locale.ENGLISH));
            if (partitionColumnIndex == null) continue;
            tableToPartitionColumns.put((Object)tableColumnIndex, (Object)partitionColumnIndex);
            Column partitionColumn = partitionColumns.get(partitionColumnIndex);
            HiveType partitionType = partitionColumn.getType();
            if (tableType.equals(partitionType)) continue;
            if (!HiveCoercionPolicy.canCoerce(this.typeManager, partitionType, tableType)) {
                throw this.tablePartitionColumnMismatchException(tableName, partName, tableColumn.getName(), tableType, partitionColumn.getName(), partitionType);
            }
            columnCoercions.put((Object)partitionColumnIndex, (Object)partitionType.getHiveTypeName());
        }
        return new TableToPartitionMapping(Optional.of(tableToPartitionColumns.build()), (Map<Integer, HiveTypeName>)columnCoercions.build());
    }

    private PrestoException tablePartitionColumnMismatchException(SchemaTableName tableName, String partName, String tableColumnName, HiveType tableType, String partitionColumnName, HiveType partitionType) {
        return new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH, String.format("There is a mismatch between the table and partition schemas. The types are incompatible and cannot be coerced. The column '%s' in table '%s' is declared as type '%s', but partition '%s' declared column '%s' as type '%s'.", tableColumnName, tableName, tableType, partName, partitionColumnName, partitionType));
    }

    static boolean isBucketCountCompatible(int tableBucketCount, int partitionBucketCount) {
        Preconditions.checkArgument((tableBucketCount > 0 && partitionBucketCount > 0 ? 1 : 0) != 0);
        int larger = Math.max(tableBucketCount, partitionBucketCount);
        int smaller = Math.min(tableBucketCount, partitionBucketCount);
        if (larger % smaller != 0) {
            return false;
        }
        return Integer.bitCount(larger / smaller) == 1;
    }

    private static <T> Iterable<List<T>> partitionExponentially(final List<T> values, final int minBatchSize, final int maxBatchSize) {
        return () -> new AbstractIterator<List<T>>(){
            private int currentSize;
            private final Iterator iterator;
            {
                this.currentSize = minBatchSize;
                this.iterator = values.iterator();
            }

            protected List<T> computeNext() {
                if (!this.iterator.hasNext()) {
                    return (List)this.endOfData();
                }
                ImmutableList.Builder builder = ImmutableList.builder();
                for (int count = 0; this.iterator.hasNext() && count < this.currentSize; ++count) {
                    builder.add(this.iterator.next());
                }
                this.currentSize = Math.min(maxBatchSize, this.currentSize * 2);
                return builder.build();
            }
        };
    }

    private static class ErrorCodedExecutor
    implements Executor {
        private final Executor delegate;

        private ErrorCodedExecutor(Executor delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        }

        @Override
        public void execute(Runnable command) {
            try {
                this.delegate.execute(command);
            }
            catch (RejectedExecutionException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SERVER_SHUTTING_DOWN, "Server is shutting down", (Throwable)e);
            }
        }
    }
}

