/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.prestosql.plugin.hive.HiveBucketHandle;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HivePartition;
import io.prestosql.plugin.hive.acid.AcidTransaction;
import io.prestosql.plugin.hive.util.HiveBucketing;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.predicate.TupleDomain;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class HiveTableHandle
implements ConnectorTableHandle {
    private final String schemaName;
    private final String tableName;
    private final Optional<Map<String, String>> tableParameters;
    private final List<HiveColumnHandle> partitionColumns;
    private final List<HiveColumnHandle> dataColumns;
    private final Optional<List<HivePartition>> partitions;
    private final TupleDomain<HiveColumnHandle> compactEffectivePredicate;
    private final TupleDomain<ColumnHandle> enforcedConstraint;
    private final Optional<HiveBucketHandle> bucketHandle;
    private final Optional<HiveBucketing.HiveBucketFilter> bucketFilter;
    private final Optional<List<List<String>>> analyzePartitionValues;
    private final Optional<Set<String>> analyzeColumnNames;
    private final Optional<Set<ColumnHandle>> constraintColumns;
    private final AcidTransaction transaction;

    @JsonCreator
    public HiveTableHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="partitionColumns") List<HiveColumnHandle> partitionColumns, @JsonProperty(value="dataColumns") List<HiveColumnHandle> dataColumns, @JsonProperty(value="compactEffectivePredicate") TupleDomain<HiveColumnHandle> compactEffectivePredicate, @JsonProperty(value="enforcedConstraint") TupleDomain<ColumnHandle> enforcedConstraint, @JsonProperty(value="bucketHandle") Optional<HiveBucketHandle> bucketHandle, @JsonProperty(value="bucketFilter") Optional<HiveBucketing.HiveBucketFilter> bucketFilter, @JsonProperty(value="analyzePartitionValues") Optional<List<List<String>>> analyzePartitionValues, @JsonProperty(value="analyzeColumnNames") Optional<Set<String>> analyzeColumnNames, @JsonProperty(value="transaction") AcidTransaction transaction) {
        this(schemaName, tableName, Optional.empty(), partitionColumns, dataColumns, Optional.empty(), compactEffectivePredicate, enforcedConstraint, bucketHandle, bucketFilter, analyzePartitionValues, analyzeColumnNames, Optional.empty(), transaction);
    }

    public HiveTableHandle(String schemaName, String tableName, Map<String, String> tableParameters, List<HiveColumnHandle> partitionColumns, List<HiveColumnHandle> dataColumns, Optional<HiveBucketHandle> bucketHandle) {
        this(schemaName, tableName, Optional.of(tableParameters), partitionColumns, dataColumns, Optional.empty(), (TupleDomain<HiveColumnHandle>)TupleDomain.all(), (TupleDomain<ColumnHandle>)TupleDomain.all(), bucketHandle, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), AcidTransaction.NO_ACID_TRANSACTION);
    }

    public HiveTableHandle(String schemaName, String tableName, Optional<Map<String, String>> tableParameters, List<HiveColumnHandle> partitionColumns, List<HiveColumnHandle> dataColumns, Optional<List<HivePartition>> partitions, TupleDomain<HiveColumnHandle> compactEffectivePredicate, TupleDomain<ColumnHandle> enforcedConstraint, Optional<HiveBucketHandle> bucketHandle, Optional<HiveBucketing.HiveBucketFilter> bucketFilter, Optional<List<List<String>>> analyzePartitionValues, Optional<Set<String>> analyzeColumnNames, Optional<Set<ColumnHandle>> constraintColumns, AcidTransaction transaction) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.tableParameters = Objects.requireNonNull(tableParameters, "tableParameters is null").map(ImmutableMap::copyOf);
        this.partitionColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionColumns, "partitionColumns is null"));
        this.dataColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(dataColumns, "dataColumns is null"));
        this.partitions = Objects.requireNonNull(partitions, "partitions is null").map(ImmutableList::copyOf);
        this.compactEffectivePredicate = Objects.requireNonNull(compactEffectivePredicate, "compactEffectivePredicate is null");
        this.enforcedConstraint = Objects.requireNonNull(enforcedConstraint, "enforcedConstraint is null");
        this.bucketHandle = Objects.requireNonNull(bucketHandle, "bucketHandle is null");
        this.bucketFilter = Objects.requireNonNull(bucketFilter, "bucketFilter is null");
        this.analyzePartitionValues = Objects.requireNonNull(analyzePartitionValues, "analyzePartitionValues is null");
        this.analyzeColumnNames = Objects.requireNonNull(analyzeColumnNames, "analyzeColumnNames is null").map(ImmutableSet::copyOf);
        this.constraintColumns = Objects.requireNonNull(constraintColumns, "constraintColumns is null");
        this.transaction = Objects.requireNonNull(transaction, "transaction is null");
    }

    public HiveTableHandle withAnalyzePartitionValues(List<List<String>> analyzePartitionValues) {
        return new HiveTableHandle(this.schemaName, this.tableName, this.tableParameters, this.partitionColumns, this.dataColumns, this.partitions, this.compactEffectivePredicate, this.enforcedConstraint, this.bucketHandle, this.bucketFilter, Optional.of(analyzePartitionValues), this.analyzeColumnNames, this.constraintColumns, this.transaction);
    }

    public HiveTableHandle withAnalyzeColumnNames(Set<String> analyzeColumnNames) {
        return new HiveTableHandle(this.schemaName, this.tableName, this.tableParameters, this.partitionColumns, this.dataColumns, this.partitions, this.compactEffectivePredicate, this.enforcedConstraint, this.bucketHandle, this.bucketFilter, this.analyzePartitionValues, Optional.of(analyzeColumnNames), this.constraintColumns, this.transaction);
    }

    public HiveTableHandle withTransaction(AcidTransaction transaction) {
        return new HiveTableHandle(this.schemaName, this.tableName, this.tableParameters, this.partitionColumns, this.dataColumns, this.partitions, this.compactEffectivePredicate, this.enforcedConstraint, this.bucketHandle, this.bucketFilter, this.analyzePartitionValues, this.analyzeColumnNames, this.constraintColumns, transaction);
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonIgnore
    public Optional<Map<String, String>> getTableParameters() {
        return this.tableParameters;
    }

    @JsonProperty
    public List<HiveColumnHandle> getPartitionColumns() {
        return this.partitionColumns;
    }

    @JsonProperty
    public List<HiveColumnHandle> getDataColumns() {
        return this.dataColumns;
    }

    @JsonIgnore
    public Optional<List<HivePartition>> getPartitions() {
        return this.partitions;
    }

    @JsonProperty
    public TupleDomain<HiveColumnHandle> getCompactEffectivePredicate() {
        return this.compactEffectivePredicate;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getEnforcedConstraint() {
        return this.enforcedConstraint;
    }

    @JsonProperty
    public Optional<HiveBucketHandle> getBucketHandle() {
        return this.bucketHandle;
    }

    @JsonProperty
    public Optional<HiveBucketing.HiveBucketFilter> getBucketFilter() {
        return this.bucketFilter;
    }

    @JsonProperty
    public Optional<List<List<String>>> getAnalyzePartitionValues() {
        return this.analyzePartitionValues;
    }

    @JsonProperty
    public Optional<Set<String>> getAnalyzeColumnNames() {
        return this.analyzeColumnNames;
    }

    @JsonProperty
    public AcidTransaction getTransaction() {
        return this.transaction;
    }

    @JsonIgnore
    public Optional<Set<ColumnHandle>> getConstraintColumns() {
        return this.constraintColumns;
    }

    public SchemaTableName getSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    @JsonIgnore
    public boolean isAcidDelete() {
        return this.transaction.isDelete();
    }

    @JsonIgnore
    public boolean isInAcidTransaction() {
        return this.transaction.isAcidTransactionRunning();
    }

    @JsonIgnore
    public long getAcidTransactionId() {
        Preconditions.checkState((boolean)this.transaction.isAcidTransactionRunning(), (Object)"The AcidTransaction is not running");
        return this.transaction.getAcidTransactionId();
    }

    @JsonIgnore
    public long getWriteId() {
        Preconditions.checkState((boolean)this.transaction.isAcidTransactionRunning(), (Object)"The AcidTransaction is not running");
        return this.transaction.getWriteId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveTableHandle that = (HiveTableHandle)o;
        return Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.tableParameters, that.tableParameters) && Objects.equals(this.partitionColumns, that.partitionColumns) && Objects.equals(this.partitions, that.partitions) && Objects.equals(this.compactEffectivePredicate, that.compactEffectivePredicate) && Objects.equals(this.enforcedConstraint, that.enforcedConstraint) && Objects.equals(this.bucketHandle, that.bucketHandle) && Objects.equals(this.bucketFilter, that.bucketFilter) && Objects.equals(this.analyzePartitionValues, that.analyzePartitionValues) && Objects.equals(this.transaction, that.transaction);
    }

    public int hashCode() {
        return Objects.hash(this.schemaName, this.tableName, this.tableParameters, this.partitionColumns, this.partitions, this.compactEffectivePredicate, this.enforcedConstraint, this.bucketHandle, this.bucketFilter, this.analyzePartitionValues, this.transaction);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.schemaName).append(":").append(this.tableName);
        this.bucketHandle.ifPresent(bucket -> builder.append(" bucket=").append(bucket.getReadBucketCount()));
        return builder.toString();
    }
}

