/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.hive.HiveStorageFormat;
import io.prestosql.plugin.hive.HiveTimestampPrecision;
import io.prestosql.plugin.hive.HiveTypeName;
import io.prestosql.plugin.hive.metastore.StorageFormat;
import io.prestosql.plugin.hive.util.HiveTypeTranslator;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeSignature;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;

public final class HiveType {
    public static final HiveType HIVE_BOOLEAN = new HiveType((TypeInfo)TypeInfoFactory.booleanTypeInfo);
    public static final HiveType HIVE_BYTE = new HiveType((TypeInfo)TypeInfoFactory.byteTypeInfo);
    public static final HiveType HIVE_SHORT = new HiveType((TypeInfo)TypeInfoFactory.shortTypeInfo);
    public static final HiveType HIVE_INT = new HiveType((TypeInfo)TypeInfoFactory.intTypeInfo);
    public static final HiveType HIVE_LONG = new HiveType((TypeInfo)TypeInfoFactory.longTypeInfo);
    public static final HiveType HIVE_FLOAT = new HiveType((TypeInfo)TypeInfoFactory.floatTypeInfo);
    public static final HiveType HIVE_DOUBLE = new HiveType((TypeInfo)TypeInfoFactory.doubleTypeInfo);
    public static final HiveType HIVE_STRING = new HiveType((TypeInfo)TypeInfoFactory.stringTypeInfo);
    public static final HiveType HIVE_TIMESTAMP = new HiveType((TypeInfo)TypeInfoFactory.timestampTypeInfo);
    public static final HiveType HIVE_DATE = new HiveType((TypeInfo)TypeInfoFactory.dateTypeInfo);
    public static final HiveType HIVE_BINARY = new HiveType((TypeInfo)TypeInfoFactory.binaryTypeInfo);
    private final HiveTypeName hiveTypeName;
    private final TypeInfo typeInfo;

    private HiveType(TypeInfo typeInfo) {
        Objects.requireNonNull(typeInfo, "typeInfo is null");
        this.hiveTypeName = new HiveTypeName(typeInfo.getTypeName());
        this.typeInfo = typeInfo;
    }

    public HiveTypeName getHiveTypeName() {
        return this.hiveTypeName;
    }

    public ObjectInspector.Category getCategory() {
        return this.typeInfo.getCategory();
    }

    public TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public TypeSignature getTypeSignature() {
        return HiveTypeTranslator.toTypeSignature(this.typeInfo);
    }

    @Deprecated
    public Type getType(TypeManager typeManager) {
        return typeManager.getType(this.getTypeSignature());
    }

    public Type getType(TypeManager typeManager, HiveTimestampPrecision timestampPrecision) {
        Type tentativeType = typeManager.getType(this.getTypeSignature());
        if (tentativeType instanceof TimestampType) {
            return TimestampType.createTimestampType((int)timestampPrecision.getPrecision());
        }
        return tentativeType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveType hiveType = (HiveType)o;
        return this.hiveTypeName.equals(hiveType.hiveTypeName);
    }

    public int hashCode() {
        return this.hiveTypeName.hashCode();
    }

    @JsonValue
    public String toString() {
        return this.hiveTypeName.toString();
    }

    public boolean isSupportedType(StorageFormat storageFormat) {
        return HiveType.isSupportedType(this.getTypeInfo(), storageFormat);
    }

    public static boolean isSupportedType(TypeInfo typeInfo, StorageFormat storageFormat) {
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                return HiveTypeTranslator.fromPrimitiveType((PrimitiveTypeInfo)typeInfo) != null;
            }
            case MAP: {
                MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
                return HiveType.isSupportedType(mapTypeInfo.getMapKeyTypeInfo(), storageFormat) && HiveType.isSupportedType(mapTypeInfo.getMapValueTypeInfo(), storageFormat);
            }
            case LIST: {
                ListTypeInfo listTypeInfo = (ListTypeInfo)typeInfo;
                return HiveType.isSupportedType(listTypeInfo.getListElementTypeInfo(), storageFormat);
            }
            case STRUCT: {
                StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                return structTypeInfo.getAllStructFieldTypeInfos().stream().allMatch(fieldTypeInfo -> HiveType.isSupportedType(fieldTypeInfo, storageFormat));
            }
            case UNION: {
                if (!storageFormat.getSerDe().equalsIgnoreCase(HiveStorageFormat.AVRO.getSerDe()) && !storageFormat.getSerDe().equalsIgnoreCase(HiveStorageFormat.ORC.getSerDe())) break;
                UnionTypeInfo unionTypeInfo = (UnionTypeInfo)typeInfo;
                return unionTypeInfo.getAllUnionObjectTypeInfos().stream().allMatch(fieldTypeInfo -> HiveType.isSupportedType(fieldTypeInfo, storageFormat));
            }
        }
        return false;
    }

    @JsonCreator
    public static HiveType valueOf(String hiveTypeName) {
        Objects.requireNonNull(hiveTypeName, "hiveTypeName is null");
        return HiveType.toHiveType(TypeInfoUtils.getTypeInfoFromTypeString((String)hiveTypeName));
    }

    public static List<HiveType> toHiveTypes(String hiveTypes) {
        Objects.requireNonNull(hiveTypes, "hiveTypes is null");
        return ImmutableList.copyOf((Collection)((Collection)TypeInfoUtils.getTypeInfosFromTypeString((String)hiveTypes).stream().map(HiveType::toHiveType).collect(ImmutableList.toImmutableList())));
    }

    public static HiveType toHiveType(TypeInfo typeInfo) {
        Objects.requireNonNull(typeInfo, "typeInfo is null");
        return new HiveType(typeInfo);
    }

    public static HiveType toHiveType(Type type) {
        return new HiveType(HiveTypeTranslator.toTypeInfo(type));
    }

    public Optional<HiveType> getHiveTypeForDereferences(List<Integer> dereferences) {
        TypeInfo typeInfo = this.getTypeInfo();
        for (int fieldIndex : dereferences) {
            Preconditions.checkArgument((boolean)(typeInfo instanceof StructTypeInfo), (String)"typeInfo should be struct type", (Object)typeInfo);
            StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
            try {
                typeInfo = (TypeInfo)structTypeInfo.getAllStructFieldTypeInfos().get(fieldIndex);
            }
            catch (RuntimeException e) {
                return Optional.empty();
            }
        }
        return Optional.of(HiveType.toHiveType(typeInfo));
    }

    public List<String> getHiveDereferenceNames(List<Integer> dereferences) {
        ImmutableList.Builder dereferenceNames = ImmutableList.builder();
        TypeInfo typeInfo = this.getTypeInfo();
        for (int fieldIndex : dereferences) {
            Preconditions.checkArgument((boolean)(typeInfo instanceof StructTypeInfo), (String)"typeInfo should be struct type", (Object)typeInfo);
            StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
            Preconditions.checkArgument((fieldIndex >= 0 ? 1 : 0) != 0, (Object)"fieldIndex cannot be negative");
            Preconditions.checkArgument((fieldIndex < structTypeInfo.getAllStructFieldNames().size() ? 1 : 0) != 0, (Object)"fieldIndex should be less than the number of fields in the struct");
            String fieldName = (String)structTypeInfo.getAllStructFieldNames().get(fieldIndex);
            dereferenceNames.add((Object)fieldName);
            typeInfo = (TypeInfo)structTypeInfo.getAllStructFieldTypeInfos().get(fieldIndex);
        }
        return dereferenceNames.build();
    }
}

