/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.orc.OrcWriter;
import io.prestosql.plugin.hive.FileWriter;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HiveStorageFormat;
import io.prestosql.plugin.hive.HiveTableHandle;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.PartitionAndStatementId;
import io.prestosql.plugin.hive.acid.AcidSchema;
import io.prestosql.plugin.hive.metastore.StorageFormat;
import io.prestosql.plugin.hive.orc.OrcFileWriter;
import io.prestosql.plugin.hive.orc.OrcFileWriterFactory;
import io.prestosql.plugin.hive.util.ConfigurationUtils;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.Page;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.RunLengthEncodedBlock;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.UpdatablePageSource;
import io.prestosql.spi.predicate.Utils;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.AcidUtils;

public class HiveUpdatablePageSource
implements UpdatablePageSource {
    public static final int ORIGINAL_TRANSACTION_CHANNEL = 0;
    public static final int ROW_ID_CHANNEL = 1;
    public static final int BUCKET_CHANNEL = 2;
    public static final int ACID_ROW_STRUCT_COLUMN_ID = 6;
    public static final Block DELETE_OPERATION_BLOCK = Utils.nativeValueToBlock((Type)IntegerType.INTEGER, (Object)OrcWriter.OrcOperation.DELETE.getOperationNumber());
    public static final Pattern BUCKET_PATH_MATCHER = Pattern.compile("(?s)(?<rootDir>.*)/(?<dirStart>delta_[\\d]+_[\\d]+)_(?<statementId>[\\d]+)/(?<filenameBase>bucket_(?<bucketNumber>[\\d]+))(?<attemptId>_[\\d]+)?$");
    public static final Pattern ORIGINAL_FILE_PATH_MATCHER = Pattern.compile("(?s)(?<rootDir>.*)/(?<filename>(?<bucketNumber>[\\d]+)_(?<rest>.*)?)$");
    private final HiveTableHandle hiveTable;
    private final String partitionName;
    private final int statementId;
    private final ConnectorPageSource hivePageSource;
    private final OptionalInt bucketNumber;
    private final OrcFileWriterFactory orcFileWriterFactory;
    private final Configuration configuration;
    private final ConnectorSession session;
    private final Block hiveRowTypeNullsBlock;
    private final long writeId;
    private final Properties hiveAcidSchema;
    private final Path deleteDeltaDirectory;
    private final String bucketFilename;
    private long maxWriteId;
    private long rowCount;
    private Optional<FileWriter> writer = Optional.empty();
    private boolean closed;

    public HiveUpdatablePageSource(HiveTableHandle hiveTableHandle, String partitionName, int statementId, ConnectorPageSource hivePageSource, TypeManager typeManager, OptionalInt bucketNumber, Path bucketPath, boolean originalFile, OrcFileWriterFactory orcFileWriterFactory, Configuration configuration, ConnectorSession session, HiveType hiveRowType) {
        this.hiveTable = Objects.requireNonNull(hiveTableHandle, "hiveTable is null");
        this.partitionName = Objects.requireNonNull(partitionName, "partitionName is null");
        this.statementId = statementId;
        this.hivePageSource = Objects.requireNonNull(hivePageSource, "hivePageSource is null");
        this.bucketNumber = Objects.requireNonNull(bucketNumber, "bucketNumber is null");
        this.orcFileWriterFactory = Objects.requireNonNull(orcFileWriterFactory, "orcFileWriterFactory is null");
        this.configuration = Objects.requireNonNull(configuration, "configuration is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.hiveRowTypeNullsBlock = Utils.nativeValueToBlock((Type)hiveRowType.getType(typeManager), null);
        Preconditions.checkArgument((boolean)hiveTableHandle.isInAcidTransaction(), (String)"Not in a transaction; hiveTableHandle: %s", (Object)hiveTableHandle);
        this.writeId = hiveTableHandle.getWriteId();
        this.hiveAcidSchema = AcidSchema.createAcidSchema(hiveRowType);
        Objects.requireNonNull(bucketPath, "bucketPath is null");
        if (originalFile) {
            Matcher matcher = ORIGINAL_FILE_PATH_MATCHER.matcher(bucketPath.toString());
            Preconditions.checkArgument((boolean)matcher.matches(), (String)"Original file bucketPath doesn't have the required format: %s", (Object)bucketPath);
            this.bucketFilename = String.format("bucket_%05d", bucketNumber.isEmpty() ? 0 : bucketNumber.getAsInt());
            this.deleteDeltaDirectory = new Path(String.format("%s/%s", matcher.group("rootDir"), AcidUtils.deleteDeltaSubdir((long)this.writeId, (long)this.writeId, (int)statementId)));
        } else {
            Matcher matcher = BUCKET_PATH_MATCHER.matcher(bucketPath.toString());
            Preconditions.checkArgument((boolean)matcher.matches(), (String)"bucketPath doesn't have the required format: %s", (Object)bucketPath);
            this.bucketFilename = matcher.group("filenameBase");
            this.deleteDeltaDirectory = new Path(String.format("%s/%s", matcher.group("rootDir"), AcidUtils.deleteDeltaSubdir((long)this.writeId, (long)this.writeId, (int)statementId)));
        }
    }

    public void deleteRows(Block rowIds) {
        int positionCount = rowIds.getPositionCount();
        List blocks = rowIds.getChildren();
        Preconditions.checkArgument((blocks.size() == 3 ? 1 : 0) != 0, (Object)("The rowId block should have 3 children, but has " + blocks.size()));
        Block[] blockArray = new Block[]{new RunLengthEncodedBlock(DELETE_OPERATION_BLOCK, positionCount), (Block)blocks.get(0), (Block)blocks.get(2), (Block)blocks.get(1), RunLengthEncodedBlock.create((Type)BigintType.BIGINT, (Object)this.writeId, (int)positionCount), new RunLengthEncodedBlock(this.hiveRowTypeNullsBlock, positionCount)};
        Page deletePage = new Page(blockArray);
        Block block = (Block)blocks.get(0);
        for (int index = 0; index < positionCount; ++index) {
            this.maxWriteId = Math.max(this.maxWriteId, block.getLong(index, 0));
        }
        this.lazyInitializeFileWriter();
        Preconditions.checkArgument((boolean)this.writer.isPresent(), (Object)"writer not present");
        this.writer.get().appendRows(deletePage);
        this.rowCount += (long)positionCount;
    }

    private void lazyInitializeFileWriter() {
        if (this.writer.isEmpty()) {
            Properties schemaCopy = new Properties();
            schemaCopy.putAll((Map<?, ?>)this.hiveAcidSchema);
            this.writer = this.orcFileWriterFactory.createFileWriter(new Path(String.format("%s/%s", this.deleteDeltaDirectory, this.bucketFilename)), AcidSchema.ACID_COLUMN_NAMES, StorageFormat.fromHiveStorageFormat(HiveStorageFormat.ORC), schemaCopy, ConfigurationUtils.toJobConf(this.configuration), this.session, this.bucketNumber, this.hiveTable.getTransaction(), true);
        }
    }

    public CompletableFuture<Collection<Slice>> finish() {
        if (this.writer.isPresent()) {
            OrcFileWriter orcFileWriter = (OrcFileWriter)this.writer.get();
            orcFileWriter.setMaxWriteId(this.maxWriteId);
            orcFileWriter.commit();
            Slice fragment = Slices.wrappedBuffer((byte[])PartitionAndStatementId.CODEC.toJsonBytes((Object)new PartitionAndStatementId(this.partitionName, this.statementId, this.rowCount, this.deleteDeltaDirectory.toString())));
            return CompletableFuture.completedFuture(ImmutableList.of((Object)fragment));
        }
        return CompletableFuture.completedFuture(ImmutableList.of());
    }

    public long getCompletedBytes() {
        return this.hivePageSource.getCompletedBytes();
    }

    public long getReadTimeNanos() {
        return this.hivePageSource.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.closed;
    }

    public Page getNextPage() {
        Page page = this.hivePageSource.getNextPage();
        if (page == null) {
            this.close();
            return null;
        }
        return page;
    }

    public long getSystemMemoryUsage() {
        return this.hivePageSource.getSystemMemoryUsage();
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.hivePageSource.close();
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, (Throwable)e);
        }
    }
}

