/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.base.CatalogName;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HiveQlToPrestoTranslator;
import io.prestosql.plugin.hive.ViewReaderUtil;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.connector.ConnectorViewDefinition;
import io.prestosql.spi.type.TypeId;
import java.util.List;
import java.util.Optional;

public class LegacyHiveViewReader
implements ViewReaderUtil.ViewReader {
    @Override
    public ConnectorViewDefinition decodeViewData(String viewData, Table table, CatalogName catalogName) {
        String viewText = table.getViewExpandedText().orElseThrow(() -> new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "No view expanded text: " + table.getSchemaTableName()));
        return new ConnectorViewDefinition(HiveQlToPrestoTranslator.translateHiveViewToPresto(viewText), Optional.of(catalogName.toString()), Optional.ofNullable(table.getDatabaseName()), (List)table.getDataColumns().stream().map(column -> new ConnectorViewDefinition.ViewColumn(column.getName(), TypeId.of((String)column.getType().getTypeSignature().toString()))).collect(ImmutableList.toImmutableList()), Optional.ofNullable(table.getParameters().get("comment")), Optional.of(table.getOwner()), false);
    }
}

