/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import io.prestosql.plugin.hive.HiveBasicStatistics;
import io.prestosql.plugin.hive.metastore.HiveColumnStatistics;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class PartitionStatistics {
    private static final PartitionStatistics EMPTY = new PartitionStatistics(HiveBasicStatistics.createEmptyStatistics(), (Map<String, HiveColumnStatistics>)ImmutableMap.of());
    private final HiveBasicStatistics basicStatistics;
    private final Map<String, HiveColumnStatistics> columnStatistics;

    public static PartitionStatistics empty() {
        return EMPTY;
    }

    @JsonCreator
    public PartitionStatistics(@JsonProperty(value="basicStatistics") HiveBasicStatistics basicStatistics, @JsonProperty(value="columnStatistics") Map<String, HiveColumnStatistics> columnStatistics) {
        this.basicStatistics = Objects.requireNonNull(basicStatistics, "basicStatistics is null");
        this.columnStatistics = ImmutableMap.copyOf(Objects.requireNonNull(columnStatistics, "columnStatistics cannot be null"));
    }

    @JsonProperty
    public HiveBasicStatistics getBasicStatistics() {
        return this.basicStatistics;
    }

    @JsonProperty
    public Map<String, HiveColumnStatistics> getColumnStatistics() {
        return this.columnStatistics;
    }

    public PartitionStatistics withAdjustedRowCount(long adjustment) {
        return new PartitionStatistics(this.basicStatistics.withAdjustedRowCount(adjustment), this.columnStatistics);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionStatistics that = (PartitionStatistics)o;
        return Objects.equals(this.basicStatistics, that.basicStatistics) && Objects.equals(this.columnStatistics, that.columnStatistics);
    }

    public int hashCode() {
        return Objects.hash(this.basicStatistics, this.columnStatistics);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("basicStatistics", (Object)this.basicStatistics).add("columnStatistics", this.columnStatistics).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private HiveBasicStatistics basicStatistics = HiveBasicStatistics.createEmptyStatistics();
        private Map<String, HiveColumnStatistics> columnStatistics = ImmutableMap.of();

        public Builder setBasicStatistics(HiveBasicStatistics basicStatistics) {
            this.basicStatistics = Objects.requireNonNull(basicStatistics, "basicStatistics is null");
            return this;
        }

        public Builder setColumnStatistics(Map<String, HiveColumnStatistics> columnStatistics) {
            this.columnStatistics = ImmutableMap.copyOf(Objects.requireNonNull(columnStatistics, "columnStatistics is null"));
            return this;
        }

        public PartitionStatistics build() {
            return new PartitionStatistics(this.basicStatistics, this.columnStatistics);
        }
    }
}

