/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.spi.connector.ColumnHandle;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ReaderColumns {
    private final List<ColumnHandle> readerColumns;
    private final List<Integer> readerBlockIndices;

    public ReaderColumns(List<? extends ColumnHandle> readerColumns, List<Integer> readerBlockIndices) {
        this.readerColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(readerColumns, "readerColumns is null"));
        readerBlockIndices.forEach(value -> Preconditions.checkArgument((value >= 0 && value < readerColumns.size() ? 1 : 0) != 0, (Object)"block index out of bounds"));
        this.readerBlockIndices = ImmutableList.copyOf((Collection)Objects.requireNonNull(readerBlockIndices, "readerBlockIndices is null"));
    }

    public ColumnHandle getForColumnAt(int index) {
        Preconditions.checkArgument((index >= 0 && index < this.readerBlockIndices.size() ? 1 : 0) != 0, (Object)"index is not valid");
        int readerIndex = this.readerBlockIndices.get(index);
        return this.readerColumns.get(readerIndex);
    }

    public int getPositionForColumnAt(int index) {
        Preconditions.checkArgument((index >= 0 && index < this.readerBlockIndices.size() ? 1 : 0) != 0, (Object)"index is invalid");
        return this.readerBlockIndices.get(index);
    }

    public List<ColumnHandle> get() {
        return this.readerColumns;
    }
}

