/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.coercions;

import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.Type;
import java.util.Objects;
import java.util.function.Function;

public abstract class TypeCoercer<F extends Type, T extends Type>
implements Function<Block, Block> {
    protected final F fromType;
    protected final T toType;

    protected TypeCoercer(F fromType, T toType) {
        this.fromType = (Type)Objects.requireNonNull(fromType);
        this.toType = (Type)Objects.requireNonNull(toType);
    }

    @Override
    public Block apply(Block block) {
        BlockBuilder blockBuilder = this.toType.createBlockBuilder(null, block.getPositionCount());
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (block.isNull(i)) {
                blockBuilder.appendNull();
                continue;
            }
            this.applyCoercedValue(blockBuilder, block, i);
        }
        return blockBuilder.build();
    }

    protected abstract void applyCoercedValue(BlockBuilder var1, Block var2, int var3);
}

