/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.coercions;

import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.prestosql.plugin.hive.HivePageSource;
import io.prestosql.plugin.hive.coercions.TypeCoercer;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.spi.type.Varchars;

public class VarcharCoercer
extends TypeCoercer<VarcharType, VarcharType> {
    public VarcharCoercer(VarcharType fromType, VarcharType toType) {
        super(fromType, toType);
        Preconditions.checkArgument((boolean)HivePageSource.narrowerThan(toType, fromType), (Object)"Coercer to a wider varchar type should not be required");
    }

    @Override
    protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
        Slice value = ((VarcharType)this.fromType).getSlice(block, position);
        ((VarcharType)this.toType).writeSlice(blockBuilder, Varchars.truncateToLength((Slice)value, (VarcharType)((VarcharType)this.toType)));
    }
}

