/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.linkedin.coral.hive.hive2rel.HiveMetastoreClient;
import io.prestosql.plugin.hive.authentication.HiveIdentity;
import io.prestosql.plugin.hive.metastore.HivePrivilegeInfo;
import io.prestosql.plugin.hive.metastore.PrincipalPrivileges;
import io.prestosql.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Table;

public class CoralSemiTransactionalHiveMSCAdapter
implements HiveMetastoreClient {
    private final SemiTransactionalHiveMetastore delegate;
    private final HiveIdentity identity;

    public CoralSemiTransactionalHiveMSCAdapter(SemiTransactionalHiveMetastore coralHiveMetastoreClient, HiveIdentity identity) {
        this.delegate = Objects.requireNonNull(coralHiveMetastoreClient, "coralHiveMetastoreClient is null");
        this.identity = identity;
    }

    public List<String> getAllDatabases() {
        return this.delegate.getAllDatabases();
    }

    public Database getDatabase(String dbName) {
        return this.delegate.getDatabase(dbName).map(ThriftMetastoreUtil::toMetastoreApiDatabase).orElse(null);
    }

    public List<String> getAllTables(String dbName) {
        return this.delegate.getAllTables(dbName);
    }

    public Table getTable(String dbName, String tableName) {
        return this.delegate.getTable(this.identity, dbName, tableName).map(value -> ThriftMetastoreUtil.toMetastoreApiTable(value, new PrincipalPrivileges((Multimap<String, HivePrivilegeInfo>)ImmutableMultimap.of(), (Multimap<String, HivePrivilegeInfo>)ImmutableMultimap.of()))).orElse(null);
    }
}

