/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore;

import com.google.inject.Binder;
import com.google.inject.Module;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.plugin.hive.metastore.MetastoreTypeConfig;
import io.prestosql.plugin.hive.metastore.alluxio.AlluxioMetastoreModule;
import io.prestosql.plugin.hive.metastore.cache.CachingHiveMetastoreModule;
import io.prestosql.plugin.hive.metastore.cache.ForCachingHiveMetastore;
import io.prestosql.plugin.hive.metastore.file.FileMetastoreModule;
import io.prestosql.plugin.hive.metastore.glue.GlueMetastoreModule;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastoreModule;
import java.util.Optional;

public class HiveMetastoreModule
extends AbstractConfigurationAwareModule {
    private final Optional<HiveMetastore> metastore;

    public HiveMetastoreModule(Optional<HiveMetastore> metastore) {
        this.metastore = metastore;
    }

    protected void setup(Binder binder) {
        if (this.metastore.isPresent()) {
            binder.bind(HiveMetastore.class).annotatedWith(ForCachingHiveMetastore.class).toInstance((Object)this.metastore.get());
            this.install(new CachingHiveMetastoreModule());
        } else {
            this.bindMetastoreModule("thrift", (Module)new ThriftMetastoreModule());
            this.bindMetastoreModule("file", new FileMetastoreModule());
            this.bindMetastoreModule("glue", (Module)new GlueMetastoreModule());
            this.bindMetastoreModule("alluxio", (Module)new AlluxioMetastoreModule());
        }
    }

    private void bindMetastoreModule(String name, Module module) {
        this.install(ConditionalModule.installModuleIf(MetastoreTypeConfig.class, metastore -> name.equalsIgnoreCase(metastore.getMetastoreType()), (Module)module));
    }
}

