/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore.alluxio;

import alluxio.grpc.table.BinaryColumnStatsData;
import alluxio.grpc.table.BooleanColumnStatsData;
import alluxio.grpc.table.ColumnStatisticsData;
import alluxio.grpc.table.Date;
import alluxio.grpc.table.DateColumnStatsData;
import alluxio.grpc.table.Decimal;
import alluxio.grpc.table.DecimalColumnStatsData;
import alluxio.grpc.table.DoubleColumnStatsData;
import alluxio.grpc.table.FieldSchema;
import alluxio.grpc.table.Layout;
import alluxio.grpc.table.LongColumnStatsData;
import alluxio.grpc.table.PrincipalType;
import alluxio.grpc.table.StringColumnStatsData;
import alluxio.grpc.table.TableInfo;
import alluxio.grpc.table.layout.hive.PartitionInfo;
import alluxio.grpc.table.layout.hive.SortingColumn;
import alluxio.grpc.table.layout.hive.Storage;
import alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import io.prestosql.plugin.hive.HiveBucketProperty;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.metastore.Column;
import io.prestosql.plugin.hive.metastore.Database;
import io.prestosql.plugin.hive.metastore.HiveColumnStatistics;
import io.prestosql.plugin.hive.metastore.Partition;
import io.prestosql.plugin.hive.metastore.SortingColumn;
import io.prestosql.plugin.hive.metastore.StorageFormat;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.prestosql.plugin.hive.util.HiveBucketing;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.Set;
import javax.annotation.Nullable;

public final class ProtoUtils {
    private ProtoUtils() {
    }

    public static Database fromProto(alluxio.grpc.table.Database db) {
        return Database.builder().setDatabaseName(db.getDbName()).setLocation(db.hasLocation() ? Optional.of(db.getLocation()) : Optional.empty()).setOwnerName(db.getOwnerName()).setOwnerType(db.getOwnerType() == PrincipalType.USER ? io.prestosql.spi.security.PrincipalType.USER : io.prestosql.spi.security.PrincipalType.ROLE).setComment(db.hasComment() ? Optional.of(db.getComment()) : Optional.empty()).setParameters(db.getParameterMap()).build();
    }

    public static Table fromProto(TableInfo table) {
        if (!table.hasLayout()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported table metadata. missing layout.: " + table.getTableName());
        }
        Layout layout = table.getLayout();
        if (!alluxio.table.ProtoUtils.isHiveLayout((Layout)layout)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported table layout: " + layout + " for table: " + table.getTableName());
        }
        try {
            PartitionInfo partitionInfo = alluxio.table.ProtoUtils.toHiveLayout((Layout)layout);
            Set partitionColumns = (Set)table.getPartitionColsList().stream().map(FieldSchema::getName).collect(ImmutableSet.toImmutableSet());
            List dataColumns = (List)table.getSchema().getColsList().stream().filter(f -> !partitionColumns.contains(f.getName())).collect(ImmutableList.toImmutableList());
            Map tableParameters = table.getParametersMap();
            Table.Builder builder = Table.builder().setDatabaseName(table.getDbName()).setTableName(table.getTableName()).setOwner(table.getOwner()).setTableType(table.getType().toString()).setDataColumns((List)dataColumns.stream().map(ProtoUtils::fromProto).collect(ImmutableList.toImmutableList())).setPartitionColumns((List)table.getPartitionColsList().stream().map(ProtoUtils::fromProto).collect(ImmutableList.toImmutableList())).setParameters(tableParameters).setViewOriginalText(Optional.empty()).setViewExpandedText(Optional.empty());
            Storage storage = partitionInfo.getStorage();
            builder.getStorageBuilder().setSkewed(storage.getSkewed()).setStorageFormat(ProtoUtils.fromProto(storage.getStorageFormat())).setLocation(storage.getLocation()).setBucketProperty(storage.hasBucketProperty() ? ProtoUtils.fromProto(tableParameters, storage.getBucketProperty()) : Optional.empty()).setSerdeParameters(storage.getStorageFormat().getSerdelibParametersMap());
            return builder.build();
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Failed to extract PartitionInfo from TableInfo", e);
        }
    }

    static SortingColumn fromProto(alluxio.grpc.table.layout.hive.SortingColumn column) {
        if (column.getOrder().equals((Object)SortingColumn.SortingOrder.ASCENDING)) {
            return new SortingColumn(column.getColumnName(), SortingColumn.Order.ASCENDING);
        }
        if (column.getOrder().equals((Object)SortingColumn.SortingOrder.DESCENDING)) {
            return new SortingColumn(column.getColumnName(), SortingColumn.Order.DESCENDING);
        }
        throw new IllegalArgumentException("Invalid sort order: " + column.getOrder());
    }

    static Optional<HiveBucketProperty> fromProto(Map<String, String> tableParameters, alluxio.grpc.table.layout.hive.HiveBucketProperty property) {
        if (!property.hasBucketCount() || property.getBucketCount() <= 0L) {
            return Optional.empty();
        }
        List sortedBy = (List)property.getSortedByList().stream().map(ProtoUtils::fromProto).collect(ImmutableList.toImmutableList());
        HiveBucketing.BucketingVersion bucketingVersion = HiveBucketing.getBucketingVersion(tableParameters);
        return Optional.of(new HiveBucketProperty((List<String>)property.getBucketedByList(), bucketingVersion, (int)property.getBucketCount(), sortedBy));
    }

    static StorageFormat fromProto(alluxio.grpc.table.layout.hive.StorageFormat format) {
        return StorageFormat.create(format.getSerde(), format.getInputFormat(), format.getOutputFormat());
    }

    private static Optional<BigDecimal> fromMetastoreDecimal(@Nullable Decimal decimal) {
        if (decimal == null) {
            return Optional.empty();
        }
        return Optional.of(new BigDecimal(new BigInteger(decimal.getUnscaled().toByteArray()), decimal.getScale()));
    }

    private static Optional<LocalDate> fromMetastoreDate(@Nullable Date date) {
        if (date == null) {
            return Optional.empty();
        }
        return Optional.of(LocalDate.ofEpochDay(date.getDaysSinceEpoch()));
    }

    public static HiveColumnStatistics fromProto(ColumnStatisticsData columnStatistics, OptionalLong rowCount) {
        if (columnStatistics.hasLongStats()) {
            LongColumnStatsData longStatsData = columnStatistics.getLongStats();
            OptionalLong min = longStatsData.hasLowValue() ? OptionalLong.of(longStatsData.getLowValue()) : OptionalLong.empty();
            OptionalLong max = longStatsData.hasHighValue() ? OptionalLong.of(longStatsData.getHighValue()) : OptionalLong.empty();
            OptionalLong nullsCount = longStatsData.hasNumNulls() ? ThriftMetastoreUtil.fromMetastoreNullsCount(longStatsData.getNumNulls()) : OptionalLong.empty();
            OptionalLong distinctValuesCount = longStatsData.hasNumDistincts() ? OptionalLong.of(longStatsData.getNumDistincts()) : OptionalLong.empty();
            return HiveColumnStatistics.createIntegerColumnStatistics(min, max, nullsCount, ThriftMetastoreUtil.fromMetastoreDistinctValuesCount(distinctValuesCount, nullsCount, rowCount));
        }
        if (columnStatistics.hasDoubleStats()) {
            DoubleColumnStatsData doubleStatsData = columnStatistics.getDoubleStats();
            OptionalDouble min = doubleStatsData.hasLowValue() ? OptionalDouble.of(doubleStatsData.getLowValue()) : OptionalDouble.empty();
            OptionalDouble max = doubleStatsData.hasHighValue() ? OptionalDouble.of(doubleStatsData.getHighValue()) : OptionalDouble.empty();
            OptionalLong nullsCount = doubleStatsData.hasNumNulls() ? ThriftMetastoreUtil.fromMetastoreNullsCount(doubleStatsData.getNumNulls()) : OptionalLong.empty();
            OptionalLong distinctValuesCount = doubleStatsData.hasNumDistincts() ? OptionalLong.of(doubleStatsData.getNumDistincts()) : OptionalLong.empty();
            return HiveColumnStatistics.createDoubleColumnStatistics(min, max, nullsCount, ThriftMetastoreUtil.fromMetastoreDistinctValuesCount(distinctValuesCount, nullsCount, rowCount));
        }
        if (columnStatistics.hasDecimalStats()) {
            DecimalColumnStatsData decimalStatsData = columnStatistics.getDecimalStats();
            Optional<BigDecimal> min = decimalStatsData.hasLowValue() ? ProtoUtils.fromMetastoreDecimal(decimalStatsData.getLowValue()) : Optional.empty();
            Optional<BigDecimal> max = decimalStatsData.hasHighValue() ? ProtoUtils.fromMetastoreDecimal(decimalStatsData.getHighValue()) : Optional.empty();
            OptionalLong nullsCount = decimalStatsData.hasNumNulls() ? ThriftMetastoreUtil.fromMetastoreNullsCount(decimalStatsData.getNumNulls()) : OptionalLong.empty();
            OptionalLong distinctValuesCount = decimalStatsData.hasNumDistincts() ? OptionalLong.of(decimalStatsData.getNumDistincts()) : OptionalLong.empty();
            return HiveColumnStatistics.createDecimalColumnStatistics(min, max, nullsCount, ThriftMetastoreUtil.fromMetastoreDistinctValuesCount(distinctValuesCount, nullsCount, rowCount));
        }
        if (columnStatistics.hasDateStats()) {
            DateColumnStatsData dateStatsData = columnStatistics.getDateStats();
            Optional<LocalDate> min = dateStatsData.hasLowValue() ? ProtoUtils.fromMetastoreDate(dateStatsData.getLowValue()) : Optional.empty();
            Optional<LocalDate> max = dateStatsData.hasHighValue() ? ProtoUtils.fromMetastoreDate(dateStatsData.getHighValue()) : Optional.empty();
            OptionalLong nullsCount = dateStatsData.hasNumNulls() ? ThriftMetastoreUtil.fromMetastoreNullsCount(dateStatsData.getNumNulls()) : OptionalLong.empty();
            OptionalLong distinctValuesCount = dateStatsData.hasNumDistincts() ? OptionalLong.of(dateStatsData.getNumDistincts()) : OptionalLong.empty();
            return HiveColumnStatistics.createDateColumnStatistics(min, max, nullsCount, ThriftMetastoreUtil.fromMetastoreDistinctValuesCount(distinctValuesCount, nullsCount, rowCount));
        }
        if (columnStatistics.hasBooleanStats()) {
            BooleanColumnStatsData booleanStatsData = columnStatistics.getBooleanStats();
            OptionalLong trueCount = OptionalLong.empty();
            OptionalLong falseCount = OptionalLong.empty();
            if (booleanStatsData.hasNumTrues() && booleanStatsData.hasNumFalses() && booleanStatsData.getNumFalses() != -1L) {
                trueCount = OptionalLong.of(booleanStatsData.getNumTrues());
                falseCount = OptionalLong.of(booleanStatsData.getNumFalses());
            }
            return HiveColumnStatistics.createBooleanColumnStatistics(trueCount, falseCount, booleanStatsData.hasNumNulls() ? ThriftMetastoreUtil.fromMetastoreNullsCount(booleanStatsData.getNumNulls()) : OptionalLong.empty());
        }
        if (columnStatistics.hasStringStats()) {
            StringColumnStatsData stringStatsData = columnStatistics.getStringStats();
            OptionalLong maxColumnLength = stringStatsData.hasMaxColLen() ? OptionalLong.of(stringStatsData.getMaxColLen()) : OptionalLong.empty();
            OptionalDouble averageColumnLength = stringStatsData.hasAvgColLen() ? OptionalDouble.of(stringStatsData.getAvgColLen()) : OptionalDouble.empty();
            OptionalLong nullsCount = stringStatsData.hasNumNulls() ? ThriftMetastoreUtil.fromMetastoreNullsCount(stringStatsData.getNumNulls()) : OptionalLong.empty();
            OptionalLong distinctValuesCount = stringStatsData.hasNumDistincts() ? OptionalLong.of(stringStatsData.getNumDistincts()) : OptionalLong.empty();
            return HiveColumnStatistics.createStringColumnStatistics(maxColumnLength, ThriftMetastoreUtil.getTotalSizeInBytes(averageColumnLength, rowCount, nullsCount), nullsCount, ThriftMetastoreUtil.fromMetastoreDistinctValuesCount(distinctValuesCount, nullsCount, rowCount));
        }
        if (columnStatistics.hasBinaryStats()) {
            BinaryColumnStatsData binaryStatsData = columnStatistics.getBinaryStats();
            OptionalLong maxColumnLength = binaryStatsData.hasMaxColLen() ? OptionalLong.of(binaryStatsData.getMaxColLen()) : OptionalLong.empty();
            OptionalDouble averageColumnLength = binaryStatsData.hasAvgColLen() ? OptionalDouble.of(binaryStatsData.getAvgColLen()) : OptionalDouble.empty();
            OptionalLong nullsCount = binaryStatsData.hasNumNulls() ? ThriftMetastoreUtil.fromMetastoreNullsCount(binaryStatsData.getNumNulls()) : OptionalLong.empty();
            return HiveColumnStatistics.createBinaryColumnStatistics(maxColumnLength, ThriftMetastoreUtil.getTotalSizeInBytes(averageColumnLength, rowCount, nullsCount), nullsCount);
        }
        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Invalid column statistics data: " + columnStatistics);
    }

    static Column fromProto(FieldSchema column) {
        Optional<String> comment = column.hasComment() ? Optional.of(column.getComment()) : Optional.empty();
        return new Column(column.getName(), HiveType.valueOf(column.getType()), comment);
    }

    public static Partition fromProto(PartitionInfo info) {
        Map parametersMap = info.getParametersMap();
        Partition.Builder builder = Partition.builder().setColumns((List)info.getDataColsList().stream().map(ProtoUtils::fromProto).collect(ImmutableList.toImmutableList())).setDatabaseName(info.getDbName()).setParameters(parametersMap).setValues(Lists.newArrayList((Iterable)info.getValuesList())).setTableName(info.getTableName());
        builder.getStorageBuilder().setSkewed(info.getStorage().getSkewed()).setStorageFormat(ProtoUtils.fromProto(info.getStorage().getStorageFormat())).setLocation(info.getStorage().getLocation()).setBucketProperty(info.getStorage().hasBucketProperty() ? ProtoUtils.fromProto(parametersMap, info.getStorage().getBucketProperty()) : Optional.empty()).setSerdeParameters(info.getStorage().getStorageFormat().getSerdelibParametersMap());
        return builder.build();
    }

    public static PartitionInfo toPartitionInfo(alluxio.grpc.table.Partition part) {
        try {
            return alluxio.table.ProtoUtils.extractHiveLayout((alluxio.grpc.table.Partition)part);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Failed to extract PartitionInfo", e);
        }
    }

    public static List<PartitionInfo> toPartitionInfoList(List<alluxio.grpc.table.Partition> parts) {
        return (List)parts.stream().map(ProtoUtils::toPartitionInfo).collect(ImmutableList.toImmutableList());
    }
}

