/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore.glue;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.prestosql.plugin.hive.metastore.MetastoreUtil;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.Marker;
import io.prestosql.spi.predicate.Range;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.predicate.ValueSet;
import io.prestosql.spi.type.CharType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public final class GlueExpressionUtil {
    static final String NULL_STRING = "__HIVE_DEFAULT_PARTITION__";
    static final int GLUE_EXPRESSION_CHAR_LIMIT = 2048;
    private static final Set<String> QUOTED_TYPES = ImmutableSet.of((Object)"string", (Object)"char", (Object)"varchar", (Object)"date", (Object)"timestamp", (Object)"binary", (Object[])new String[]{"varbinary"});
    private static final String CONJUNCT_SEPARATOR = " AND ";
    private static final Joiner CONJUNCT_JOINER = Joiner.on((String)" AND ");
    private static final String DISJUNCT_SEPARATOR = " OR ";
    private static final Joiner DISJUNCT_JOINER = Joiner.on((String)" OR ");

    private GlueExpressionUtil() {
    }

    private static boolean isQuotedType(Type type) {
        return QUOTED_TYPES.contains(type.getTypeSignature().getBase());
    }

    private static String valueToString(Type type, Object value) {
        String s = MetastoreUtil.sqlScalarToString(type, value, NULL_STRING);
        return GlueExpressionUtil.isQuotedType(type) ? "'" + s + "'" : s;
    }

    private static boolean canConvertSqlTypeToStringForGlue(Type type, boolean assumeCanonicalPartitionKeys) {
        return !(type instanceof TimestampType) && !(type instanceof DateType) && (type instanceof CharType || type instanceof VarcharType || assumeCanonicalPartitionKeys);
    }

    public static String buildGlueExpression(List<String> columnNames, TupleDomain<String> partitionKeysFilter, boolean assumeCanonicalPartitionKeys) {
        return GlueExpressionUtil.buildGlueExpression(columnNames, partitionKeysFilter, assumeCanonicalPartitionKeys, 2048);
    }

    public static String buildGlueExpression(List<String> columnNames, TupleDomain<String> partitionKeysFilter, boolean assumeCanonicalPartitionKeys, int expressionLengthLimit) {
        Preconditions.checkState((!partitionKeysFilter.isNone() ? 1 : 0) != 0);
        if (partitionKeysFilter.isAll()) {
            return "";
        }
        ArrayList<String> perColumnExpressions = new ArrayList<String>();
        int expressionLength = 0;
        Map domains = (Map)partitionKeysFilter.getDomains().get();
        for (String columnName : columnNames) {
            Optional<String> columnExpression;
            Domain domain = (Domain)domains.get(columnName);
            if (domain == null || !(columnExpression = GlueExpressionUtil.buildGlueExpressionForSingleDomain(columnName, domain, assumeCanonicalPartitionKeys)).isPresent()) continue;
            int newExpressionLength = expressionLength;
            if (expressionLength > 0) {
                newExpressionLength += CONJUNCT_SEPARATOR.length();
            }
            if ((newExpressionLength += columnExpression.get().length()) > expressionLengthLimit) continue;
            perColumnExpressions.add(columnExpression.get());
            expressionLength = newExpressionLength;
        }
        return Joiner.on((String)CONJUNCT_SEPARATOR).join(perColumnExpressions);
    }

    @VisibleForTesting
    static Optional<String> buildGlueExpressionForSingleDomain(String columnName, Domain domain, boolean assumeCanonicalPartitionKeys) {
        ValueSet valueSet = domain.getValues();
        if (domain.isAll() || !GlueExpressionUtil.canConvertSqlTypeToStringForGlue(domain.getType(), assumeCanonicalPartitionKeys)) {
            return Optional.empty();
        }
        if (domain.getValues().isAll()) {
            return Optional.of(String.format("(%s <> '%s')", columnName, NULL_STRING));
        }
        if (domain.getValues().isNone()) {
            return Optional.of(String.format("(%s = '%s')", columnName, NULL_STRING));
        }
        ArrayList<Object> disjuncts = new ArrayList<Object>();
        ArrayList<String> singleValues = new ArrayList<String>();
        for (Range range : valueSet.getRanges().getOrderedRanges()) {
            Preconditions.checkState((!range.isAll() ? 1 : 0) != 0);
            if (range.isSingleValue()) {
                Marker rangeLow = range.getLow();
                singleValues.add(GlueExpressionUtil.valueToString(rangeLow.getType(), rangeLow.getValue()));
                continue;
            }
            ArrayList<String> rangeConjuncts = new ArrayList<String>();
            if (!range.getLow().isLowerUnbounded()) {
                Marker rangeLow = range.getLow();
                switch (range.getLow().getBound()) {
                    case ABOVE: {
                        rangeConjuncts.add(String.format("%s > %s", columnName, GlueExpressionUtil.valueToString(rangeLow.getType(), rangeLow.getValue())));
                        break;
                    }
                    case EXACTLY: {
                        rangeConjuncts.add(String.format("%s >= %s", columnName, GlueExpressionUtil.valueToString(rangeLow.getType(), rangeLow.getValue())));
                        break;
                    }
                    case BELOW: {
                        throw new IllegalArgumentException("Low marker should never use BELOW bound");
                    }
                    default: {
                        throw new AssertionError((Object)("Unhandled bound: " + range.getLow().getBound()));
                    }
                }
            }
            if (!range.getHigh().isUpperUnbounded()) {
                Marker rangeHigh = range.getHigh();
                switch (range.getHigh().getBound()) {
                    case ABOVE: {
                        throw new IllegalArgumentException("High marker should never use ABOVE bound");
                    }
                    case EXACTLY: {
                        rangeConjuncts.add(String.format("%s <= %s", columnName, GlueExpressionUtil.valueToString(rangeHigh.getType(), rangeHigh.getValue())));
                        break;
                    }
                    case BELOW: {
                        rangeConjuncts.add(String.format("%s < %s", columnName, GlueExpressionUtil.valueToString(rangeHigh.getType(), rangeHigh.getValue())));
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unhandled bound: " + range.getHigh().getBound()));
                    }
                }
            }
            Preconditions.checkState((!rangeConjuncts.isEmpty() ? 1 : 0) != 0);
            disjuncts.add("(" + CONJUNCT_JOINER.join(rangeConjuncts) + ")");
        }
        if (singleValues.size() == 1) {
            String equalsTest = String.format("(%s = %s)", columnName, Iterables.getOnlyElement(singleValues));
            disjuncts.add(equalsTest);
        } else if (singleValues.size() > 1) {
            String values = Joiner.on((String)", ").join(singleValues);
            String inClause = String.format("(%s in (%s))", columnName, values);
            disjuncts.add(inClause);
        }
        return Optional.of("(" + DISJUNCT_JOINER.join(disjuncts) + ")");
    }
}

