/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore.glue;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.glue.AWSGlueAsync;
import com.amazonaws.services.glue.AWSGlueAsyncClientBuilder;
import com.amazonaws.services.glue.model.AlreadyExistsException;
import com.amazonaws.services.glue.model.BatchCreatePartitionRequest;
import com.amazonaws.services.glue.model.BatchCreatePartitionResult;
import com.amazonaws.services.glue.model.BatchGetPartitionRequest;
import com.amazonaws.services.glue.model.BatchGetPartitionResult;
import com.amazonaws.services.glue.model.CreateDatabaseRequest;
import com.amazonaws.services.glue.model.CreateTableRequest;
import com.amazonaws.services.glue.model.DatabaseInput;
import com.amazonaws.services.glue.model.DeleteDatabaseRequest;
import com.amazonaws.services.glue.model.DeletePartitionRequest;
import com.amazonaws.services.glue.model.DeleteTableRequest;
import com.amazonaws.services.glue.model.EntityNotFoundException;
import com.amazonaws.services.glue.model.ErrorDetail;
import com.amazonaws.services.glue.model.GetDatabaseRequest;
import com.amazonaws.services.glue.model.GetDatabaseResult;
import com.amazonaws.services.glue.model.GetDatabasesRequest;
import com.amazonaws.services.glue.model.GetDatabasesResult;
import com.amazonaws.services.glue.model.GetPartitionRequest;
import com.amazonaws.services.glue.model.GetPartitionResult;
import com.amazonaws.services.glue.model.GetPartitionsRequest;
import com.amazonaws.services.glue.model.GetPartitionsResult;
import com.amazonaws.services.glue.model.GetTableRequest;
import com.amazonaws.services.glue.model.GetTableResult;
import com.amazonaws.services.glue.model.GetTablesRequest;
import com.amazonaws.services.glue.model.GetTablesResult;
import com.amazonaws.services.glue.model.PartitionError;
import com.amazonaws.services.glue.model.PartitionInput;
import com.amazonaws.services.glue.model.PartitionValueList;
import com.amazonaws.services.glue.model.Segment;
import com.amazonaws.services.glue.model.TableInput;
import com.amazonaws.services.glue.model.UpdateDatabaseRequest;
import com.amazonaws.services.glue.model.UpdatePartitionRequest;
import com.amazonaws.services.glue.model.UpdateTableRequest;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Comparators;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import io.airlift.log.Logger;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.PartitionNotFoundException;
import io.prestosql.plugin.hive.PartitionStatistics;
import io.prestosql.plugin.hive.SchemaAlreadyExistsException;
import io.prestosql.plugin.hive.TableAlreadyExistsException;
import io.prestosql.plugin.hive.acid.AcidTransaction;
import io.prestosql.plugin.hive.authentication.HiveIdentity;
import io.prestosql.plugin.hive.aws.AwsCurrentRegionHolder;
import io.prestosql.plugin.hive.metastore.Column;
import io.prestosql.plugin.hive.metastore.Database;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.plugin.hive.metastore.HivePrincipal;
import io.prestosql.plugin.hive.metastore.HivePrivilegeInfo;
import io.prestosql.plugin.hive.metastore.MetastoreUtil;
import io.prestosql.plugin.hive.metastore.Partition;
import io.prestosql.plugin.hive.metastore.PartitionWithStatistics;
import io.prestosql.plugin.hive.metastore.PrincipalPrivileges;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.plugin.hive.metastore.glue.ForGlueHiveMetastore;
import io.prestosql.plugin.hive.metastore.glue.GlueColumnStatisticsProvider;
import io.prestosql.plugin.hive.metastore.glue.GlueExpressionUtil;
import io.prestosql.plugin.hive.metastore.glue.GlueHiveMetastoreConfig;
import io.prestosql.plugin.hive.metastore.glue.GlueMetastoreStats;
import io.prestosql.plugin.hive.metastore.glue.converter.GlueInputConverter;
import io.prestosql.plugin.hive.metastore.glue.converter.GlueToPrestoConverter;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.prestosql.plugin.hive.util.HiveUtil;
import io.prestosql.plugin.hive.util.HiveWriteUtils;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ColumnNotFoundException;
import io.prestosql.spi.connector.SchemaNotFoundException;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.TableNotFoundException;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.security.ConnectorIdentity;
import io.prestosql.spi.security.PrincipalType;
import io.prestosql.spi.security.RoleGrant;
import io.prestosql.spi.statistics.ColumnStatisticType;
import io.prestosql.spi.type.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.TableType;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;

public class GlueHiveMetastore
implements HiveMetastore {
    private static final Logger log = Logger.get(GlueHiveMetastore.class);
    private static final String PUBLIC_ROLE_NAME = "public";
    private static final String DEFAULT_METASTORE_USER = "presto";
    private static final int BATCH_GET_PARTITION_MAX_PAGE_SIZE = 1000;
    private static final int BATCH_CREATE_PARTITION_MAX_PAGE_SIZE = 100;
    private static final int AWS_GLUE_GET_PARTITIONS_MAX_RESULTS = 1000;
    private static final Comparator<Partition> PARTITION_COMPARATOR = Comparator.comparing(Partition::getValues, Comparators.lexicographical((Comparator)String.CASE_INSENSITIVE_ORDER));
    private final HdfsEnvironment hdfsEnvironment;
    private final HdfsEnvironment.HdfsContext hdfsContext;
    private final AWSGlueAsync glueClient;
    private final Optional<String> defaultDir;
    private final String catalogId;
    private final int partitionSegments;
    private final Executor executor;
    private final GlueMetastoreStats stats = new GlueMetastoreStats();
    private final GlueColumnStatisticsProvider columnStatisticsProvider;
    private final boolean assumeCanonicalPartitionKeys;
    private final Predicate<com.amazonaws.services.glue.model.Table> tableFilter;

    @Inject
    public GlueHiveMetastore(HdfsEnvironment hdfsEnvironment, GlueHiveMetastoreConfig glueConfig, GlueColumnStatisticsProvider columnStatisticsProvider, @ForGlueHiveMetastore Executor executor, @ForGlueHiveMetastore Optional<RequestHandler2> requestHandler, @ForGlueHiveMetastore Predicate<com.amazonaws.services.glue.model.Table> tableFilter) {
        Objects.requireNonNull(glueConfig, "glueConfig is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.hdfsContext = new HdfsEnvironment.HdfsContext(ConnectorIdentity.ofUser((String)DEFAULT_METASTORE_USER));
        this.glueClient = GlueHiveMetastore.createAsyncGlueClient(glueConfig, requestHandler, this.stats.newRequestMetricsCollector());
        this.defaultDir = glueConfig.getDefaultWarehouseDir();
        this.catalogId = glueConfig.getCatalogId().orElse(null);
        this.partitionSegments = glueConfig.getPartitionSegments();
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.columnStatisticsProvider = Objects.requireNonNull(columnStatisticsProvider, "columnStatisticsProvider is null");
        this.assumeCanonicalPartitionKeys = glueConfig.isAssumeCanonicalPartitionKeys();
        this.tableFilter = Objects.requireNonNull(tableFilter, "tableFilter is null");
    }

    private static AWSGlueAsync createAsyncGlueClient(GlueHiveMetastoreConfig config, Optional<RequestHandler2> requestHandler, RequestMetricCollector metricsCollector) {
        ClientConfiguration clientConfig = new ClientConfiguration().withMaxConnections(config.getMaxGlueConnections()).withMaxErrorRetry(config.getMaxGlueErrorRetries());
        AWSGlueAsyncClientBuilder asyncGlueClientBuilder = (AWSGlueAsyncClientBuilder)((AWSGlueAsyncClientBuilder)AWSGlueAsyncClientBuilder.standard().withMetricsCollector(metricsCollector)).withClientConfiguration(clientConfig);
        requestHandler.ifPresent(xva$0 -> asyncGlueClientBuilder.setRequestHandlers(new RequestHandler2[]{xva$0}));
        if (config.getGlueEndpointUrl().isPresent()) {
            Preconditions.checkArgument((boolean)config.getGlueRegion().isPresent(), (Object)"Glue region must be set when Glue endpoint URL is set");
            asyncGlueClientBuilder.setEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(config.getGlueEndpointUrl().get(), config.getGlueRegion().get()));
        } else if (config.getGlueRegion().isPresent()) {
            asyncGlueClientBuilder.setRegion(config.getGlueRegion().get());
        } else if (config.getPinGlueClientToCurrentRegion()) {
            asyncGlueClientBuilder.setRegion(AwsCurrentRegionHolder.getCurrentRegionFromEC2Metadata().getName());
        }
        asyncGlueClientBuilder.setCredentials(GlueHiveMetastore.getAwsCredentialsProvider(config));
        return (AWSGlueAsync)asyncGlueClientBuilder.build();
    }

    private static AWSCredentialsProvider getAwsCredentialsProvider(GlueHiveMetastoreConfig config) {
        if (config.getAwsAccessKey().isPresent() && config.getAwsSecretKey().isPresent()) {
            return new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(config.getAwsAccessKey().get(), config.getAwsSecretKey().get()));
        }
        if (config.getIamRole().isPresent()) {
            return new STSAssumeRoleSessionCredentialsProvider.Builder(config.getIamRole().get(), "presto-session").withExternalId((String)config.getExternalId().orElse(null)).build();
        }
        if (config.getAwsCredentialsProvider().isPresent()) {
            return GlueHiveMetastore.getCustomAWSCredentialsProvider(config.getAwsCredentialsProvider().get());
        }
        return DefaultAWSCredentialsProviderChain.getInstance();
    }

    private static AWSCredentialsProvider getCustomAWSCredentialsProvider(String providerClass) {
        try {
            Object instance = Class.forName(providerClass).getConstructor(new Class[0]).newInstance(new Object[0]);
            if (!(instance instanceof AWSCredentialsProvider)) {
                throw new RuntimeException("Invalid credentials provider class: " + instance.getClass().getName());
            }
            return (AWSCredentialsProvider)instance;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(String.format("Error creating an instance of %s", providerClass), e);
        }
    }

    @Managed
    @Flatten
    public GlueMetastoreStats getStats() {
        return this.stats;
    }

    @Override
    public Optional<Database> getDatabase(String databaseName) {
        try {
            GetDatabaseResult result = this.stats.getGetDatabase().call(() -> this.glueClient.getDatabase(new GetDatabaseRequest().withCatalogId(this.catalogId).withName(databaseName)));
            return Optional.of(GlueToPrestoConverter.convertDatabase(result.getDatabase()));
        }
        catch (EntityNotFoundException e) {
            return Optional.empty();
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public List<String> getAllDatabases() {
        try {
            return this.stats.getGetAllDatabases().call(() -> {
                ArrayList databaseNames = new ArrayList();
                String nextToken = null;
                do {
                    GetDatabasesResult result = this.glueClient.getDatabases(new GetDatabasesRequest().withCatalogId(this.catalogId).withNextToken(nextToken));
                    nextToken = result.getNextToken();
                    result.getDatabaseList().forEach(database -> databaseNames.add(database.getName()));
                } while (nextToken != null);
                return databaseNames;
            });
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public Optional<Table> getTable(HiveIdentity identity, String databaseName, String tableName) {
        try {
            GetTableResult result = this.stats.getGetTable().call(() -> this.glueClient.getTable(new GetTableRequest().withCatalogId(this.catalogId).withDatabaseName(databaseName).withName(tableName)));
            return Optional.of(GlueToPrestoConverter.convertTable(result.getTable(), databaseName));
        }
        catch (EntityNotFoundException e) {
            return Optional.empty();
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public Set<ColumnStatisticType> getSupportedColumnStatistics(Type type) {
        return this.columnStatisticsProvider.getSupportedColumnStatistics(type);
    }

    private Table getExistingTable(HiveIdentity identity, String databaseName, String tableName) {
        return this.getTable(identity, databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
    }

    @Override
    public PartitionStatistics getTableStatistics(HiveIdentity identity, Table table) {
        return new PartitionStatistics(ThriftMetastoreUtil.getHiveBasicStatistics(table.getParameters()), this.columnStatisticsProvider.getTableColumnStatistics(table));
    }

    @Override
    public Map<String, PartitionStatistics> getPartitionStatistics(HiveIdentity identity, Table table, List<Partition> partitions) {
        return (Map)partitions.stream().collect(ImmutableMap.toImmutableMap(partition -> MetastoreUtil.makePartitionName(table, partition), this::getPartitionStatistics));
    }

    private PartitionStatistics getPartitionStatistics(Partition partition) {
        return new PartitionStatistics(ThriftMetastoreUtil.getHiveBasicStatistics(partition.getParameters()), this.columnStatisticsProvider.getPartitionColumnStatistics(partition));
    }

    @Override
    public void updateTableStatistics(HiveIdentity identity, String databaseName, String tableName, Function<PartitionStatistics, PartitionStatistics> update, AcidTransaction transaction) {
        Table table = this.getExistingTable(identity, databaseName, tableName);
        if (transaction.isAcidTransactionRunning()) {
            table = Table.builder(table).setWriteId(OptionalLong.of(transaction.getWriteId())).build();
        }
        PartitionStatistics currentStatistics = this.getTableStatistics(identity, table);
        PartitionStatistics updatedStatistics = update.apply(currentStatistics);
        try {
            TableInput tableInput = GlueInputConverter.convertTable(table);
            tableInput.setParameters(ThriftMetastoreUtil.updateStatisticsParameters(table.getParameters(), updatedStatistics.getBasicStatistics()));
            this.columnStatisticsProvider.updateTableColumnStatistics(tableInput, updatedStatistics.getColumnStatistics());
            this.glueClient.updateTable(new UpdateTableRequest().withCatalogId(this.catalogId).withDatabaseName(databaseName).withTableInput(tableInput));
        }
        catch (EntityNotFoundException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void updatePartitionStatistics(HiveIdentity identity, Table table, String partitionName, Function<PartitionStatistics, PartitionStatistics> update) {
        List<String> partitionValues = HiveUtil.toPartitionValues(partitionName);
        Partition partition = this.getPartition(identity, table, partitionValues).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_DROPPED_DURING_QUERY, "Statistics result does not contain entry for partition: " + partitionName));
        PartitionStatistics currentStatistics = this.getPartitionStatistics(partition);
        PartitionStatistics updatedStatistics = update.apply(currentStatistics);
        try {
            PartitionInput partitionInput = GlueInputConverter.convertPartition(partition);
            partitionInput.setParameters(ThriftMetastoreUtil.updateStatisticsParameters(partition.getParameters(), updatedStatistics.getBasicStatistics()));
            this.columnStatisticsProvider.updatePartitionStatistics(partitionInput, updatedStatistics.getColumnStatistics());
            this.glueClient.updatePartition(new UpdatePartitionRequest().withCatalogId(this.catalogId).withDatabaseName(table.getDatabaseName()).withTableName(table.getTableName()).withPartitionValueList(partition.getValues()).withPartitionInput(partitionInput));
        }
        catch (EntityNotFoundException e) {
            throw new PartitionNotFoundException(new SchemaTableName(table.getDatabaseName(), table.getTableName()), partitionValues);
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public List<String> getAllTables(String databaseName) {
        try {
            return this.stats.getGetAllTables().call(() -> {
                GetTablesResult result;
                ArrayList tableNames = new ArrayList();
                String nextToken = null;
                do {
                    result = this.glueClient.getTables(new GetTablesRequest().withCatalogId(this.catalogId).withDatabaseName(databaseName).withNextToken(nextToken));
                    result.getTableList().stream().filter(this.tableFilter).map(com.amazonaws.services.glue.model.Table::getName).forEach(tableNames::add);
                } while ((nextToken = result.getNextToken()) != null);
                return tableNames;
            });
        }
        catch (EntityNotFoundException e) {
            return ImmutableList.of();
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public synchronized List<String> getTablesWithParameter(String databaseName, String parameterKey, String parameterValue) {
        throw new UnsupportedOperationException("getTablesWithParameter for GlueHiveMetastore is not implemented");
    }

    @Override
    public List<String> getAllViews(String databaseName) {
        try {
            return this.stats.getGetAllViews().call(() -> {
                GetTablesResult result;
                ArrayList views = new ArrayList();
                String nextToken = null;
                do {
                    result = this.glueClient.getTables(new GetTablesRequest().withCatalogId(this.catalogId).withDatabaseName(databaseName).withNextToken(nextToken));
                    result.getTableList().stream().filter(table -> TableType.VIRTUAL_VIEW.name().equals(table.getTableType())).forEach(table -> views.add(table.getName()));
                } while ((nextToken = result.getNextToken()) != null);
                return views;
            });
        }
        catch (EntityNotFoundException e) {
            return ImmutableList.of();
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void createDatabase(HiveIdentity identity, Database database) {
        if (database.getLocation().isEmpty() && this.defaultDir.isPresent()) {
            String databaseLocation = new Path(this.defaultDir.get(), database.getDatabaseName()).toString();
            database = Database.builder(database).setLocation(Optional.of(databaseLocation)).build();
        }
        try {
            DatabaseInput databaseInput = GlueInputConverter.convertDatabase(database);
            this.stats.getCreateDatabase().call(() -> this.glueClient.createDatabase(new CreateDatabaseRequest().withCatalogId(this.catalogId).withDatabaseInput(databaseInput)));
        }
        catch (AlreadyExistsException e) {
            throw new SchemaAlreadyExistsException(database.getDatabaseName());
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        if (database.getLocation().isPresent()) {
            HiveWriteUtils.createDirectory(this.hdfsContext, this.hdfsEnvironment, new Path(database.getLocation().get()));
        }
    }

    @Override
    public void dropDatabase(HiveIdentity identity, String databaseName) {
        try {
            this.stats.getDropDatabase().call(() -> this.glueClient.deleteDatabase(new DeleteDatabaseRequest().withCatalogId(this.catalogId).withName(databaseName)));
        }
        catch (EntityNotFoundException e) {
            throw new SchemaNotFoundException(databaseName);
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void renameDatabase(HiveIdentity identity, String databaseName, String newDatabaseName) {
        try {
            Database database = this.getDatabase(databaseName).orElseThrow(() -> new SchemaNotFoundException(databaseName));
            DatabaseInput renamedDatabase = GlueInputConverter.convertDatabase(database).withName(newDatabaseName);
            this.stats.getRenameDatabase().call(() -> this.glueClient.updateDatabase(new UpdateDatabaseRequest().withCatalogId(this.catalogId).withName(databaseName).withDatabaseInput(renamedDatabase)));
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void setDatabaseOwner(HiveIdentity identity, String databaseName, HivePrincipal principal) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "setting the database owner is not supported by Glue");
    }

    @Override
    public void createTable(HiveIdentity identity, Table table, PrincipalPrivileges principalPrivileges) {
        try {
            TableInput input = GlueInputConverter.convertTable(table);
            this.stats.getCreateTable().call(() -> this.glueClient.createTable(new CreateTableRequest().withCatalogId(this.catalogId).withDatabaseName(table.getDatabaseName()).withTableInput(input)));
        }
        catch (AlreadyExistsException e) {
            throw new TableAlreadyExistsException(new SchemaTableName(table.getDatabaseName(), table.getTableName()));
        }
        catch (EntityNotFoundException e) {
            throw new SchemaNotFoundException(table.getDatabaseName());
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void dropTable(HiveIdentity identity, String databaseName, String tableName, boolean deleteData) {
        Table table = this.getExistingTable(identity, databaseName, tableName);
        try {
            this.stats.getDropTable().call(() -> this.glueClient.deleteTable(new DeleteTableRequest().withCatalogId(this.catalogId).withDatabaseName(databaseName).withName(tableName)));
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        String tableLocation = table.getStorage().getLocation();
        if (deleteData && GlueHiveMetastore.isManagedTable(table) && !Strings.isNullOrEmpty((String)tableLocation)) {
            GlueHiveMetastore.deleteDir(this.hdfsContext, this.hdfsEnvironment, new Path(tableLocation), true);
        }
    }

    private static boolean isManagedTable(Table table) {
        return table.getTableType().equals(TableType.MANAGED_TABLE.name());
    }

    private static void deleteDir(HdfsEnvironment.HdfsContext context, HdfsEnvironment hdfsEnvironment, Path path, boolean recursive) {
        try {
            hdfsEnvironment.getFileSystem(context, path).delete(path, recursive);
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Failed to delete path: " + path.toString());
        }
    }

    @Override
    public void replaceTable(HiveIdentity identity, String databaseName, String tableName, Table newTable, PrincipalPrivileges principalPrivileges) {
        try {
            TableInput newTableInput = GlueInputConverter.convertTable(newTable);
            this.stats.getReplaceTable().call(() -> this.glueClient.updateTable(new UpdateTableRequest().withCatalogId(this.catalogId).withDatabaseName(databaseName).withTableInput(newTableInput)));
        }
        catch (EntityNotFoundException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void renameTable(HiveIdentity identity, String databaseName, String tableName, String newDatabaseName, String newTableName) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Table rename is not yet supported by Glue service");
    }

    @Override
    public void commentTable(HiveIdentity identity, String databaseName, String tableName, Optional<String> comment) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Table comment is not yet supported by Glue service");
    }

    @Override
    public void setTableOwner(HiveIdentity identity, String databaseName, String tableName, HivePrincipal principal) {
        if (principal.getType() != PrincipalType.USER) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Setting table owner type as a role is not supported");
        }
        try {
            Table table = this.getExistingTable(identity, databaseName, tableName);
            TableInput newTableInput = GlueInputConverter.convertTable(table);
            newTableInput.setOwner(principal.getName());
            this.stats.getReplaceTable().call(() -> this.glueClient.updateTable(new UpdateTableRequest().withCatalogId(this.catalogId).withDatabaseName(databaseName).withTableInput(newTableInput)));
        }
        catch (EntityNotFoundException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void commentColumn(HiveIdentity identity, String databaseName, String tableName, String columnName, Optional<String> comment) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Column comment is not yet supported by Glue service");
    }

    @Override
    public void addColumn(HiveIdentity identity, String databaseName, String tableName, String columnName, HiveType columnType, String columnComment) {
        Table oldTable = this.getExistingTable(identity, databaseName, tableName);
        Table newTable = Table.builder(oldTable).addDataColumn(new Column(columnName, columnType, Optional.ofNullable(columnComment))).build();
        this.replaceTable(identity, databaseName, tableName, newTable, null);
    }

    @Override
    public void renameColumn(HiveIdentity identity, String databaseName, String tableName, String oldColumnName, String newColumnName) {
        Table oldTable = this.getExistingTable(identity, databaseName, tableName);
        if (oldTable.getPartitionColumns().stream().anyMatch(c -> c.getName().equals(oldColumnName))) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Renaming partition columns is not supported");
        }
        ImmutableList.Builder newDataColumns = ImmutableList.builder();
        for (Column column : oldTable.getDataColumns()) {
            if (column.getName().equals(oldColumnName)) {
                newDataColumns.add((Object)new Column(newColumnName, column.getType(), column.getComment()));
                continue;
            }
            newDataColumns.add((Object)column);
        }
        Table newTable = Table.builder(oldTable).setDataColumns((List<Column>)newDataColumns.build()).build();
        this.replaceTable(identity, databaseName, tableName, newTable, null);
    }

    @Override
    public void dropColumn(HiveIdentity identity, String databaseName, String tableName, String columnName) {
        MetastoreUtil.verifyCanDropColumn(this, identity, databaseName, tableName, columnName);
        Table oldTable = this.getExistingTable(identity, databaseName, tableName);
        if (oldTable.getColumn(columnName).isEmpty()) {
            SchemaTableName name = new SchemaTableName(databaseName, tableName);
            throw new ColumnNotFoundException(name, columnName);
        }
        ImmutableList.Builder newDataColumns = ImmutableList.builder();
        oldTable.getDataColumns().stream().filter(fieldSchema -> !fieldSchema.getName().equals(columnName)).forEach(arg_0 -> ((ImmutableList.Builder)newDataColumns).add(arg_0));
        Table newTable = Table.builder(oldTable).setDataColumns((List<Column>)newDataColumns.build()).build();
        this.replaceTable(identity, databaseName, tableName, newTable, null);
    }

    @Override
    public Optional<Partition> getPartition(HiveIdentity identity, Table table, List<String> partitionValues) {
        try {
            GetPartitionResult result = this.stats.getGetPartition().call(() -> this.glueClient.getPartition(new GetPartitionRequest().withCatalogId(this.catalogId).withDatabaseName(table.getDatabaseName()).withTableName(table.getTableName()).withPartitionValues((Collection)partitionValues)));
            return Optional.of(new GlueToPrestoConverter.GluePartitionConverter(table).apply(result.getPartition()));
        }
        catch (EntityNotFoundException e) {
            return Optional.empty();
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public Optional<List<String>> getPartitionNamesByFilter(HiveIdentity identity, String databaseName, String tableName, List<String> columnNames, TupleDomain<String> partitionKeysFilter) {
        if (partitionKeysFilter.isNone()) {
            return Optional.of(ImmutableList.of());
        }
        if (MetastoreUtil.isPartitionKeyFilterFalse(partitionKeysFilter)) {
            return Optional.of(ImmutableList.of());
        }
        Table table = this.getExistingTable(identity, databaseName, tableName);
        String expression = GlueExpressionUtil.buildGlueExpression(columnNames, partitionKeysFilter, this.assumeCanonicalPartitionKeys);
        List<Partition> partitions = this.getPartitions(table, expression);
        return Optional.of(GlueHiveMetastore.buildPartitionNames(table.getPartitionColumns(), partitions));
    }

    private List<Partition> getPartitions(Table table, String expression) {
        if (this.partitionSegments == 1) {
            return this.getPartitions(table, expression, null);
        }
        ExecutorCompletionService<List> completionService = new ExecutorCompletionService<List>(this.executor);
        for (int i = 0; i < this.partitionSegments; ++i) {
            Segment segment = new Segment().withSegmentNumber(Integer.valueOf(i)).withTotalSegments(Integer.valueOf(this.partitionSegments));
            completionService.submit(() -> this.getPartitions(table, expression, segment));
        }
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        try {
            for (int i = 0; i < this.partitionSegments; ++i) {
                Future futurePartitions = completionService.take();
                partitions.addAll((Collection)futurePartitions.get());
            }
        }
        catch (InterruptedException | ExecutionException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Failed to fetch partitions from Glue Data Catalog", (Throwable)e);
        }
        partitions.sort(PARTITION_COMPARATOR);
        return partitions;
    }

    private List<Partition> getPartitions(Table table, String expression, @Nullable Segment segment) {
        try {
            return this.stats.getGetPartitions().call(() -> {
                GetPartitionsResult result;
                ArrayList partitions = new ArrayList();
                String nextToken = null;
                GlueToPrestoConverter.GluePartitionConverter converter = new GlueToPrestoConverter.GluePartitionConverter(table);
                do {
                    result = this.glueClient.getPartitions(new GetPartitionsRequest().withCatalogId(this.catalogId).withDatabaseName(table.getDatabaseName()).withTableName(table.getTableName()).withExpression(expression).withSegment(segment).withNextToken(nextToken).withMaxResults(Integer.valueOf(1000)));
                    result.getPartitions().stream().map(converter).forEach(partitions::add);
                } while ((nextToken = result.getNextToken()) != null);
                return partitions;
            });
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    private static List<String> buildPartitionNames(List<Column> partitionColumns, List<Partition> partitions) {
        return GlueToPrestoConverter.mappedCopy(partitions, partition -> MetastoreUtil.makePartitionName(partitionColumns, partition.getValues()));
    }

    @Override
    public Map<String, Optional<Partition>> getPartitionsByNames(HiveIdentity identity, Table table, List<String> partitionNames) {
        return this.stats.getGetPartitionByName().call(() -> this.getPartitionsByNames(table, partitionNames));
    }

    private Map<String, Optional<Partition>> getPartitionsByNames(Table table, List<String> partitionNames) {
        Objects.requireNonNull(partitionNames, "partitionNames is null");
        if (partitionNames.isEmpty()) {
            return ImmutableMap.of();
        }
        List<Partition> partitions = this.batchGetPartition(table, partitionNames);
        Map partitionNameToPartitionValuesMap = partitionNames.stream().collect(Collectors.toMap(UnaryOperator.identity(), HiveUtil::toPartitionValues));
        Map partitionValuesToPartitionMap = partitions.stream().collect(Collectors.toMap(Partition::getValues, UnaryOperator.identity()));
        ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
        for (Map.Entry entry : partitionNameToPartitionValuesMap.entrySet()) {
            Partition partition = (Partition)partitionValuesToPartitionMap.get(entry.getValue());
            resultBuilder.put((Object)((String)entry.getKey()), Optional.ofNullable(partition));
        }
        return resultBuilder.build();
    }

    private List<Partition> batchGetPartition(Table table, List<String> partitionNames) {
        try {
            ArrayList<Future> batchGetPartitionFutures = new ArrayList<Future>();
            for (List partitionNamesBatch : Lists.partition(partitionNames, (int)1000)) {
                List<PartitionValueList> partitionValuesBatch = GlueToPrestoConverter.mappedCopy(partitionNamesBatch, partitionName -> new PartitionValueList().withValues(HiveUtil.toPartitionValues(partitionName)));
                batchGetPartitionFutures.add(this.glueClient.batchGetPartitionAsync(new BatchGetPartitionRequest().withCatalogId(this.catalogId).withDatabaseName(table.getDatabaseName()).withTableName(table.getTableName()).withPartitionsToGet(partitionValuesBatch)));
            }
            GlueToPrestoConverter.GluePartitionConverter converter = new GlueToPrestoConverter.GluePartitionConverter(table);
            ImmutableList.Builder resultsBuilder = ImmutableList.builderWithExpectedSize((int)partitionNames.size());
            for (Future future : batchGetPartitionFutures) {
                ((BatchGetPartitionResult)future.get()).getPartitions().stream().map(converter).forEach(arg_0 -> ((ImmutableList.Builder)resultsBuilder).add(arg_0));
            }
            return resultsBuilder.build();
        }
        catch (AmazonServiceException | InterruptedException | ExecutionException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, e);
        }
    }

    @Override
    public void addPartitions(HiveIdentity identity, String databaseName, String tableName, List<PartitionWithStatistics> partitions) {
        try {
            this.stats.getAddPartitions().call(() -> {
                ArrayList<Future> futures = new ArrayList<Future>();
                for (List partitionBatch : Lists.partition((List)partitions, (int)100)) {
                    List<PartitionInput> partitionInputs = GlueToPrestoConverter.mappedCopy(partitionBatch, partition -> GlueInputConverter.convertPartition(partition, this.columnStatisticsProvider));
                    futures.add(this.glueClient.batchCreatePartitionAsync(new BatchCreatePartitionRequest().withCatalogId(this.catalogId).withDatabaseName(databaseName).withTableName(tableName).withPartitionInputList(partitionInputs)));
                }
                for (Future future : futures) {
                    try {
                        BatchCreatePartitionResult result = (BatchCreatePartitionResult)future.get();
                        GlueHiveMetastore.propagatePartitionErrorToPrestoException(databaseName, tableName, result.getErrors());
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
                    }
                }
                return null;
            });
        }
        catch (AmazonServiceException | ExecutionException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, e);
        }
    }

    private static void propagatePartitionErrorToPrestoException(String databaseName, String tableName, List<PartitionError> partitionErrors) {
        if (partitionErrors != null && !partitionErrors.isEmpty()) {
            String glueExceptionCode;
            ErrorDetail errorDetail = partitionErrors.get(0).getErrorDetail();
            switch (glueExceptionCode = errorDetail.getErrorCode()) {
                case "AlreadyExistsException": {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, errorDetail.getErrorMessage());
                }
                case "EntityNotFoundException": {
                    throw new TableNotFoundException(new SchemaTableName(databaseName, tableName), errorDetail.getErrorMessage());
                }
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, errorDetail.getErrorCode() + ": " + errorDetail.getErrorMessage());
        }
    }

    @Override
    public void dropPartition(HiveIdentity identity, String databaseName, String tableName, List<String> parts, boolean deleteData) {
        Table table = this.getExistingTable(identity, databaseName, tableName);
        Partition partition = this.getPartition(identity, table, parts).orElseThrow(() -> new PartitionNotFoundException(new SchemaTableName(databaseName, tableName), parts));
        try {
            this.stats.getDropPartition().call(() -> this.glueClient.deletePartition(new DeletePartitionRequest().withCatalogId(this.catalogId).withDatabaseName(databaseName).withTableName(tableName).withPartitionValues((Collection)parts)));
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        String partLocation = partition.getStorage().getLocation();
        if (deleteData && GlueHiveMetastore.isManagedTable(table) && !Strings.isNullOrEmpty((String)partLocation)) {
            GlueHiveMetastore.deleteDir(this.hdfsContext, this.hdfsEnvironment, new Path(partLocation), true);
        }
    }

    @Override
    public void alterPartition(HiveIdentity identity, String databaseName, String tableName, PartitionWithStatistics partition) {
        try {
            PartitionInput newPartition = GlueInputConverter.convertPartition(partition, this.columnStatisticsProvider);
            this.stats.getAlterPartition().call(() -> this.glueClient.updatePartition(new UpdatePartitionRequest().withCatalogId(this.catalogId).withDatabaseName(databaseName).withTableName(tableName).withPartitionInput(newPartition).withPartitionValueList(partition.getPartition().getValues())));
        }
        catch (EntityNotFoundException e) {
            throw new PartitionNotFoundException(new SchemaTableName(databaseName, tableName), partition.getPartition().getValues());
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void createRole(String role, String grantor) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "createRole is not supported by Glue");
    }

    @Override
    public void dropRole(String role) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "dropRole is not supported by Glue");
    }

    @Override
    public Set<String> listRoles() {
        return ImmutableSet.of((Object)PUBLIC_ROLE_NAME);
    }

    @Override
    public void grantRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "grantRoles is not supported by Glue");
    }

    @Override
    public void revokeRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "revokeRoles is not supported by Glue");
    }

    @Override
    public Set<RoleGrant> listGrantedPrincipals(String role) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "listPrincipals is not supported by Glue");
    }

    @Override
    public Set<RoleGrant> listRoleGrants(HivePrincipal principal) {
        if (principal.getType() == PrincipalType.USER) {
            return ImmutableSet.of((Object)new RoleGrant(principal.toPrestoPrincipal(), PUBLIC_ROLE_NAME, false));
        }
        return ImmutableSet.of();
    }

    @Override
    public void grantTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, Set<HivePrivilegeInfo> privileges) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "grantTablePrivileges is not supported by Glue");
    }

    @Override
    public void revokeTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, Set<HivePrivilegeInfo> privileges) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "revokeTablePrivileges is not supported by Glue");
    }

    @Override
    public Set<HivePrivilegeInfo> listTablePrivileges(String databaseName, String tableName, String tableOwner, Optional<HivePrincipal> principal) {
        return ImmutableSet.of();
    }

    @Override
    public boolean isImpersonationEnabled() {
        return false;
    }
}

