/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore.thrift;

import io.prestosql.plugin.hive.acid.AcidOperation;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.RolePrincipalGrant;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TxnToWriteId;
import org.apache.thrift.TException;

public interface ThriftMetastoreClient
extends Closeable {
    @Override
    public void close();

    public List<String> getAllDatabases() throws TException;

    public Database getDatabase(String var1) throws TException;

    public List<String> getAllTables(String var1) throws TException;

    public List<String> getTableNamesByFilter(String var1, String var2) throws TException;

    public List<String> getTableNamesByType(String var1, String var2) throws TException;

    public void createDatabase(Database var1) throws TException;

    public void dropDatabase(String var1, boolean var2, boolean var3) throws TException;

    public void alterDatabase(String var1, Database var2) throws TException;

    public void createTable(Table var1) throws TException;

    public void dropTable(String var1, String var2, boolean var3) throws TException;

    public void alterTableWithEnvironmentContext(String var1, String var2, Table var3, EnvironmentContext var4) throws TException;

    public Table getTable(String var1, String var2) throws TException;

    public Table getTableWithCapabilities(String var1, String var2) throws TException;

    public List<FieldSchema> getFields(String var1, String var2) throws TException;

    public List<ColumnStatisticsObj> getTableColumnStatistics(String var1, String var2, List<String> var3) throws TException;

    public void setTableColumnStatistics(String var1, String var2, List<ColumnStatisticsObj> var3) throws TException;

    public void deleteTableColumnStatistics(String var1, String var2, String var3) throws TException;

    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String var1, String var2, List<String> var3, List<String> var4) throws TException;

    public void setPartitionColumnStatistics(String var1, String var2, String var3, List<ColumnStatisticsObj> var4) throws TException;

    public void deletePartitionColumnStatistics(String var1, String var2, String var3, String var4) throws TException;

    public List<String> getPartitionNames(String var1, String var2) throws TException;

    public List<String> getPartitionNamesFiltered(String var1, String var2, List<String> var3) throws TException;

    public int addPartitions(List<Partition> var1) throws TException;

    public boolean dropPartition(String var1, String var2, List<String> var3, boolean var4) throws TException;

    public void alterPartition(String var1, String var2, Partition var3) throws TException;

    public Partition getPartition(String var1, String var2, List<String> var3) throws TException;

    public List<Partition> getPartitionsByNames(String var1, String var2, List<String> var3) throws TException;

    public List<Role> listRoles(String var1, PrincipalType var2) throws TException;

    public List<HiveObjectPrivilege> listPrivileges(String var1, PrincipalType var2, HiveObjectRef var3) throws TException;

    public List<String> getRoleNames() throws TException;

    public void createRole(String var1, String var2) throws TException;

    public void dropRole(String var1) throws TException;

    public boolean grantPrivileges(PrivilegeBag var1) throws TException;

    public boolean revokePrivileges(PrivilegeBag var1) throws TException;

    public void grantRole(String var1, String var2, PrincipalType var3, String var4, PrincipalType var5, boolean var6) throws TException;

    public void revokeRole(String var1, String var2, PrincipalType var3, boolean var4) throws TException;

    public List<RolePrincipalGrant> listGrantedPrincipals(String var1) throws TException;

    public List<RolePrincipalGrant> listRoleGrants(String var1, PrincipalType var2) throws TException;

    public void setUGI(String var1) throws TException;

    public long openTransaction(String var1) throws TException;

    public void commitTransaction(long var1) throws TException;

    default public void abortTransaction(long transactionId) throws TException {
        throw new UnsupportedOperationException();
    }

    public void sendTransactionHeartbeat(long var1) throws TException;

    public LockResponse acquireLock(LockRequest var1) throws TException;

    public LockResponse checkLock(long var1) throws TException;

    public String getValidWriteIds(List<String> var1, long var2) throws TException;

    public String get_config_value(String var1, String var2) throws TException;

    public String getDelegationToken(String var1) throws TException;

    default public List<TxnToWriteId> allocateTableWriteIds(String database, String tableName, List<Long> transactionIds) throws TException {
        throw new UnsupportedOperationException();
    }

    public void updateTableWriteId(String var1, String var2, long var3, long var5, OptionalLong var7) throws TException;

    public void alterPartitions(String var1, String var2, List<Partition> var3, long var4) throws TException;

    public void addDynamicPartitions(String var1, String var2, List<String> var3, long var4, long var6, AcidOperation var8) throws TException;

    public void alterTransactionalTable(Table var1, long var2, long var4, EnvironmentContext var6) throws TException;
}

