/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.orc;

import io.airlift.slice.Slice;
import io.prestosql.orc.AbstractOrcDataSource;
import io.prestosql.orc.OrcDataSourceId;
import io.prestosql.orc.OrcReaderOptions;
import io.prestosql.plugin.hive.FileFormatDataSourceStats;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.util.FSDataInputStreamTail;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.hdfs.BlockMissingException;

public class HdfsOrcDataSource
extends AbstractOrcDataSource {
    private final FSDataInputStream inputStream;
    private final FileFormatDataSourceStats stats;

    public HdfsOrcDataSource(OrcDataSourceId id, long size, OrcReaderOptions options, FSDataInputStream inputStream, FileFormatDataSourceStats stats) {
        super(id, size, options);
        this.inputStream = Objects.requireNonNull(inputStream, "inputStream is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
    }

    public void close() throws IOException {
        this.inputStream.close();
    }

    public Slice readTail(int length) throws IOException {
        long readStart = System.nanoTime();
        FSDataInputStreamTail fileTail = FSDataInputStreamTail.readTail(this.getId().toString(), this.getEstimatedSize(), this.inputStream, length);
        Slice tailSlice = fileTail.getTailSlice();
        this.stats.readDataBytesPerSecond(tailSlice.length(), System.nanoTime() - readStart);
        return tailSlice;
    }

    protected void readInternal(long position, byte[] buffer, int bufferOffset, int bufferLength) {
        try {
            long readStart = System.nanoTime();
            this.inputStream.readFully(position, buffer, bufferOffset, bufferLength);
            this.stats.readDataBytesPerSecond(bufferLength, System.nanoTime() - readStart);
        }
        catch (PrestoException e) {
            throw e;
        }
        catch (Exception e) {
            String message = String.format("Error reading from %s at position %s", new Object[]{this, position});
            if (e instanceof BlockMissingException) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_MISSING_DATA, message, (Throwable)e);
            }
            if (e instanceof IOException) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, message, (Throwable)e);
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNKNOWN_ERROR, message, (Throwable)e);
        }
    }
}

