/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.orc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import io.prestosql.orc.OrcCorruptionException;
import io.prestosql.plugin.hive.AcidInfo;
import io.prestosql.plugin.hive.BackgroundHiveSplitLoader;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.orc.OrcDeleteDeltaPageSourceFactory;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.Page;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.DictionaryBlock;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.EmptyPageSource;
import io.prestosql.spi.type.BigintType;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.AcidUtils;

@NotThreadSafe
public class OrcDeletedRows {
    private static final int ORIGINAL_TRANSACTION_INDEX = 0;
    private static final int ROW_ID_INDEX = 1;
    private final String sourceFileName;
    private final OrcDeleteDeltaPageSourceFactory pageSourceFactory;
    private final String sessionUser;
    private final Configuration configuration;
    private final HdfsEnvironment hdfsEnvironment;
    private final AcidInfo acidInfo;
    @Nullable
    private Set<RowId> deletedRows;

    public OrcDeletedRows(String sourceFileName, OrcDeleteDeltaPageSourceFactory pageSourceFactory, String sessionUser, Configuration configuration, HdfsEnvironment hdfsEnvironment, AcidInfo acidInfo) {
        this.sourceFileName = Objects.requireNonNull(sourceFileName, "sourceFileName is null");
        this.pageSourceFactory = Objects.requireNonNull(pageSourceFactory, "pageSourceFactory is null");
        this.sessionUser = Objects.requireNonNull(sessionUser, "sessionUser is null");
        this.configuration = Objects.requireNonNull(configuration, "configuration is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.acidInfo = Objects.requireNonNull(acidInfo, "acidInfo is null");
    }

    public MaskDeletedRowsFunction getMaskDeletedRowsFunction(Page sourcePage, OptionalLong startRowId) {
        return new MaskDeletedRows(sourcePage, startRowId);
    }

    private Set<RowId> getDeletedRows() {
        if (this.deletedRows != null) {
            return this.deletedRows;
        }
        ImmutableSet.Builder deletedRowsBuilder = ImmutableSet.builder();
        for (AcidInfo.DeleteDeltaInfo deleteDeltaInfo : this.acidInfo.getDeleteDeltas()) {
            Path path = OrcDeletedRows.createPath(this.acidInfo, deleteDeltaInfo, this.sourceFileName);
            try {
                FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(this.sessionUser, path, this.configuration);
                FileStatus fileStatus = this.hdfsEnvironment.doAs(this.sessionUser, () -> fileSystem.getFileStatus(path));
                ConnectorPageSource pageSource = this.pageSourceFactory.createPageSource(fileStatus.getPath(), fileStatus.getLen()).orElseGet(() -> new EmptyPageSource());
                try {
                    while (!pageSource.isFinished()) {
                        Page page = pageSource.getNextPage();
                        if (page == null) continue;
                        for (int i = 0; i < page.getPositionCount(); ++i) {
                            long originalTransaction = BigintType.BIGINT.getLong(page.getBlock(0), i);
                            long row = BigintType.BIGINT.getLong(page.getBlock(1), i);
                            deletedRowsBuilder.add((Object)new RowId(originalTransaction, row));
                        }
                    }
                }
                finally {
                    if (pageSource == null) continue;
                    pageSource.close();
                }
            }
            catch (FileNotFoundException fileSystem) {
            }
            catch (PrestoException e) {
                throw e;
            }
            catch (OrcCorruptionException e) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, "Failed to read ORC delete delta file: " + path, (Throwable)e);
            }
            catch (IOException | RuntimeException e) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, "Failed to read ORC delete delta file: " + path, (Throwable)e);
            }
        }
        this.deletedRows = deletedRowsBuilder.build();
        return this.deletedRows;
    }

    private static Path createPath(AcidInfo acidInfo, AcidInfo.DeleteDeltaInfo deleteDeltaInfo, String fileName) {
        Path directory = new Path(acidInfo.getPartitionLocation(), deleteDeltaInfo.getDirectoryName());
        if (BackgroundHiveSplitLoader.hasAttemptId(fileName)) {
            return new Path(directory, fileName.substring(0, fileName.lastIndexOf("_")));
        }
        if (acidInfo.getOriginalFiles().size() > 0) {
            return AcidUtils.createBucketFile((Path)directory, (int)acidInfo.getBucketId());
        }
        return new Path(directory, fileName);
    }

    private static class RowId {
        private final long originalTransaction;
        private final long rowId;

        public RowId(long originalTransaction, long rowId) {
            this.originalTransaction = originalTransaction;
            this.rowId = rowId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RowId other = (RowId)o;
            return this.originalTransaction == other.originalTransaction && this.rowId == other.rowId;
        }

        public int hashCode() {
            return Objects.hash(this.originalTransaction, this.rowId);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("originalTransaction", this.originalTransaction).add("rowId", this.rowId).toString();
        }
    }

    @NotThreadSafe
    private class MaskDeletedRows
    implements MaskDeletedRowsFunction {
        @Nullable
        private Page sourcePage;
        private int positionCount;
        @Nullable
        private int[] validPositions;
        private final OptionalLong startRowId;

        public MaskDeletedRows(Page sourcePage, OptionalLong startRowId) {
            this.sourcePage = Objects.requireNonNull(sourcePage, "sourcePage is null");
            this.startRowId = Objects.requireNonNull(startRowId, "startRowId is null");
        }

        @Override
        public int getPositionCount() {
            if (this.sourcePage != null) {
                this.loadValidPositions();
                Verify.verify((this.sourcePage == null ? 1 : 0) != 0);
            }
            return this.positionCount;
        }

        @Override
        public Block apply(Block block) {
            if (this.sourcePage != null) {
                this.loadValidPositions();
                Verify.verify((this.sourcePage == null ? 1 : 0) != 0);
            }
            if (this.positionCount == block.getPositionCount()) {
                return block;
            }
            return new DictionaryBlock(this.positionCount, block, this.validPositions);
        }

        private void loadValidPositions() {
            Verify.verify((this.sourcePage != null ? 1 : 0) != 0, (String)"sourcePage is null", (Object[])new Object[0]);
            Set<RowId> deletedRows = OrcDeletedRows.this.getDeletedRows();
            if (deletedRows.isEmpty()) {
                this.positionCount = this.sourcePage.getPositionCount();
                this.sourcePage = null;
                return;
            }
            int[] validPositions = new int[this.sourcePage.getPositionCount()];
            int validPositionsIndex = 0;
            for (int position = 0; position < this.sourcePage.getPositionCount(); ++position) {
                RowId rowId = this.getRowId(position);
                if (deletedRows.contains(rowId)) continue;
                validPositions[validPositionsIndex] = position;
                ++validPositionsIndex;
            }
            this.positionCount = validPositionsIndex;
            this.validPositions = validPositions;
            this.sourcePage = null;
        }

        private RowId getRowId(int position) {
            long row;
            long originalTransaction;
            if (this.startRowId.isPresent()) {
                originalTransaction = 0L;
                row = this.startRowId.getAsLong() + (long)position;
            } else {
                originalTransaction = BigintType.BIGINT.getLong(this.sourcePage.getBlock(0), position);
                row = BigintType.BIGINT.getLong(this.sourcePage.getBlock(1), position);
            }
            return new RowId(originalTransaction, row);
        }
    }

    public static interface MaskDeletedRowsFunction {
        public int getPositionCount();

        public Block apply(Block var1);

        public static MaskDeletedRowsFunction noMaskForPage(final Page page) {
            return new MaskDeletedRowsFunction(){
                int positionCount;
                {
                    this.positionCount = page.getPositionCount();
                }

                @Override
                public int getPositionCount() {
                    return this.positionCount;
                }

                @Override
                public Block apply(Block block) {
                    return block;
                }
            };
        }
    }
}

