/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.orc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.orc.OrcCorruptionException;
import io.prestosql.orc.OrcDataSource;
import io.prestosql.orc.OrcDataSourceId;
import io.prestosql.orc.OrcRecordReader;
import io.prestosql.orc.metadata.ColumnMetadata;
import io.prestosql.orc.metadata.OrcType;
import io.prestosql.plugin.hive.FileFormatDataSourceStats;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.orc.OrcDeletedRows;
import io.prestosql.plugin.hive.orc.OrcFileWriter;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.Page;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.LazyBlock;
import io.prestosql.spi.block.LazyBlockLoader;
import io.prestosql.spi.block.LongArrayBlock;
import io.prestosql.spi.block.RowBlock;
import io.prestosql.spi.block.RunLengthEncodedBlock;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.predicate.Utils;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.Type;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;

public class OrcPageSource
implements ConnectorPageSource {
    private static final Block ORIGINAL_FILE_TRANSACTION_ID_BLOCK = Utils.nativeValueToBlock((Type)BigintType.BIGINT, (Object)0L);
    private final OrcRecordReader recordReader;
    private final List<ColumnAdaptation> columnAdaptations;
    private final OrcDataSource orcDataSource;
    private final Optional<OrcDeletedRows> deletedRows;
    private boolean closed;
    private final AggregatedMemoryContext systemMemoryContext;
    private final FileFormatDataSourceStats stats;
    private Optional<Long> originalFileRowId = Optional.empty();

    public OrcPageSource(OrcRecordReader recordReader, List<ColumnAdaptation> columnAdaptations, OrcDataSource orcDataSource, Optional<OrcDeletedRows> deletedRows, Optional<Long> originalFileRowId, AggregatedMemoryContext systemMemoryContext, FileFormatDataSourceStats stats) {
        this.recordReader = Objects.requireNonNull(recordReader, "recordReader is null");
        this.columnAdaptations = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnAdaptations, "columnAdaptations is null"));
        this.orcDataSource = Objects.requireNonNull(orcDataSource, "orcDataSource is null");
        this.deletedRows = Objects.requireNonNull(deletedRows, "deletedRows is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
        this.originalFileRowId = Objects.requireNonNull(originalFileRowId, "originalFileRowId is null");
    }

    public long getCompletedBytes() {
        return this.orcDataSource.getReadBytes();
    }

    public long getReadTimeNanos() {
        return this.orcDataSource.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.closed;
    }

    public ColumnMetadata<OrcType> getColumnTypes() {
        return this.recordReader.getColumnTypes();
    }

    public Page getNextPage() {
        Page page;
        try {
            page = this.recordReader.nextPage();
        }
        catch (IOException | RuntimeException e) {
            this.closeWithSuppression(e);
            throw OrcPageSource.handleException(this.orcDataSource.getId(), e);
        }
        if (page == null) {
            this.close();
            return null;
        }
        OptionalLong startRowId = this.originalFileRowId.isPresent() ? OptionalLong.of(this.originalFileRowId.get() + this.recordReader.getFilePosition()) : OptionalLong.empty();
        OrcDeletedRows.MaskDeletedRowsFunction maskDeletedRowsFunction = this.deletedRows.map(deletedRows -> deletedRows.getMaskDeletedRowsFunction(page, startRowId)).orElseGet(() -> OrcDeletedRows.MaskDeletedRowsFunction.noMaskForPage(page));
        Block[] blocks = new Block[this.columnAdaptations.size()];
        for (int i = 0; i < this.columnAdaptations.size(); ++i) {
            blocks[i] = this.columnAdaptations.get(i).block(page, maskDeletedRowsFunction, this.recordReader.getFilePosition());
        }
        return new Page(maskDeletedRowsFunction.getPositionCount(), blocks);
    }

    static PrestoException handleException(OrcDataSourceId dataSourceId, Exception exception) {
        if (exception instanceof PrestoException) {
            return (PrestoException)((Object)exception);
        }
        if (exception instanceof OrcCorruptionException) {
            return new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, (Throwable)exception);
        }
        return new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, String.format("Failed to read ORC file: %s", dataSourceId), (Throwable)exception);
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.stats.addMaxCombinedBytesPerRow(this.recordReader.getMaxCombinedBytesPerRow());
            this.recordReader.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("orcDataSource", (Object)this.orcDataSource.getId()).add("columns", this.columnAdaptations).toString();
    }

    public long getSystemMemoryUsage() {
        return this.systemMemoryContext.getBytes();
    }

    private void closeWithSuppression(Throwable throwable) {
        block2: {
            Objects.requireNonNull(throwable, "throwable is null");
            try {
                this.close();
            }
            catch (RuntimeException e) {
                if (throwable == e) break block2;
                throwable.addSuppressed(e);
            }
        }
    }

    private static class OriginalFileRowIdAdaptation
    implements ColumnAdaptation {
        private final long startingRowId;
        private final Block bucketBlock;

        public OriginalFileRowIdAdaptation(long startingRowId, int bucketId) {
            this.startingRowId = startingRowId;
            this.bucketBlock = Utils.nativeValueToBlock((Type)IntegerType.INTEGER, (Object)OrcFileWriter.computeBucketValue(bucketId, 0));
        }

        @Override
        public Block block(Page sourcePage, OrcDeletedRows.MaskDeletedRowsFunction maskDeletedRowsFunction, long filePosition) {
            int positionCount = sourcePage.getPositionCount();
            Block rowBlock = maskDeletedRowsFunction.apply(RowBlock.fromFieldBlocks((int)positionCount, Optional.empty(), (Block[])new Block[]{new RunLengthEncodedBlock(ORIGINAL_FILE_TRANSACTION_ID_BLOCK, positionCount), this.createRowIdBlock(filePosition, positionCount), new RunLengthEncodedBlock(this.bucketBlock, positionCount)}));
            return rowBlock;
        }

        private Block createRowIdBlock(long filePosition, int positionCount) {
            long[] translatedRowIds = new long[positionCount];
            for (int index = 0; index < positionCount; ++index) {
                translatedRowIds[index] = filePosition + this.startingRowId + (long)index;
            }
            return new LongArrayBlock(positionCount, Optional.empty(), translatedRowIds);
        }
    }

    private static class RowIdAdaptation
    implements ColumnAdaptation {
        private RowIdAdaptation() {
        }

        @Override
        public Block block(Page sourcePage, OrcDeletedRows.MaskDeletedRowsFunction maskDeletedRowsFunction, long filePosition) {
            Block rowBlock = maskDeletedRowsFunction.apply(RowBlock.fromFieldBlocks((int)sourcePage.getPositionCount(), Optional.empty(), (Block[])new Block[]{sourcePage.getBlock(0), sourcePage.getBlock(1), sourcePage.getBlock(2)}));
            return rowBlock;
        }
    }

    private static class SourceColumn
    implements ColumnAdaptation {
        private final int index;

        public SourceColumn(int index) {
            Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0, (Object)"index is negative");
            this.index = index;
        }

        @Override
        public Block block(Page sourcePage, OrcDeletedRows.MaskDeletedRowsFunction maskDeletedRowsFunction, long filePosition) {
            Block block = sourcePage.getBlock(this.index);
            return new LazyBlock(maskDeletedRowsFunction.getPositionCount(), (LazyBlockLoader)new MaskingBlockLoader(maskDeletedRowsFunction, block));
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("index", this.index).toString();
        }

        private static final class MaskingBlockLoader
        implements LazyBlockLoader {
            private OrcDeletedRows.MaskDeletedRowsFunction maskDeletedRowsFunction;
            private Block sourceBlock;

            public MaskingBlockLoader(OrcDeletedRows.MaskDeletedRowsFunction maskDeletedRowsFunction, Block sourceBlock) {
                this.maskDeletedRowsFunction = Objects.requireNonNull(maskDeletedRowsFunction, "maskDeletedRowsFunction is null");
                this.sourceBlock = Objects.requireNonNull(sourceBlock, "sourceBlock is null");
            }

            public Block load() {
                Preconditions.checkState((this.maskDeletedRowsFunction != null ? 1 : 0) != 0, (Object)"Already loaded");
                Block resultBlock = this.maskDeletedRowsFunction.apply(this.sourceBlock.getLoadedBlock());
                this.maskDeletedRowsFunction = null;
                this.sourceBlock = null;
                return resultBlock;
            }
        }
    }

    private static class NullColumn
    implements ColumnAdaptation {
        private final Type type;
        private final Block nullBlock;

        public NullColumn(Type type) {
            this.type = Objects.requireNonNull(type, "type is null");
            this.nullBlock = type.createBlockBuilder(null, 1, 0).appendNull().build();
        }

        @Override
        public Block block(Page sourcePage, OrcDeletedRows.MaskDeletedRowsFunction maskDeletedRowsFunction, long filePosition) {
            return new RunLengthEncodedBlock(this.nullBlock, maskDeletedRowsFunction.getPositionCount());
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).toString();
        }
    }

    public static interface ColumnAdaptation {
        public Block block(Page var1, OrcDeletedRows.MaskDeletedRowsFunction var2, long var3);

        public static ColumnAdaptation nullColumn(Type type) {
            return new NullColumn(type);
        }

        public static ColumnAdaptation sourceColumn(int index) {
            return new SourceColumn(index);
        }

        public static ColumnAdaptation rowIdColumn() {
            return new RowIdAdaptation();
        }

        public static ColumnAdaptation originalFileRowIdColumn(long startingRowId, int bucketId) {
            return new OriginalFileRowIdAdaptation(startingRowId, bucketId);
        }
    }
}

