/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.orc;

import com.google.common.base.Preconditions;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import io.prestosql.orc.metadata.ColumnMetadata;
import io.prestosql.orc.metadata.OrcType;
import io.prestosql.plugin.hive.HiveType;
import java.util.List;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public final class OrcTypeToHiveTypeTranslator {
    private OrcTypeToHiveTypeTranslator() {
    }

    public static HiveType fromOrcTypeToHiveType(OrcType orcType, ColumnMetadata<OrcType> columnMetadata) {
        switch (orcType.getOrcTypeKind()) {
            case BOOLEAN: {
                return HiveType.HIVE_BOOLEAN;
            }
            case FLOAT: {
                return HiveType.HIVE_FLOAT;
            }
            case DOUBLE: {
                return HiveType.HIVE_DOUBLE;
            }
            case BYTE: {
                return HiveType.HIVE_BYTE;
            }
            case DATE: {
                return HiveType.HIVE_DATE;
            }
            case SHORT: {
                return HiveType.HIVE_SHORT;
            }
            case INT: {
                return HiveType.HIVE_INT;
            }
            case LONG: {
                return HiveType.HIVE_LONG;
            }
            case DECIMAL: {
                Preconditions.checkArgument((boolean)orcType.getPrecision().isPresent(), (Object)"orcType.getPrecision() is not present");
                Preconditions.checkArgument((boolean)orcType.getScale().isPresent(), (Object)"orcType.getScale() is not present");
                return HiveType.toHiveType((TypeInfo)new DecimalTypeInfo(((Integer)orcType.getPrecision().get()).intValue(), ((Integer)orcType.getScale().get()).intValue()));
            }
            case TIMESTAMP: {
                return HiveType.HIVE_TIMESTAMP;
            }
            case BINARY: {
                return HiveType.HIVE_BINARY;
            }
            case CHAR: 
            case VARCHAR: 
            case STRING: {
                return HiveType.HIVE_STRING;
            }
            case LIST: {
                HiveType elementType = OrcTypeToHiveTypeTranslator.fromOrcTypeToHiveType((OrcType)columnMetadata.get(orcType.getFieldTypeIndex(0)), columnMetadata);
                return HiveType.toHiveType(TypeInfoFactory.getListTypeInfo((TypeInfo)elementType.getTypeInfo()));
            }
            case MAP: {
                HiveType keyType = OrcTypeToHiveTypeTranslator.getHiveType(orcType, 0, columnMetadata);
                HiveType elementType = OrcTypeToHiveTypeTranslator.getHiveType(orcType, 1, columnMetadata);
                return HiveType.toHiveType(TypeInfoFactory.getMapTypeInfo((TypeInfo)keyType.getTypeInfo(), (TypeInfo)elementType.getTypeInfo()));
            }
            case STRUCT: {
                ImmutableList.Builder fieldTypeInfo = ImmutableList.builder();
                for (int fieldId = 0; fieldId < orcType.getFieldCount(); ++fieldId) {
                    fieldTypeInfo.add((Object)OrcTypeToHiveTypeTranslator.getHiveType(orcType, fieldId, columnMetadata).getTypeInfo());
                }
                return HiveType.toHiveType(TypeInfoFactory.getStructTypeInfo((List)orcType.getFieldNames(), (List)fieldTypeInfo.build()));
            }
        }
        throw new VerifyException("Unhandled ORC type: " + orcType.getOrcTypeKind());
    }

    private static HiveType getHiveType(OrcType orcType, int index, ColumnMetadata<OrcType> columnMetadata) {
        return OrcTypeToHiveTypeTranslator.fromOrcTypeToHiveType((OrcType)columnMetadata.get(orcType.getFieldTypeIndex(index)), columnMetadata);
    }
}

