/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.orc;

import io.prestosql.orc.OrcDataSource;
import io.prestosql.orc.OrcDataSourceId;
import io.prestosql.orc.OrcReader;
import io.prestosql.orc.OrcReaderOptions;
import io.prestosql.plugin.hive.AcidInfo;
import io.prestosql.plugin.hive.FileFormatDataSourceStats;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.orc.HdfsOrcDataSource;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public final class OriginalFilesUtils {
    private OriginalFilesUtils() {
    }

    public static long getPrecedingRowCount(Collection<AcidInfo.OriginalFileInfo> originalFileInfos, Path splitPath, HdfsEnvironment hdfsEnvironment, String sessionUser, OrcReaderOptions options, Configuration configuration, FileFormatDataSourceStats stats) {
        long rowCount = 0L;
        for (AcidInfo.OriginalFileInfo originalFileInfo : originalFileInfos) {
            Path path = new Path(splitPath.getParent() + "/" + originalFileInfo.getName());
            if (path.compareTo((Object)splitPath) >= 0) continue;
            rowCount += OriginalFilesUtils.getRowsInFile(path, hdfsEnvironment, sessionUser, options, configuration, stats, originalFileInfo.getFileSize()).longValue();
        }
        return rowCount;
    }

    private static Long getRowsInFile(Path splitPath, HdfsEnvironment hdfsEnvironment, String sessionUser, OrcReaderOptions options, Configuration configuration, FileFormatDataSourceStats stats, long fileSize) {
        Long l;
        FileSystem fileSystem = hdfsEnvironment.getFileSystem(sessionUser, splitPath, configuration);
        FSDataInputStream inputStream = hdfsEnvironment.doAs(sessionUser, () -> fileSystem.open(splitPath));
        HdfsOrcDataSource orcDataSource = new HdfsOrcDataSource(new OrcDataSourceId(splitPath.toString()), fileSize, options, inputStream, stats);
        try {
            OrcReader reader = (OrcReader)OrcReader.createOrcReader((OrcDataSource)orcDataSource, (OrcReaderOptions)options).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, "Could not read ORC footer from empty file: " + splitPath));
            l = reader.getFooter().getNumberOfRows();
        }
        catch (Throwable throwable) {
            try {
                try {
                    orcDataSource.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (PrestoException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, "Could not read ORC footer from file: " + splitPath, (Throwable)e);
            }
        }
        orcDataSource.close();
        return l;
    }
}

