/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.parquet;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.LegacyConfig;
import io.airlift.units.DataSize;
import io.prestosql.parquet.writer.ParquetWriterOptions;

public class ParquetWriterConfig {
    private boolean parquetOptimizedWriterEnabled;
    private DataSize blockSize = DataSize.ofBytes((long)0x8000000L);
    private DataSize pageSize = DataSize.ofBytes((long)0x100000L);

    public DataSize getBlockSize() {
        return this.blockSize;
    }

    @Config(value="parquet.writer.block-size")
    @LegacyConfig(value={"hive.parquet.writer.block-size"})
    public ParquetWriterConfig setBlockSize(DataSize blockSize) {
        this.blockSize = blockSize;
        return this;
    }

    public DataSize getPageSize() {
        return this.pageSize;
    }

    @Config(value="parquet.writer.page-size")
    @LegacyConfig(value={"hive.parquet.writer.page-size"})
    public ParquetWriterConfig setPageSize(DataSize pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public boolean isParquetOptimizedWriterEnabled() {
        return this.parquetOptimizedWriterEnabled;
    }

    @Config(value="parquet.experimental-optimized-writer.enabled")
    @LegacyConfig(value={"hive.parquet.optimized-writer.enabled"})
    @ConfigDescription(value="Experimental: Enable optimized Parquet writer")
    public ParquetWriterConfig setParquetOptimizedWriterEnabled(boolean parquetOptimizedWriterEnabled) {
        this.parquetOptimizedWriterEnabled = parquetOptimizedWriterEnabled;
        return this;
    }

    public ParquetWriterOptions toParquetWriterOptions() {
        return ParquetWriterOptions.builder().setMaxBlockSize(this.getBlockSize()).setMaxPageSize(this.getPageSize()).build();
    }
}

