/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.rubix;

import com.codahale.metrics.MetricRegistry;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.io.Closer;
import com.qubole.rubix.bookkeeper.BookKeeper;
import com.qubole.rubix.bookkeeper.BookKeeperServer;
import com.qubole.rubix.bookkeeper.LocalDataTransferServer;
import com.qubole.rubix.core.CachingFileSystem;
import com.qubole.rubix.prestosql.CachingPrestoAdlFileSystem;
import com.qubole.rubix.prestosql.CachingPrestoAzureBlobFileSystem;
import com.qubole.rubix.prestosql.CachingPrestoGoogleHadoopFileSystem;
import com.qubole.rubix.prestosql.CachingPrestoNativeAzureFileSystem;
import com.qubole.rubix.prestosql.CachingPrestoS3FileSystem;
import com.qubole.rubix.prestosql.CachingPrestoSecureAzureBlobFileSystem;
import com.qubole.rubix.prestosql.CachingPrestoSecureNativeAzureFileSystem;
import com.qubole.rubix.prestosql.PrestoClusterManager;
import com.qubole.rubix.spi.CacheConfig;
import com.qubole.rubix.spi.thrift.BookKeeperService;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.prestosql.plugin.base.CatalogName;
import io.prestosql.plugin.hive.DynamicConfigurationProvider;
import io.prestosql.plugin.hive.HdfsConfigurationInitializer;
import io.prestosql.plugin.hive.rubix.DummyBookKeeper;
import io.prestosql.plugin.hive.rubix.RubixConfig;
import io.prestosql.plugin.hive.rubix.RubixHdfsInitializer;
import io.prestosql.plugin.hive.util.ConfigurationUtils;
import io.prestosql.plugin.hive.util.RetryDriver;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.HostAddress;
import io.prestosql.spi.Node;
import io.prestosql.spi.NodeManager;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;

public class RubixInitializer {
    private static final String RUBIX_S3_FS_CLASS_NAME = CachingPrestoS3FileSystem.class.getName();
    private static final String RUBIX_NATIVE_AZURE_FS_CLASS_NAME = CachingPrestoNativeAzureFileSystem.class.getName();
    private static final String RUBIX_SECURE_NATIVE_AZURE_FS_CLASS_NAME = CachingPrestoSecureNativeAzureFileSystem.class.getName();
    private static final String RUBIX_AZURE_BLOB_FS_CLASS_NAME = CachingPrestoAzureBlobFileSystem.class.getName();
    private static final String RUBIX_SECURE_AZURE_BLOB_FS_CLASS_NAME = CachingPrestoSecureAzureBlobFileSystem.class.getName();
    private static final String RUBIX_SECURE_ADL_CLASS_NAME = CachingPrestoAdlFileSystem.class.getName();
    private static final String RUBIX_GS_FS_CLASS_NAME = CachingPrestoGoogleHadoopFileSystem.class.getName();
    private static final String FILESYSTEM_OWNED_BY_RUBIX_CONFIG_PROPETY = "presto.fs.owned.by.rubix";
    private static final RetryDriver DEFAULT_COORDINATOR_RETRY_DRIVER = RetryDriver.retry().maxAttempts(Integer.MAX_VALUE).exponentialBackoff(new Duration(1.0, TimeUnit.SECONDS), new Duration(1.0, TimeUnit.SECONDS), new Duration(10.0, TimeUnit.MINUTES), 2.0);
    private static final Logger log = Logger.get(RubixInitializer.class);
    private final RetryDriver coordinatorRetryDriver;
    private final boolean startServerOnCoordinator;
    private final boolean parallelWarmupEnabled;
    private final Optional<String> cacheLocation;
    private final long cacheTtlMillis;
    private final int diskUsagePercentage;
    private final int bookKeeperServerPort;
    private final int dataTransferServerPort;
    private final NodeManager nodeManager;
    private final CatalogName catalogName;
    private final HdfsConfigurationInitializer hdfsConfigurationInitializer;
    private final RubixHdfsInitializer rubixHdfsInitializer;
    private volatile boolean cacheReady;
    @Nullable
    private HostAddress masterAddress;
    @Nullable
    private BookKeeperServer bookKeeperServer;

    @Inject
    public RubixInitializer(RubixConfig rubixConfig, NodeManager nodeManager, CatalogName catalogName, HdfsConfigurationInitializer hdfsConfigurationInitializer, RubixHdfsInitializer rubixHdfsInitializer) {
        this(DEFAULT_COORDINATOR_RETRY_DRIVER, rubixConfig, nodeManager, catalogName, hdfsConfigurationInitializer, rubixHdfsInitializer);
    }

    @VisibleForTesting
    RubixInitializer(RetryDriver coordinatorRetryDriver, RubixConfig rubixConfig, NodeManager nodeManager, CatalogName catalogName, HdfsConfigurationInitializer hdfsConfigurationInitializer, RubixHdfsInitializer rubixHdfsInitializer) {
        this.coordinatorRetryDriver = coordinatorRetryDriver;
        this.startServerOnCoordinator = rubixConfig.isStartServerOnCoordinator();
        this.parallelWarmupEnabled = rubixConfig.getReadMode().isParallelWarmupEnabled();
        this.cacheLocation = rubixConfig.getCacheLocation();
        this.cacheTtlMillis = rubixConfig.getCacheTtl().toMillis();
        this.diskUsagePercentage = rubixConfig.getDiskUsagePercentage();
        this.bookKeeperServerPort = rubixConfig.getBookKeeperServerPort();
        this.dataTransferServerPort = rubixConfig.getDataTransferServerPort();
        this.nodeManager = nodeManager;
        this.catalogName = catalogName;
        this.hdfsConfigurationInitializer = hdfsConfigurationInitializer;
        this.rubixHdfsInitializer = rubixHdfsInitializer;
    }

    void initializeRubix() {
        if (this.nodeManager.getCurrentNode().isCoordinator() && !this.startServerOnCoordinator) {
            this.setupRubixMetrics();
            this.cacheReady = true;
            return;
        }
        if (this.cacheLocation.isEmpty()) {
            throw new IllegalArgumentException("caching directories were not provided");
        }
        this.waitForCoordinator();
        this.startRubix();
    }

    @PreDestroy
    public void stopRubix() throws IOException {
        try (Closer closer = Closer.create();){
            closer.register(() -> {
                if (this.bookKeeperServer != null) {
                    this.bookKeeperServer.stopServer();
                    this.bookKeeperServer = null;
                }
            });
            closer.register(LocalDataTransferServer::stopServer);
        }
    }

    public void enableRubix(Configuration configuration) {
        if (!this.cacheReady) {
            this.disableRubix(configuration);
            return;
        }
        this.updateRubixConfiguration(configuration, Owner.PRESTO);
        DynamicConfigurationProvider.setCacheKey(configuration, "rubix_enabled");
    }

    public void disableRubix(Configuration configuration) {
        CacheConfig.setCacheDataEnabled((Configuration)configuration, (boolean)false);
        DynamicConfigurationProvider.setCacheKey(configuration, "rubix_disabled");
    }

    public static Owner getConfigurationOwner(Configuration configuration) {
        if (configuration.get(FILESYSTEM_OWNED_BY_RUBIX_CONFIG_PROPETY, "").equals("true")) {
            return Owner.RUBIX;
        }
        return Owner.PRESTO;
    }

    @VisibleForTesting
    boolean isServerUp() {
        return LocalDataTransferServer.isServerUp() && this.bookKeeperServer != null && this.bookKeeperServer.isServerUp();
    }

    private void waitForCoordinator() {
        try {
            this.coordinatorRetryDriver.run("waitForCoordinator", () -> {
                if (this.nodeManager.getAllNodes().stream().noneMatch(Node::isCoordinator)) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "No coordinator node available");
                }
                return null;
            });
        }
        catch (Exception exception) {
            Throwables.propagateIfPossible((Throwable)exception, PrestoException.class);
            throw new RuntimeException(exception);
        }
    }

    private void startRubix() {
        Configuration configuration = this.getRubixServerConfiguration();
        MetricRegistry metricRegistry = new MetricRegistry();
        this.bookKeeperServer = new BookKeeperServer();
        BookKeeper bookKeeper = this.bookKeeperServer.startServer(configuration, metricRegistry);
        LocalDataTransferServer.startServer((Configuration)configuration, (MetricRegistry)metricRegistry, (BookKeeper)bookKeeper);
        CachingFileSystem.setLocalBookKeeper((Configuration)configuration, (BookKeeperService.Iface)bookKeeper, (String)("catalog=" + this.catalogName));
        PrestoClusterManager.setNodeManager((NodeManager)this.nodeManager);
        log.info("Rubix initialized successfully");
        this.cacheReady = true;
    }

    private void setupRubixMetrics() {
        Configuration configuration = this.getRubixServerConfiguration();
        new BookKeeperServer().setupServer(configuration, new MetricRegistry());
        CachingFileSystem.setLocalBookKeeper((Configuration)configuration, (BookKeeperService.Iface)new DummyBookKeeper(), (String)("catalog=" + this.catalogName));
        PrestoClusterManager.setNodeManager((NodeManager)this.nodeManager);
    }

    private Configuration getRubixServerConfiguration() {
        Node master = this.nodeManager.getAllNodes().stream().filter(Node::isCoordinator).findFirst().get();
        this.masterAddress = master.getHostAndPort();
        Configuration configuration = ConfigurationUtils.getInitialConfiguration();
        this.hdfsConfigurationInitializer.initializeConfiguration(configuration);
        this.updateRubixConfiguration(configuration, Owner.RUBIX);
        DynamicConfigurationProvider.setCacheKey(configuration, "rubix_internal");
        return configuration;
    }

    private void updateRubixConfiguration(Configuration config, Owner owner) {
        Preconditions.checkState((this.masterAddress != null ? 1 : 0) != 0, (Object)"masterAddress is not set");
        CacheConfig.setCacheDataEnabled((Configuration)config, (boolean)true);
        CacheConfig.setOnMaster((Configuration)config, (boolean)this.nodeManager.getCurrentNode().isCoordinator());
        CacheConfig.setCoordinatorHostName((Configuration)config, (String)this.masterAddress.getHostText());
        CacheConfig.setIsParallelWarmupEnabled((Configuration)config, (boolean)this.parallelWarmupEnabled);
        CacheConfig.setCacheDataExpirationAfterWrite((Configuration)config, (long)this.cacheTtlMillis);
        CacheConfig.setCacheDataFullnessPercentage((Configuration)config, (int)this.diskUsagePercentage);
        CacheConfig.setBookKeeperServerPort((Configuration)config, (int)this.bookKeeperServerPort);
        CacheConfig.setDataTransferServerPort((Configuration)config, (int)this.dataTransferServerPort);
        CacheConfig.setEmbeddedMode((Configuration)config, (boolean)true);
        CacheConfig.enableHeartbeat((Configuration)config, (boolean)false);
        CacheConfig.setClusterNodeRefreshTime((Configuration)config, (int)10);
        if (this.nodeManager.getCurrentNode().isCoordinator() && !this.startServerOnCoordinator) {
            CacheConfig.setCacheDataOnMasterEnabled((Configuration)config, (boolean)false);
        } else {
            CacheConfig.setCacheDataDirPrefix((Configuration)config, (String)this.cacheLocation.get());
        }
        config.set("fs.s3.impl", RUBIX_S3_FS_CLASS_NAME);
        config.set("fs.s3a.impl", RUBIX_S3_FS_CLASS_NAME);
        config.set("fs.s3n.impl", RUBIX_S3_FS_CLASS_NAME);
        config.set("fs.wasb.impl", RUBIX_NATIVE_AZURE_FS_CLASS_NAME);
        config.set("fs.wasbs.impl", RUBIX_SECURE_NATIVE_AZURE_FS_CLASS_NAME);
        config.set("fs.abfs.impl", RUBIX_AZURE_BLOB_FS_CLASS_NAME);
        config.set("fs.abfss.impl", RUBIX_SECURE_AZURE_BLOB_FS_CLASS_NAME);
        config.set("fs.adl.impl", RUBIX_SECURE_ADL_CLASS_NAME);
        config.set("fs.gs.impl", RUBIX_GS_FS_CLASS_NAME);
        if (owner == Owner.RUBIX) {
            config.set(FILESYSTEM_OWNED_BY_RUBIX_CONFIG_PROPETY, "true");
        }
        this.rubixHdfsInitializer.initializeConfiguration(config);
    }

    public static enum Owner {
        PRESTO,
        RUBIX;

    }
}

