/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.s3;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.prestosql.plugin.base.CatalogName;
import io.prestosql.plugin.hive.ConfigurationInitializer;
import io.prestosql.plugin.hive.DynamicConfigurationProvider;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.rubix.RubixEnabledConfig;
import io.prestosql.plugin.hive.s3.HiveS3Config;
import io.prestosql.plugin.hive.s3.HiveS3TypeConfig;
import io.prestosql.plugin.hive.s3.PrestoS3ConfigurationInitializer;
import io.prestosql.plugin.hive.s3.PrestoS3FileSystem;
import io.prestosql.plugin.hive.s3.PrestoS3FileSystemStats;
import io.prestosql.plugin.hive.s3.S3FileSystemType;
import io.prestosql.plugin.hive.s3.S3SecurityMappingConfig;
import io.prestosql.plugin.hive.s3.S3SecurityMappingConfigurationProvider;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JavaUtils;
import org.weakref.jmx.guice.ExportBinder;

public class HiveS3Module
extends AbstractConfigurationAwareModule {
    public static final String EMR_FS_CLASS_NAME = "com.amazon.ws.emr.hadoop.fs.EmrFileSystem";

    protected void setup(Binder binder) {
        S3FileSystemType type = ((HiveS3TypeConfig)this.buildConfigObject(HiveS3TypeConfig.class)).getS3FileSystemType();
        if (type == S3FileSystemType.PRESTO) {
            this.bindSecurityMapping(binder);
            Multibinder.newSetBinder((Binder)binder, ConfigurationInitializer.class).addBinding().to(PrestoS3ConfigurationInitializer.class).in(Scopes.SINGLETON);
            ConfigBinder.configBinder((Binder)binder).bindConfig(HiveS3Config.class);
            binder.bind(PrestoS3FileSystemStats.class).toInstance((Object)PrestoS3FileSystem.getFileSystemStats());
            Provider catalogName = binder.getProvider(CatalogName.class);
            ExportBinder.newExporter((Binder)binder).export(PrestoS3FileSystemStats.class).as(generator -> generator.generatedNameOf(PrestoS3FileSystem.class, ((CatalogName)catalogName.get()).toString()));
        } else if (type == S3FileSystemType.EMRFS) {
            HiveS3Module.validateEmrFsClass();
            Multibinder.newSetBinder((Binder)binder, ConfigurationInitializer.class).addBinding().to(EmrFsS3ConfigurationInitializer.class).in(Scopes.SINGLETON);
        } else if (type != S3FileSystemType.HADOOP_DEFAULT) {
            throw new RuntimeException("Unknown file system type: " + type);
        }
    }

    private void bindSecurityMapping(Binder binder) {
        if (((S3SecurityMappingConfig)this.buildConfigObject(S3SecurityMappingConfig.class)).getConfigFile().isPresent()) {
            Preconditions.checkArgument((!((HiveConfig)this.buildConfigObject(HiveConfig.class)).isS3SelectPushdownEnabled() ? 1 : 0) != 0, (Object)"S3 security mapping is not compatible with S3 Select pushdown");
            Preconditions.checkArgument((!((RubixEnabledConfig)this.buildConfigObject(RubixEnabledConfig.class)).isCacheEnabled() ? 1 : 0) != 0, (Object)"S3 security mapping is not compatible with Hive caching");
            Multibinder.newSetBinder((Binder)binder, DynamicConfigurationProvider.class).addBinding().to(S3SecurityMappingConfigurationProvider.class).in(Scopes.SINGLETON);
        }
    }

    private static void validateEmrFsClass() {
        try {
            Class.forName(EMR_FS_CLASS_NAME, true, JavaUtils.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("EMR File System class not found: com.amazon.ws.emr.hadoop.fs.EmrFileSystem", e);
        }
    }

    public static class EmrFsS3ConfigurationInitializer
    implements ConfigurationInitializer {
        @Override
        public void initializeConfiguration(Configuration config) {
            config.set("fs.s3.impl", HiveS3Module.EMR_FS_CLASS_NAME);
            config.set("fs.s3a.impl", HiveS3Module.EMR_FS_CLASS_NAME);
            config.set("fs.s3n.impl", HiveS3Module.EMR_FS_CLASS_NAME);
        }
    }
}

