/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.security;

import io.prestosql.plugin.hive.HiveTransactionHandle;
import io.prestosql.plugin.hive.authentication.HiveIdentity;
import io.prestosql.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.plugin.hive.security.LegacySecurityConfig;
import io.prestosql.spi.connector.ConnectorAccessControl;
import io.prestosql.spi.connector.ConnectorSecurityContext;
import io.prestosql.spi.connector.SchemaRoutineName;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.security.AccessDeniedException;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.spi.security.Privilege;
import io.prestosql.spi.security.ViewExpression;
import io.prestosql.spi.type.Type;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.inject.Inject;

public class LegacyAccessControl
implements ConnectorAccessControl {
    private final Function<HiveTransactionHandle, SemiTransactionalHiveMetastore> metastoreProvider;
    private final boolean allowDropTable;
    private final boolean allowRenameTable;
    private final boolean allowCommentTable;
    private final boolean allowCommentColumn;
    private final boolean allowAddColumn;
    private final boolean allowDropColumn;
    private final boolean allowRenameColumn;

    @Inject
    public LegacyAccessControl(Function<HiveTransactionHandle, SemiTransactionalHiveMetastore> metastoreProvider, LegacySecurityConfig securityConfig) {
        this.metastoreProvider = Objects.requireNonNull(metastoreProvider, "metastoreProvider is null");
        Objects.requireNonNull(securityConfig, "securityConfig is null");
        this.allowDropTable = securityConfig.getAllowDropTable();
        this.allowRenameTable = securityConfig.getAllowRenameTable();
        this.allowCommentTable = securityConfig.getAllowCommentTable();
        this.allowCommentColumn = securityConfig.getAllowCommentColumn();
        this.allowAddColumn = securityConfig.getAllowAddColumn();
        this.allowDropColumn = securityConfig.getAllowDropColumn();
        this.allowRenameColumn = securityConfig.getAllowRenameColumn();
    }

    public void checkCanCreateSchema(ConnectorSecurityContext context, String schemaName) {
    }

    public void checkCanDropSchema(ConnectorSecurityContext context, String schemaName) {
    }

    public void checkCanRenameSchema(ConnectorSecurityContext context, String schemaName, String newSchemaName) {
    }

    public void checkCanSetSchemaAuthorization(ConnectorSecurityContext context, String schemaName, PrestoPrincipal principal) {
    }

    public void checkCanShowSchemas(ConnectorSecurityContext context) {
    }

    public Set<String> filterSchemas(ConnectorSecurityContext context, Set<String> schemaNames) {
        return schemaNames;
    }

    public void checkCanShowCreateSchema(ConnectorSecurityContext context, String schemaName) {
    }

    public void checkCanShowCreateTable(ConnectorSecurityContext context, SchemaTableName tableName) {
    }

    public void checkCanCreateTable(ConnectorSecurityContext context, SchemaTableName tableName) {
    }

    public void checkCanDropTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        Optional<Table> target;
        if (!this.allowDropTable) {
            AccessDeniedException.denyDropTable((String)tableName.toString());
        }
        if ((target = this.metastoreProvider.apply((HiveTransactionHandle)context.getTransactionHandle()).getTable(new HiveIdentity(context.getIdentity()), tableName.getSchemaName(), tableName.getTableName())).isEmpty()) {
            AccessDeniedException.denyDropTable((String)tableName.toString(), (String)"Table not found");
        }
        if (!context.getIdentity().getUser().equals(target.get().getOwner())) {
            AccessDeniedException.denyDropTable((String)tableName.toString(), (String)String.format("Owner of the table ('%s') is different from session user ('%s')", target.get().getOwner(), context.getIdentity().getUser()));
        }
    }

    public void checkCanRenameTable(ConnectorSecurityContext context, SchemaTableName tableName, SchemaTableName newTableName) {
        if (!this.allowRenameTable) {
            AccessDeniedException.denyRenameTable((String)tableName.toString(), (String)newTableName.toString());
        }
    }

    public void checkCanSetTableComment(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.allowCommentTable) {
            AccessDeniedException.denyCommentTable((String)tableName.toString());
        }
    }

    public void checkCanSetColumnComment(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.allowCommentColumn) {
            AccessDeniedException.denyCommentColumn((String)tableName.toString());
        }
    }

    public void checkCanShowTables(ConnectorSecurityContext context, String schemaName) {
    }

    public Set<SchemaTableName> filterTables(ConnectorSecurityContext context, Set<SchemaTableName> tableNames) {
        return tableNames;
    }

    public void checkCanShowColumns(ConnectorSecurityContext context, SchemaTableName tableName) {
    }

    public Set<String> filterColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> columns) {
        return columns;
    }

    public void checkCanAddColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.allowAddColumn) {
            AccessDeniedException.denyAddColumn((String)tableName.toString());
        }
    }

    public void checkCanDropColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.allowDropColumn) {
            AccessDeniedException.denyDropColumn((String)tableName.toString());
        }
    }

    public void checkCanRenameColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.allowRenameColumn) {
            AccessDeniedException.denyRenameColumn((String)tableName.toString());
        }
    }

    public void checkCanSetTableAuthorization(ConnectorSecurityContext context, SchemaTableName tableName, PrestoPrincipal principal) {
    }

    public void checkCanSelectFromColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> columnNames) {
    }

    public void checkCanInsertIntoTable(ConnectorSecurityContext context, SchemaTableName tableName) {
    }

    public void checkCanDeleteFromTable(ConnectorSecurityContext context, SchemaTableName tableName) {
    }

    public void checkCanCreateView(ConnectorSecurityContext context, SchemaTableName viewName) {
    }

    public void checkCanRenameView(ConnectorSecurityContext context, SchemaTableName viewName, SchemaTableName newViewName) {
    }

    public void checkCanSetViewAuthorization(ConnectorSecurityContext context, SchemaTableName viewName, PrestoPrincipal principal) {
    }

    public void checkCanDropView(ConnectorSecurityContext context, SchemaTableName viewName) {
    }

    public void checkCanCreateViewWithSelectFromColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> columnNames) {
    }

    public void checkCanSetCatalogSessionProperty(ConnectorSecurityContext context, String propertyName) {
    }

    public void checkCanGrantSchemaPrivilege(ConnectorSecurityContext context, Privilege privilege, String schemaName, PrestoPrincipal grantee, boolean grantOption) {
    }

    public void checkCanRevokeSchemaPrivilege(ConnectorSecurityContext context, Privilege privilege, String schemaName, PrestoPrincipal revokee, boolean grantOption) {
    }

    public void checkCanGrantTablePrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, PrestoPrincipal grantee, boolean grantOption) {
    }

    public void checkCanRevokeTablePrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, PrestoPrincipal revokee, boolean grantOption) {
    }

    public void checkCanCreateRole(ConnectorSecurityContext context, String role, Optional<PrestoPrincipal> grantor) {
    }

    public void checkCanDropRole(ConnectorSecurityContext context, String role) {
    }

    public void checkCanGrantRoles(ConnectorSecurityContext context, Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOption, Optional<PrestoPrincipal> grantor, String catalogName) {
    }

    public void checkCanRevokeRoles(ConnectorSecurityContext context, Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOption, Optional<PrestoPrincipal> grantor, String catalogName) {
    }

    public void checkCanSetRole(ConnectorSecurityContext context, String role, String catalogName) {
    }

    public void checkCanShowRoleAuthorizationDescriptors(ConnectorSecurityContext context, String catalogName) {
    }

    public void checkCanShowRoles(ConnectorSecurityContext context, String catalogName) {
    }

    public void checkCanShowCurrentRoles(ConnectorSecurityContext context, String catalogName) {
    }

    public void checkCanShowRoleGrants(ConnectorSecurityContext context, String catalogName) {
    }

    public void checkCanExecuteProcedure(ConnectorSecurityContext context, SchemaRoutineName procedure) {
    }

    public Optional<ViewExpression> getRowFilter(ConnectorSecurityContext context, SchemaTableName tableName) {
        return Optional.empty();
    }

    public Optional<ViewExpression> getColumnMask(ConnectorSecurityContext context, SchemaTableName tableName, String columnName, Type type) {
        return Optional.empty();
    }
}

