/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class AsyncQueue<T> {
    private final int targetQueueSize;
    @GuardedBy(value="this")
    private Queue<T> elements;
    @GuardedBy(value="this")
    private SettableFuture<?> notFullSignal = SettableFuture.create();
    @GuardedBy(value="this")
    private SettableFuture<?> notEmptySignal = SettableFuture.create();
    @GuardedBy(value="this")
    private boolean finishing;
    @GuardedBy(value="this")
    private int borrowerCount;
    private final Executor executor;

    public AsyncQueue(int targetQueueSize, Executor executor) {
        Preconditions.checkArgument((targetQueueSize >= 1 ? 1 : 0) != 0, (Object)"targetQueueSize must be at least 1");
        this.targetQueueSize = targetQueueSize;
        this.elements = new ArrayDeque<T>(targetQueueSize * 2);
        this.executor = Objects.requireNonNull(executor);
    }

    public synchronized boolean isFinished() {
        return this.finishing && this.borrowerCount == 0 && this.elements.size() == 0;
    }

    public synchronized void finish() {
        if (this.finishing) {
            return;
        }
        this.finishing = true;
        this.signalIfFinishing();
    }

    private synchronized void signalIfFinishing() {
        if (this.finishing && this.borrowerCount == 0) {
            if (this.elements.size() == 0) {
                this.elements = new ArrayDeque<T>(0);
                AsyncQueue.completeAsync(this.executor, this.notEmptySignal);
                this.notEmptySignal = SettableFuture.create();
            } else if (this.elements.size() >= this.targetQueueSize) {
                AsyncQueue.completeAsync(this.executor, this.notFullSignal);
                this.notFullSignal = SettableFuture.create();
            }
        }
    }

    public synchronized ListenableFuture<?> offer(T element) {
        Objects.requireNonNull(element);
        if (this.finishing && this.borrowerCount == 0) {
            return Futures.immediateFuture(null);
        }
        this.elements.add(element);
        int newSize = this.elements.size();
        if (newSize == 1) {
            AsyncQueue.completeAsync(this.executor, this.notEmptySignal);
            this.notEmptySignal = SettableFuture.create();
        }
        if (newSize >= this.targetQueueSize) {
            return this.notFullSignal;
        }
        return Futures.immediateFuture(null);
    }

    public synchronized int size() {
        return this.elements.size();
    }

    private synchronized List<T> getBatch(int maxSize) {
        int oldSize = this.elements.size();
        int reduceBy = Math.min(maxSize, oldSize);
        if (reduceBy == 0) {
            return ImmutableList.of();
        }
        ArrayList<T> result = new ArrayList<T>(reduceBy);
        for (int i = 0; i < reduceBy; ++i) {
            result.add(this.elements.remove());
        }
        if (oldSize >= this.targetQueueSize && oldSize - reduceBy < this.targetQueueSize) {
            AsyncQueue.completeAsync(this.executor, this.notFullSignal);
            this.notFullSignal = SettableFuture.create();
        }
        return result;
    }

    public synchronized ListenableFuture<List<T>> getBatchAsync(int maxSize) {
        return this.borrowBatchAsync(maxSize, elements -> new BorrowResult(ImmutableList.of(), (List)elements));
    }

    protected synchronized SettableFuture<?> getNotEmptySignal() {
        return this.notEmptySignal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <O> ListenableFuture<O> borrowBatchAsync(int maxSize, Function<List<T>, BorrowResult<T, O>> function) {
        ListenableFuture borrowedListFuture;
        Preconditions.checkArgument((maxSize >= 0 ? 1 : 0) != 0, (Object)"maxSize must be at least 0");
        AsyncQueue asyncQueue = this;
        synchronized (asyncQueue) {
            List<T> list = this.getBatch(maxSize);
            if (!list.isEmpty()) {
                borrowedListFuture = Futures.immediateFuture(list);
                ++this.borrowerCount;
            } else {
                borrowedListFuture = this.finishing && this.borrowerCount == 0 ? Futures.immediateFuture((Object)ImmutableList.of()) : Futures.transform(this.notEmptySignal, ignored -> {
                    AsyncQueue asyncQueue = this;
                    synchronized (asyncQueue) {
                        List<T> batch = this.getBatch(maxSize);
                        if (!batch.isEmpty()) {
                            ++this.borrowerCount;
                        }
                        return batch;
                    }
                }, (Executor)this.executor);
            }
        }
        return Futures.transform((ListenableFuture)borrowedListFuture, elements -> {
            try {
                BorrowResult borrowResult = (BorrowResult)function.apply((List<T>)elements);
                if (elements.isEmpty()) {
                    Preconditions.checkArgument((boolean)borrowResult.getElementsToInsert().isEmpty(), (Object)"Function must not insert anything when no element is borrowed");
                    Object r = borrowResult.getResult();
                    return r;
                }
                for (Object element : borrowResult.getElementsToInsert()) {
                    this.offer(element);
                }
                Iterator<Object> iterator = borrowResult.getResult();
                return iterator;
            }
            finally {
                if (!elements.isEmpty()) {
                    AsyncQueue asyncQueue = this;
                    synchronized (asyncQueue) {
                        --this.borrowerCount;
                        this.signalIfFinishing();
                    }
                }
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private static void completeAsync(Executor executor, SettableFuture<?> future) {
        executor.execute(() -> future.set(null));
    }

    public static final class BorrowResult<T, R> {
        private final List<T> elementsToInsert;
        private final R result;

        public BorrowResult(List<T> elementsToInsert, R result) {
            this.elementsToInsert = ImmutableList.copyOf(elementsToInsert);
            this.result = result;
        }

        public List<T> getElementsToInsert() {
            return this.elementsToInsert;
        }

        public R getResult() {
            return this.result;
        }
    }
}

