/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.util;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import io.airlift.slice.Slice;
import io.prestosql.plugin.hive.util.HiveBucketingV1;
import io.prestosql.plugin.hive.util.HiveTypeTranslator;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.type.Type;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hive.common.util.Murmur3;

final class HiveBucketingV2 {
    private HiveBucketingV2() {
    }

    static int getBucketHashCode(List<TypeInfo> types, Page page, int position) {
        Preconditions.checkArgument((types.size() == page.getChannelCount() ? 1 : 0) != 0);
        int result = 0;
        for (int i = 0; i < page.getChannelCount(); ++i) {
            int fieldHash = HiveBucketingV2.hash(types.get(i), page.getBlock(i), position);
            result = result * 31 + fieldHash;
        }
        return result;
    }

    static int getBucketHashCode(List<TypeInfo> types, Object[] values) {
        Preconditions.checkArgument((types.size() == values.length ? 1 : 0) != 0);
        int result = 0;
        for (int i = 0; i < values.length; ++i) {
            int fieldHash = HiveBucketingV2.hash(types.get(i), values[i]);
            result = result * 31 + fieldHash;
        }
        return result;
    }

    private static int hash(TypeInfo type, Block block, int position) {
        if (block.isNull(position)) {
            return 0;
        }
        switch (type.getCategory()) {
            case PRIMITIVE: {
                PrimitiveTypeInfo typeInfo = (PrimitiveTypeInfo)type;
                PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = typeInfo.getPrimitiveCategory();
                Type prestoType = Objects.requireNonNull(HiveTypeTranslator.fromPrimitiveType(typeInfo));
                switch (primitiveCategory) {
                    case BOOLEAN: {
                        return prestoType.getBoolean(block, position) ? 1 : 0;
                    }
                    case BYTE: {
                        return SignedBytes.checkedCast((long)prestoType.getLong(block, position));
                    }
                    case SHORT: {
                        return Murmur3.hash32((byte[])HiveBucketingV2.bytes(Shorts.checkedCast((long)prestoType.getLong(block, position))));
                    }
                    case INT: {
                        return Murmur3.hash32((byte[])HiveBucketingV2.bytes(Math.toIntExact(prestoType.getLong(block, position))));
                    }
                    case LONG: {
                        return Murmur3.hash32((byte[])HiveBucketingV2.bytes(prestoType.getLong(block, position)));
                    }
                    case FLOAT: {
                        return Murmur3.hash32((byte[])HiveBucketingV2.bytes(Float.floatToRawIntBits(Float.floatToIntBits(Float.intBitsToFloat(Math.toIntExact(prestoType.getLong(block, position)))))));
                    }
                    case DOUBLE: {
                        return Murmur3.hash32((byte[])HiveBucketingV2.bytes(Double.doubleToRawLongBits(Double.doubleToLongBits(prestoType.getDouble(block, position)))));
                    }
                    case STRING: {
                        return Murmur3.hash32((byte[])prestoType.getSlice(block, position).getBytes());
                    }
                    case VARCHAR: {
                        return Murmur3.hash32((byte[])prestoType.getSlice(block, position).getBytes());
                    }
                    case DATE: {
                        return Murmur3.hash32((byte[])HiveBucketingV2.bytes(Math.toIntExact(prestoType.getLong(block, position))));
                    }
                }
                throw new UnsupportedOperationException("Computation of Hive bucket hashCode is not supported for Hive primitive category: " + primitiveCategory);
            }
            case LIST: {
                return HiveBucketingV2.hashOfList((ListTypeInfo)type, (Block)block.getObject(position, Block.class));
            }
            case MAP: {
                return HiveBucketingV2.hashOfMap((MapTypeInfo)type, (Block)block.getObject(position, Block.class));
            }
        }
        throw new UnsupportedOperationException("Computation of Hive bucket hashCode is not supported for Hive category: " + type.getCategory());
    }

    private static int hash(TypeInfo type, Object value) {
        if (value == null) {
            return 0;
        }
        switch (type.getCategory()) {
            case PRIMITIVE: {
                PrimitiveTypeInfo typeInfo = (PrimitiveTypeInfo)type;
                PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = typeInfo.getPrimitiveCategory();
                switch (primitiveCategory) {
                    case BOOLEAN: {
                        return (Boolean)value != false ? 1 : 0;
                    }
                    case BYTE: {
                        return SignedBytes.checkedCast((long)((Long)value));
                    }
                    case SHORT: {
                        return Murmur3.hash32((byte[])HiveBucketingV2.bytes(Shorts.checkedCast((long)((Long)value))));
                    }
                    case INT: {
                        return Murmur3.hash32((byte[])HiveBucketingV2.bytes(Math.toIntExact((Long)value)));
                    }
                    case LONG: {
                        return Murmur3.hash32((byte[])HiveBucketingV2.bytes((Long)value));
                    }
                    case FLOAT: {
                        return Murmur3.hash32((byte[])HiveBucketingV2.bytes(Float.floatToRawIntBits(Float.floatToIntBits(Float.intBitsToFloat(Math.toIntExact((Long)value))))));
                    }
                    case DOUBLE: {
                        return Murmur3.hash32((byte[])HiveBucketingV2.bytes(Double.doubleToRawLongBits(Double.doubleToLongBits((Double)value))));
                    }
                    case STRING: {
                        return Murmur3.hash32((byte[])((Slice)value).getBytes());
                    }
                    case VARCHAR: {
                        return Murmur3.hash32((byte[])((Slice)value).getBytes());
                    }
                    case DATE: {
                        return Murmur3.hash32((byte[])HiveBucketingV2.bytes(Math.toIntExact((Long)value)));
                    }
                }
                throw new UnsupportedOperationException("Computation of Hive bucket hashCode is not supported for Hive primitive category: " + primitiveCategory);
            }
            case LIST: {
                return HiveBucketingV2.hashOfList((ListTypeInfo)type, (Block)value);
            }
            case MAP: {
                return HiveBucketingV2.hashOfMap((MapTypeInfo)type, (Block)value);
            }
        }
        throw new UnsupportedOperationException("Computation of Hive bucket hashCode is not supported for Hive category: " + type.getCategory());
    }

    private static int hashOfMap(MapTypeInfo type, Block singleMapBlock) {
        TypeInfo keyTypeInfo = type.getMapKeyTypeInfo();
        TypeInfo valueTypeInfo = type.getMapValueTypeInfo();
        int result = 0;
        for (int i = 0; i < singleMapBlock.getPositionCount(); i += 2) {
            result += HiveBucketingV2.hash(keyTypeInfo, singleMapBlock, i) ^ HiveBucketingV1.hash(valueTypeInfo, singleMapBlock, i + 1);
        }
        return result;
    }

    private static int hashOfList(ListTypeInfo type, Block singleListBlock) {
        TypeInfo elementTypeInfo = type.getListElementTypeInfo();
        int result = 0;
        for (int i = 0; i < singleListBlock.getPositionCount(); ++i) {
            result = result * 31 + HiveBucketingV2.hash(elementTypeInfo, singleListBlock, i);
        }
        return result;
    }

    private static byte[] bytes(short value) {
        return new byte[]{(byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
    }

    private static byte[] bytes(int value) {
        return new byte[]{(byte)(value >> 24 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
    }

    private static byte[] bytes(long value) {
        return new byte[]{(byte)(value >> 56 & 0xFFL), (byte)(value >> 48 & 0xFFL), (byte)(value >> 40 & 0xFFL), (byte)(value >> 32 & 0xFFL), (byte)(value >> 24 & 0xFFL), (byte)(value >> 16 & 0xFFL), (byte)(value >> 8 & 0xFFL), (byte)(value & 0xFFL)};
    }
}

