/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.util.HiveUtil;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.CharType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.NamedTypeSignature;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;

public final class HiveTypeTranslator {
    private HiveTypeTranslator() {
    }

    public static TypeInfo toTypeInfo(Type type) {
        Objects.requireNonNull(type, "type is null");
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return HiveType.HIVE_BOOLEAN.getTypeInfo();
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return HiveType.HIVE_LONG.getTypeInfo();
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            return HiveType.HIVE_INT.getTypeInfo();
        }
        if (SmallintType.SMALLINT.equals((Object)type)) {
            return HiveType.HIVE_SHORT.getTypeInfo();
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            return HiveType.HIVE_BYTE.getTypeInfo();
        }
        if (RealType.REAL.equals((Object)type)) {
            return HiveType.HIVE_FLOAT.getTypeInfo();
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return HiveType.HIVE_DOUBLE.getTypeInfo();
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            if (varcharType.isUnbounded()) {
                return HiveType.HIVE_STRING.getTypeInfo();
            }
            if (varcharType.getBoundedLength() <= 65535) {
                return TypeInfoFactory.getVarcharTypeInfo((int)varcharType.getBoundedLength());
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type: %s. Supported VARCHAR types: VARCHAR(<=%d), VARCHAR.", type, 65535));
        }
        if (type instanceof CharType) {
            CharType charType = (CharType)type;
            int charLength = charType.getLength();
            if (charLength <= 255) {
                return TypeInfoFactory.getCharTypeInfo((int)charLength);
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type: %s. Supported CHAR types: CHAR(<=%d).", type, 255));
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return HiveType.HIVE_BINARY.getTypeInfo();
        }
        if (DateType.DATE.equals((Object)type)) {
            return HiveType.HIVE_DATE.getTypeInfo();
        }
        if (type instanceof TimestampType) {
            return HiveType.HIVE_TIMESTAMP.getTypeInfo();
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return new DecimalTypeInfo(decimalType.getPrecision(), decimalType.getScale());
        }
        if (HiveUtil.isArrayType(type)) {
            TypeInfo elementType = HiveTypeTranslator.toTypeInfo((Type)type.getTypeParameters().get(0));
            return TypeInfoFactory.getListTypeInfo((TypeInfo)elementType);
        }
        if (HiveUtil.isMapType(type)) {
            TypeInfo keyType = HiveTypeTranslator.toTypeInfo((Type)type.getTypeParameters().get(0));
            TypeInfo valueType = HiveTypeTranslator.toTypeInfo((Type)type.getTypeParameters().get(1));
            return TypeInfoFactory.getMapTypeInfo((TypeInfo)keyType, (TypeInfo)valueType);
        }
        if (HiveUtil.isRowType(type)) {
            ImmutableList.Builder fieldNames = ImmutableList.builder();
            for (TypeSignatureParameter parameter : type.getTypeSignature().getParameters()) {
                if (!parameter.isNamedTypeSignature()) {
                    throw new IllegalArgumentException(String.format("Expected all parameters to be named type, but got %s", parameter));
                }
                NamedTypeSignature namedTypeSignature = parameter.getNamedTypeSignature();
                if (namedTypeSignature.getName().isEmpty()) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Anonymous row type is not supported in Hive. Please give each field a name: %s", type));
                }
                fieldNames.add((Object)((String)namedTypeSignature.getName().get()));
            }
            return TypeInfoFactory.getStructTypeInfo((List)fieldNames.build(), (List)((List)type.getTypeParameters().stream().map(HiveTypeTranslator::toTypeInfo).collect(ImmutableList.toImmutableList())));
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type: %s", type));
    }

    public static TypeSignature toTypeSignature(TypeInfo typeInfo) {
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                Type primitiveType = HiveTypeTranslator.fromPrimitiveType((PrimitiveTypeInfo)typeInfo);
                if (primitiveType == null) break;
                return primitiveType.getTypeSignature();
            }
            case MAP: {
                MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
                return TypeSignature.mapType((TypeSignature)HiveTypeTranslator.toTypeSignature(mapTypeInfo.getMapKeyTypeInfo()), (TypeSignature)HiveTypeTranslator.toTypeSignature(mapTypeInfo.getMapValueTypeInfo()));
            }
            case LIST: {
                ListTypeInfo listTypeInfo = (ListTypeInfo)typeInfo;
                TypeSignature elementType = HiveTypeTranslator.toTypeSignature(listTypeInfo.getListElementTypeInfo());
                return TypeSignature.arrayType((TypeSignatureParameter)TypeSignatureParameter.typeParameter((TypeSignature)elementType));
            }
            case STRUCT: {
                StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                ArrayList fieldTypes = structTypeInfo.getAllStructFieldTypeInfos();
                ArrayList fieldNames = structTypeInfo.getAllStructFieldNames();
                if (fieldTypes.size() != fieldNames.size()) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Invalid Hive struct type: %s", typeInfo));
                }
                return TypeSignature.rowType(Streams.zip(fieldNames.stream().map(s -> s.toLowerCase(Locale.US)), fieldTypes.stream().map(HiveTypeTranslator::toTypeSignature), TypeSignatureParameter::namedField).collect(Collectors.toList()));
            }
            case UNION: {
                UnionTypeInfo unionTypeInfo = (UnionTypeInfo)typeInfo;
                List unionObjectTypes = unionTypeInfo.getAllUnionObjectTypeInfos();
                ImmutableList.Builder typeSignatures = ImmutableList.builder();
                typeSignatures.add((Object)TypeSignatureParameter.namedField((String)"tag", (TypeSignature)TinyintType.TINYINT.getTypeSignature()));
                for (int i = 0; i < unionObjectTypes.size(); ++i) {
                    TypeInfo unionObjectType = (TypeInfo)unionObjectTypes.get(i);
                    typeSignatures.add((Object)TypeSignatureParameter.namedField((String)("field" + i), (TypeSignature)HiveTypeTranslator.toTypeSignature(unionObjectType)));
                }
                return TypeSignature.rowType((List)typeSignatures.build());
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type: %s", typeInfo));
    }

    @Nullable
    public static Type fromPrimitiveType(PrimitiveTypeInfo typeInfo) {
        switch (typeInfo.getPrimitiveCategory()) {
            case BOOLEAN: {
                return BooleanType.BOOLEAN;
            }
            case BYTE: {
                return TinyintType.TINYINT;
            }
            case SHORT: {
                return SmallintType.SMALLINT;
            }
            case INT: {
                return IntegerType.INTEGER;
            }
            case LONG: {
                return BigintType.BIGINT;
            }
            case FLOAT: {
                return RealType.REAL;
            }
            case DOUBLE: {
                return DoubleType.DOUBLE;
            }
            case STRING: {
                return VarcharType.createUnboundedVarcharType();
            }
            case VARCHAR: {
                return VarcharType.createVarcharType((int)((VarcharTypeInfo)typeInfo).getLength());
            }
            case CHAR: {
                return CharType.createCharType((long)((CharTypeInfo)typeInfo).getLength());
            }
            case DATE: {
                return DateType.DATE;
            }
            case TIMESTAMP: {
                return TimestampType.TIMESTAMP_MILLIS;
            }
            case BINARY: {
                return VarbinaryType.VARBINARY;
            }
            case DECIMAL: {
                DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)typeInfo;
                return DecimalType.createDecimalType((int)decimalTypeInfo.precision(), (int)decimalTypeInfo.scale());
            }
        }
        return null;
    }
}

