/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.util;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import com.google.common.io.BaseEncoding;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import com.qubole.rubix.prestosql.CachingPrestoS3FileSystem;
import io.airlift.slice.Slice;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HiveReadOnlyException;
import io.prestosql.plugin.hive.HiveSessionProperties;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.avro.AvroRecordWriter;
import io.prestosql.plugin.hive.metastore.Database;
import io.prestosql.plugin.hive.metastore.MetastoreUtil;
import io.prestosql.plugin.hive.metastore.Partition;
import io.prestosql.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.prestosql.plugin.hive.metastore.Storage;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.plugin.hive.parquet.ParquetRecordWriter;
import io.prestosql.plugin.hive.s3.PrestoS3FileSystem;
import io.prestosql.plugin.hive.util.HiveUtil;
import io.prestosql.plugin.hive.util.SequenceFileRecordWriter;
import io.prestosql.plugin.hive.util.TextRecordWriter;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.Page;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.SchemaNotFoundException;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.CharType;
import io.prestosql.spi.type.Chars;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ViewFileSystem;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.ProtectMode;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveSequenceFileOutputFormat;
import org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;

public final class HiveWriteUtils {
    private HiveWriteUtils() {
    }

    public static FileSinkOperator.RecordWriter createRecordWriter(Path target, JobConf conf, Properties properties, String outputFormatName, ConnectorSession session) {
        try {
            boolean compress = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.COMPRESSRESULT);
            if (outputFormatName.equals(MapredParquetOutputFormat.class.getName())) {
                return ParquetRecordWriter.create(target, conf, properties, session);
            }
            if (outputFormatName.equals(HiveIgnoreKeyTextOutputFormat.class.getName())) {
                return new TextRecordWriter(target, conf, properties, compress);
            }
            if (outputFormatName.equals(HiveSequenceFileOutputFormat.class.getName())) {
                return new SequenceFileRecordWriter(target, conf, Text.class, compress);
            }
            if (outputFormatName.equals(AvroContainerOutputFormat.class.getName())) {
                return new AvroRecordWriter(target, conf, compress, properties);
            }
            Object writer = Class.forName(outputFormatName).getConstructor(new Class[0]).newInstance(new Object[0]);
            return ((HiveOutputFormat)writer).getHiveRecordWriter(conf, target, Text.class, compress, properties, (Progressable)Reporter.NULL);
        }
        catch (IOException | ReflectiveOperationException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_DATA_ERROR, (Throwable)e);
        }
    }

    public static Serializer initializeSerializer(Configuration conf, Properties properties, String serializerName) {
        try {
            Serializer result = (Serializer)Class.forName(serializerName).getConstructor(new Class[0]).newInstance(new Object[0]);
            result.initialize(conf, properties);
            return result;
        }
        catch (ClassNotFoundException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_SERDE_NOT_FOUND, "Serializer does not exist: " + serializerName);
        }
        catch (ReflectiveOperationException | SerDeException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_DATA_ERROR, e);
        }
    }

    public static ObjectInspector getJavaObjectInspector(Type type) {
        if (type.equals(BooleanType.BOOLEAN)) {
            return PrimitiveObjectInspectorFactory.javaBooleanObjectInspector;
        }
        if (type.equals(BigintType.BIGINT)) {
            return PrimitiveObjectInspectorFactory.javaLongObjectInspector;
        }
        if (type.equals(IntegerType.INTEGER)) {
            return PrimitiveObjectInspectorFactory.javaIntObjectInspector;
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return PrimitiveObjectInspectorFactory.javaShortObjectInspector;
        }
        if (type.equals(TinyintType.TINYINT)) {
            return PrimitiveObjectInspectorFactory.javaByteObjectInspector;
        }
        if (type.equals(RealType.REAL)) {
            return PrimitiveObjectInspectorFactory.javaFloatObjectInspector;
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return PrimitiveObjectInspectorFactory.javaDoubleObjectInspector;
        }
        if (type instanceof VarcharType) {
            return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        }
        if (type instanceof CharType) {
            return PrimitiveObjectInspectorFactory.writableHiveCharObjectInspector;
        }
        if (type.equals(VarbinaryType.VARBINARY)) {
            return PrimitiveObjectInspectorFactory.javaByteArrayObjectInspector;
        }
        if (type.equals(DateType.DATE)) {
            return PrimitiveObjectInspectorFactory.javaDateObjectInspector;
        }
        if (type.equals(TimestampType.TIMESTAMP_MILLIS)) {
            return PrimitiveObjectInspectorFactory.javaTimestampObjectInspector;
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)new DecimalTypeInfo(decimalType.getPrecision(), decimalType.getScale()));
        }
        if (HiveUtil.isArrayType(type)) {
            return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)HiveWriteUtils.getJavaObjectInspector((Type)type.getTypeParameters().get(0)));
        }
        if (HiveUtil.isMapType(type)) {
            ObjectInspector keyObjectInspector = HiveWriteUtils.getJavaObjectInspector((Type)type.getTypeParameters().get(0));
            ObjectInspector valueObjectInspector = HiveWriteUtils.getJavaObjectInspector((Type)type.getTypeParameters().get(1));
            return ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)keyObjectInspector, (ObjectInspector)valueObjectInspector);
        }
        if (HiveUtil.isRowType(type)) {
            return ObjectInspectorFactory.getStandardStructObjectInspector((List)((List)type.getTypeSignature().getParameters().stream().map(parameter -> (String)parameter.getNamedTypeSignature().getName().get()).collect(ImmutableList.toImmutableList())), (List)((List)type.getTypeParameters().stream().map(HiveWriteUtils::getJavaObjectInspector).collect(ImmutableList.toImmutableList())));
        }
        throw new IllegalArgumentException("unsupported type: " + type);
    }

    public static List<String> createPartitionValues(List<Type> partitionColumnTypes, Page partitionColumns, int position) {
        ImmutableList.Builder partitionValues = ImmutableList.builder();
        for (int field = 0; field < partitionColumns.getChannelCount(); ++field) {
            Object value = HiveWriteUtils.getField(partitionColumnTypes.get(field), partitionColumns.getBlock(field), position);
            if (value == null) {
                partitionValues.add((Object)"__HIVE_DEFAULT_PARTITION__");
                continue;
            }
            String valueString = value.toString();
            if (!CharMatcher.inRange((char)' ', (char)'~').matchesAllOf((CharSequence)valueString)) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, "Hive partition keys can only contain printable ASCII characters (0x20 - 0x7E). Invalid value: " + BaseEncoding.base16().withSeparator(" ", 2).encode(valueString.getBytes(StandardCharsets.UTF_8)));
            }
            partitionValues.add((Object)valueString);
        }
        return partitionValues.build();
    }

    public static Object getField(Type type, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return type.getBoolean(block, position);
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return type.getLong(block, position);
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            return Math.toIntExact(type.getLong(block, position));
        }
        if (SmallintType.SMALLINT.equals((Object)type)) {
            return Shorts.checkedCast((long)type.getLong(block, position));
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            return SignedBytes.checkedCast((long)type.getLong(block, position));
        }
        if (RealType.REAL.equals((Object)type)) {
            return Float.valueOf(Float.intBitsToFloat((int)type.getLong(block, position)));
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return type.getDouble(block, position);
        }
        if (type instanceof VarcharType) {
            return new Text(type.getSlice(block, position).getBytes());
        }
        if (type instanceof CharType) {
            CharType charType = (CharType)type;
            return new Text(Chars.padSpaces((Slice)type.getSlice(block, position), (CharType)charType).toStringUtf8());
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return type.getSlice(block, position).getBytes();
        }
        if (DateType.DATE.equals((Object)type)) {
            return Date.ofEpochDay((int)Math.toIntExact(type.getLong(block, position)));
        }
        if (TimestampType.TIMESTAMP_MILLIS.equals((Object)type)) {
            return Timestamp.ofEpochMilli((long)Math.floorDiv(type.getLong(block, position), 1000));
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return HiveWriteUtils.getHiveDecimal(decimalType, block, position);
        }
        if (HiveUtil.isArrayType(type)) {
            Type elementType = (Type)type.getTypeParameters().get(0);
            Block arrayBlock = (Block)block.getObject(position, Block.class);
            ArrayList<Object> list = new ArrayList<Object>(arrayBlock.getPositionCount());
            for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
                Object element = HiveWriteUtils.getField(elementType, arrayBlock, i);
                list.add(element);
            }
            return Collections.unmodifiableList(list);
        }
        if (HiveUtil.isMapType(type)) {
            Type keyType = (Type)type.getTypeParameters().get(0);
            Type valueType = (Type)type.getTypeParameters().get(1);
            Block mapBlock = (Block)block.getObject(position, Block.class);
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            for (int i = 0; i < mapBlock.getPositionCount(); i += 2) {
                Object key = HiveWriteUtils.getField(keyType, mapBlock, i);
                Object value = HiveWriteUtils.getField(valueType, mapBlock, i + 1);
                map.put(key, value);
            }
            return Collections.unmodifiableMap(map);
        }
        if (HiveUtil.isRowType(type)) {
            Block rowBlock = (Block)block.getObject(position, Block.class);
            List fieldTypes = type.getTypeParameters();
            HiveUtil.checkCondition(fieldTypes.size() == rowBlock.getPositionCount(), (ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Expected row value field count does not match type field count", new Object[0]);
            ArrayList<Object> row = new ArrayList<Object>(rowBlock.getPositionCount());
            for (int i = 0; i < rowBlock.getPositionCount(); ++i) {
                Object element = HiveWriteUtils.getField((Type)fieldTypes.get(i), rowBlock, i);
                row.add(element);
            }
            return Collections.unmodifiableList(row);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "unsupported type: " + type);
    }

    public static void checkTableIsWritable(Table table, boolean writesToNonManagedTablesEnabled) {
        if (table.getTableType().equals(TableType.MATERIALIZED_VIEW.toString())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot write to Hive materialized view");
        }
        if (!writesToNonManagedTablesEnabled && !table.getTableType().equals(TableType.MANAGED_TABLE.toString())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot write to non-managed Hive table");
        }
        HiveWriteUtils.checkWritable(table.getSchemaTableName(), Optional.empty(), MetastoreUtil.getProtectMode(table), table.getParameters(), table.getStorage());
    }

    public static void checkPartitionIsWritable(String partitionName, Partition partition) {
        HiveWriteUtils.checkWritable(partition.getSchemaTableName(), Optional.of(partitionName), MetastoreUtil.getProtectMode(partition), partition.getParameters(), partition.getStorage());
    }

    private static void checkWritable(SchemaTableName tableName, Optional<String> partitionName, ProtectMode protectMode, Map<String, String> parameters, Storage storage) {
        String tablePartitionDescription = "Table '" + tableName + "'";
        if (partitionName.isPresent()) {
            tablePartitionDescription = tablePartitionDescription + " partition '" + partitionName.get() + "'";
        }
        MetastoreUtil.verifyOnline(tableName, partitionName, protectMode, parameters);
        if (protectMode.readOnly) {
            throw new HiveReadOnlyException(tableName, partitionName);
        }
        if (storage.isSkewed()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Inserting into bucketed tables with skew is not supported. %s", tablePartitionDescription));
        }
    }

    public static Path getTableDefaultLocation(HdfsEnvironment.HdfsContext context, SemiTransactionalHiveMetastore metastore, HdfsEnvironment hdfsEnvironment, String schemaName, String tableName) {
        Database database = metastore.getDatabase(schemaName).orElseThrow(() -> new SchemaNotFoundException(schemaName));
        return HiveWriteUtils.getTableDefaultLocation(database, context, hdfsEnvironment, schemaName, tableName);
    }

    public static Path getTableDefaultLocation(Database database, HdfsEnvironment.HdfsContext context, HdfsEnvironment hdfsEnvironment, String schemaName, String tableName) {
        Optional<String> location = database.getLocation();
        if (location.isEmpty() || location.get().isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_DATABASE_LOCATION_ERROR, String.format("Database '%s' location is not set", schemaName));
        }
        Path databasePath = new Path(location.get());
        if (!HiveWriteUtils.isS3FileSystem(context, hdfsEnvironment, databasePath)) {
            if (!HiveWriteUtils.pathExists(context, hdfsEnvironment, databasePath)) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_DATABASE_LOCATION_ERROR, String.format("Database '%s' location does not exist: %s", schemaName, databasePath));
            }
            if (!HiveWriteUtils.isDirectory(context, hdfsEnvironment, databasePath)) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_DATABASE_LOCATION_ERROR, String.format("Database '%s' location is not a directory: %s", schemaName, databasePath));
            }
        }
        return new Path(databasePath, tableName);
    }

    public static boolean pathExists(HdfsEnvironment.HdfsContext context, HdfsEnvironment hdfsEnvironment, Path path) {
        try {
            return hdfsEnvironment.getFileSystem(context, path).exists(path);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed checking path: " + path, (Throwable)e);
        }
    }

    public static boolean isS3FileSystem(HdfsEnvironment.HdfsContext context, HdfsEnvironment hdfsEnvironment, Path path) {
        try {
            FileSystem fileSystem = HiveWriteUtils.getRawFileSystem(hdfsEnvironment.getFileSystem(context, path));
            return fileSystem instanceof PrestoS3FileSystem || fileSystem.getClass().getName().equals("com.amazon.ws.emr.hadoop.fs.EmrFileSystem") || fileSystem instanceof CachingPrestoS3FileSystem;
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed checking path: " + path, (Throwable)e);
        }
    }

    public static boolean isViewFileSystem(HdfsEnvironment.HdfsContext context, HdfsEnvironment hdfsEnvironment, Path path) {
        try {
            return HiveWriteUtils.getRawFileSystem(hdfsEnvironment.getFileSystem(context, path)) instanceof ViewFileSystem;
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed checking path: " + path, (Throwable)e);
        }
    }

    public static FileSystem getRawFileSystem(FileSystem fileSystem) {
        if (fileSystem instanceof FilterFileSystem) {
            return HiveWriteUtils.getRawFileSystem(((FilterFileSystem)fileSystem).getRawFileSystem());
        }
        return fileSystem;
    }

    private static boolean isDirectory(HdfsEnvironment.HdfsContext context, HdfsEnvironment hdfsEnvironment, Path path) {
        try {
            return hdfsEnvironment.getFileSystem(context, path).isDirectory(path);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed checking path: " + path, (Throwable)e);
        }
    }

    public static boolean isHdfsEncrypted(HdfsEnvironment.HdfsContext context, HdfsEnvironment hdfsEnvironment, Path path) {
        try {
            FileSystem fileSystem = HiveWriteUtils.getRawFileSystem(hdfsEnvironment.getFileSystem(context, path));
            if (fileSystem instanceof DistributedFileSystem) {
                return ((DistributedFileSystem)fileSystem).getEZForPath(path) != null;
            }
            return false;
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed checking encryption status for path: " + path, (Throwable)e);
        }
    }

    public static Path createTemporaryPath(ConnectorSession session, HdfsEnvironment.HdfsContext context, HdfsEnvironment hdfsEnvironment, Path targetPath) {
        String temporaryPrefix = HiveSessionProperties.getTemporaryStagingDirectoryPath(session).replace("${USER}", context.getIdentity().getUser());
        if (HiveWriteUtils.isViewFileSystem(context, hdfsEnvironment, targetPath)) {
            temporaryPrefix = ".hive-staging";
        }
        Path temporaryRoot = new Path(targetPath, temporaryPrefix);
        Path temporaryPath = new Path(temporaryRoot, UUID.randomUUID().toString());
        HiveWriteUtils.createDirectory(context, hdfsEnvironment, temporaryPath);
        if (hdfsEnvironment.isNewFileInheritOwnership()) {
            HiveWriteUtils.setDirectoryOwner(context, hdfsEnvironment, temporaryPath, targetPath);
        }
        return temporaryPath;
    }

    private static void setDirectoryOwner(HdfsEnvironment.HdfsContext context, HdfsEnvironment hdfsEnvironment, Path path, Path targetPath) {
        try {
            FileStatus fileStatus;
            FileSystem fileSystem = hdfsEnvironment.getFileSystem(context, path);
            if (!fileSystem.exists(targetPath)) {
                Path parent = targetPath.getParent();
                if (!fileSystem.exists(parent)) {
                    return;
                }
                fileStatus = fileSystem.getFileStatus(parent);
            } else {
                fileStatus = fileSystem.getFileStatus(targetPath);
            }
            String owner = fileStatus.getOwner();
            String group = fileStatus.getGroup();
            fileSystem.setOwner(path, owner, group);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Failed to set owner on %s based on %s", path, targetPath), (Throwable)e);
        }
    }

    public static void createDirectory(HdfsEnvironment.HdfsContext context, HdfsEnvironment hdfsEnvironment, Path path) {
        try {
            if (!hdfsEnvironment.getFileSystem(context, path).mkdirs(path, hdfsEnvironment.getNewDirectoryPermissions())) {
                throw new IOException("mkdirs returned false");
            }
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed to create directory: " + path, (Throwable)e);
        }
        try {
            hdfsEnvironment.getFileSystem(context, path).setPermission(path, hdfsEnvironment.getNewDirectoryPermissions());
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed to set permission on directory: " + path, (Throwable)e);
        }
    }

    public static boolean isWritableType(HiveType hiveType) {
        return HiveWriteUtils.isWritableType(hiveType.getTypeInfo());
    }

    private static boolean isWritableType(TypeInfo typeInfo) {
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory();
                return HiveWriteUtils.isWritablePrimitiveType(primitiveCategory);
            }
            case MAP: {
                MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
                return HiveWriteUtils.isWritableType(mapTypeInfo.getMapKeyTypeInfo()) && HiveWriteUtils.isWritableType(mapTypeInfo.getMapValueTypeInfo());
            }
            case LIST: {
                ListTypeInfo listTypeInfo = (ListTypeInfo)typeInfo;
                return HiveWriteUtils.isWritableType(listTypeInfo.getListElementTypeInfo());
            }
            case STRUCT: {
                StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                return structTypeInfo.getAllStructFieldTypeInfos().stream().allMatch(HiveWriteUtils::isWritableType);
            }
        }
        return false;
    }

    private static boolean isWritablePrimitiveType(PrimitiveObjectInspector.PrimitiveCategory primitiveCategory) {
        switch (primitiveCategory) {
            case BOOLEAN: 
            case LONG: 
            case INT: 
            case SHORT: 
            case BYTE: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case DATE: 
            case TIMESTAMP: 
            case BINARY: 
            case DECIMAL: 
            case VARCHAR: 
            case CHAR: {
                return true;
            }
        }
        return false;
    }

    public static List<ObjectInspector> getRowColumnInspectors(List<Type> types) {
        return types.stream().map(HiveWriteUtils::getRowColumnInspector).collect(Collectors.toList());
    }

    public static ObjectInspector getRowColumnInspector(Type type) {
        if (type.equals(BooleanType.BOOLEAN)) {
            return PrimitiveObjectInspectorFactory.writableBooleanObjectInspector;
        }
        if (type.equals(BigintType.BIGINT)) {
            return PrimitiveObjectInspectorFactory.writableLongObjectInspector;
        }
        if (type.equals(IntegerType.INTEGER)) {
            return PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return PrimitiveObjectInspectorFactory.writableShortObjectInspector;
        }
        if (type.equals(TinyintType.TINYINT)) {
            return PrimitiveObjectInspectorFactory.writableByteObjectInspector;
        }
        if (type.equals(RealType.REAL)) {
            return PrimitiveObjectInspectorFactory.writableFloatObjectInspector;
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            if (varcharType.isUnbounded()) {
                return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
            }
            if (varcharType.getBoundedLength() <= 65535) {
                return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getVarcharTypeInfo((int)varcharType.getBoundedLength()));
            }
        }
        if (type instanceof CharType) {
            CharType charType = (CharType)type;
            int charLength = charType.getLength();
            return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getCharTypeInfo((int)charLength));
        }
        if (type.equals(VarbinaryType.VARBINARY)) {
            return PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
        }
        if (type.equals(DateType.DATE)) {
            return PrimitiveObjectInspectorFactory.writableDateObjectInspector;
        }
        if (type instanceof TimestampType) {
            return PrimitiveObjectInspectorFactory.writableTimestampObjectInspector;
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)new DecimalTypeInfo(decimalType.getPrecision(), decimalType.getScale()));
        }
        if (HiveUtil.isArrayType(type) || HiveUtil.isMapType(type) || HiveUtil.isRowType(type)) {
            return HiveWriteUtils.getJavaObjectInspector(type);
        }
        throw new IllegalArgumentException("unsupported type: " + type);
    }

    public static HiveDecimal getHiveDecimal(DecimalType decimalType, Block block, int position) {
        BigInteger unscaledValue = decimalType.isShort() ? BigInteger.valueOf(decimalType.getLong(block, position)) : Decimals.decodeUnscaledValue((Slice)decimalType.getSlice(block, position));
        return HiveDecimal.create((BigInteger)unscaledValue, (int)decimalType.getScale());
    }
}

