/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.util;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.RateLimiter;
import com.google.common.util.concurrent.SettableFuture;
import io.prestosql.plugin.hive.util.AsyncQueue;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ThrottledAsyncQueue<T>
extends AsyncQueue<T> {
    private final int maxBatchSizePerSec;
    private final Executor executor;
    private final RateLimiter rateLimiter;

    public ThrottledAsyncQueue(int maxBatchSizePerSec, int targetQueueSize, Executor executor) {
        super(targetQueueSize, executor);
        this.executor = executor;
        this.maxBatchSizePerSec = maxBatchSizePerSec;
        this.rateLimiter = RateLimiter.create((double)maxBatchSizePerSec);
    }

    @Override
    public synchronized <O> ListenableFuture<O> borrowBatchAsync(int maxSize, Function<List<T>, AsyncQueue.BorrowResult<T, O>> function) {
        Preconditions.checkArgument((maxSize >= 0 ? 1 : 0) != 0, (Object)"maxSize must be at least 0");
        SettableFuture<?> throttleFuture = Futures.immediateFuture(null);
        if (this.size() > 0) {
            int size = this.maxBatchSize(maxSize);
            if (this.rateLimiter.tryAcquire(size)) {
                return super.borrowBatchAsync(size, function);
            }
        } else if (!this.isFinished()) {
            throttleFuture = this.getNotEmptySignal();
        }
        return Futures.transformAsync(throttleFuture, any -> {
            int size = this.maxBatchSize(maxSize);
            if (size > 0) {
                this.rateLimiter.acquire(size);
            }
            return super.borrowBatchAsync(size, function);
        }, (Executor)this.executor);
    }

    private int maxBatchSize(int maxSize) {
        return Math.min(maxSize, Math.min(this.size(), this.maxBatchSizePerSec));
    }
}

