/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc;

import io.airlift.compress.Decompressor;
import io.airlift.compress.MalformedInputException;
import io.airlift.compress.lz4.Lz4Decompressor;
import io.prestosql.orc.OrcCorruptionException;
import io.prestosql.orc.OrcDataSourceId;
import io.prestosql.orc.OrcDecompressor;
import java.util.Objects;

class OrcLz4Decompressor
implements OrcDecompressor {
    private final OrcDataSourceId orcDataSourceId;
    private final int maxBufferSize;
    private final Decompressor decompressor = new Lz4Decompressor();

    public OrcLz4Decompressor(OrcDataSourceId orcDataSourceId, int maxBufferSize) {
        this.orcDataSourceId = Objects.requireNonNull(orcDataSourceId, "orcDataSourceId is null");
        this.maxBufferSize = maxBufferSize;
    }

    @Override
    public int decompress(byte[] input, int offset, int length, OrcDecompressor.OutputBuffer output) throws OrcCorruptionException {
        try {
            byte[] buffer = output.initialize(this.maxBufferSize);
            return this.decompressor.decompress(input, offset, length, buffer, 0, buffer.length);
        }
        catch (MalformedInputException e) {
            throw new OrcCorruptionException(e, this.orcDataSourceId, "Invalid compressed stream", new Object[0]);
        }
    }

    public String toString() {
        return "lz4";
    }
}

