/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.checkpoint;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import io.prestosql.orc.StreamId;
import io.prestosql.orc.checkpoint.BooleanStreamCheckpoint;
import io.prestosql.orc.checkpoint.ByteArrayStreamCheckpoint;
import io.prestosql.orc.checkpoint.ByteStreamCheckpoint;
import io.prestosql.orc.checkpoint.DecimalStreamCheckpoint;
import io.prestosql.orc.checkpoint.DoubleStreamCheckpoint;
import io.prestosql.orc.checkpoint.FloatStreamCheckpoint;
import io.prestosql.orc.checkpoint.InputStreamCheckpoint;
import io.prestosql.orc.checkpoint.InvalidCheckpointException;
import io.prestosql.orc.checkpoint.LongStreamV1Checkpoint;
import io.prestosql.orc.checkpoint.LongStreamV2Checkpoint;
import io.prestosql.orc.checkpoint.StreamCheckpoint;
import io.prestosql.orc.metadata.ColumnEncoding;
import io.prestosql.orc.metadata.OrcType;
import io.prestosql.orc.metadata.RowGroupIndex;
import io.prestosql.orc.metadata.Stream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class Checkpoints {
    private Checkpoints() {
    }

    public static Map<StreamId, StreamCheckpoint> getStreamCheckpoints(Set<Integer> columns, List<OrcType> columnTypes, boolean compressed, int rowGroupId, List<ColumnEncoding> columnEncodings, Map<StreamId, Stream> streams, Map<StreamId, List<RowGroupIndex>> columnIndexes) throws InvalidCheckpointException {
        ImmutableSetMultimap.Builder streamKindsBuilder = ImmutableSetMultimap.builder();
        for (Stream stream : streams.values()) {
            streamKindsBuilder.put((Object)stream.getColumn(), (Object)stream.getStreamKind());
        }
        ImmutableSetMultimap streamKinds = streamKindsBuilder.build();
        ImmutableMap.Builder checkpoints = ImmutableMap.builder();
        block13: for (Map.Entry<StreamId, List<RowGroupIndex>> entry : columnIndexes.entrySet()) {
            int column = entry.getKey().getColumn();
            if (!columns.contains(column)) continue;
            List<Integer> positionsList = entry.getValue().get(rowGroupId).getPositions();
            ColumnEncoding.ColumnEncodingKind columnEncoding = columnEncodings.get(column).getColumnEncodingKind();
            OrcType.OrcTypeKind columnType = columnTypes.get(column).getOrcTypeKind();
            Set availableStreams = streamKinds.get((Object)column);
            ColumnPositionsList columnPositionsList = new ColumnPositionsList(column, columnType, positionsList);
            switch (columnType) {
                case BOOLEAN: {
                    checkpoints.putAll(Checkpoints.getBooleanColumnCheckpoints(column, compressed, availableStreams, columnPositionsList));
                    continue block13;
                }
                case BYTE: {
                    checkpoints.putAll(Checkpoints.getByteColumnCheckpoints(column, compressed, availableStreams, columnPositionsList));
                    continue block13;
                }
                case SHORT: 
                case INT: 
                case LONG: 
                case DATE: {
                    checkpoints.putAll(Checkpoints.getLongColumnCheckpoints(column, columnEncoding, compressed, availableStreams, columnPositionsList));
                    continue block13;
                }
                case FLOAT: {
                    checkpoints.putAll(Checkpoints.getFloatColumnCheckpoints(column, compressed, availableStreams, columnPositionsList));
                    continue block13;
                }
                case DOUBLE: {
                    checkpoints.putAll(Checkpoints.getDoubleColumnCheckpoints(column, compressed, availableStreams, columnPositionsList));
                    continue block13;
                }
                case TIMESTAMP: {
                    checkpoints.putAll(Checkpoints.getTimestampColumnCheckpoints(column, columnEncoding, compressed, availableStreams, columnPositionsList));
                    continue block13;
                }
                case BINARY: 
                case STRING: 
                case VARCHAR: 
                case CHAR: {
                    checkpoints.putAll(Checkpoints.getSliceColumnCheckpoints(column, columnEncoding, compressed, availableStreams, columnPositionsList));
                    continue block13;
                }
                case LIST: 
                case MAP: {
                    checkpoints.putAll(Checkpoints.getListOrMapColumnCheckpoints(column, columnEncoding, compressed, availableStreams, columnPositionsList));
                    continue block13;
                }
                case STRUCT: {
                    checkpoints.putAll(Checkpoints.getStructColumnCheckpoints(column, compressed, availableStreams, columnPositionsList));
                    continue block13;
                }
                case DECIMAL: {
                    checkpoints.putAll(Checkpoints.getDecimalColumnCheckpoints(column, columnEncoding, compressed, availableStreams, columnPositionsList));
                    continue block13;
                }
            }
            throw new IllegalArgumentException("Unsupported column type " + (Object)((Object)columnType));
        }
        return checkpoints.build();
    }

    public static StreamCheckpoint getDictionaryStreamCheckpoint(StreamId streamId, OrcType.OrcTypeKind columnType, ColumnEncoding.ColumnEncodingKind columnEncoding) {
        if (streamId.getStreamKind() == Stream.StreamKind.DICTIONARY_DATA) {
            switch (columnType) {
                case BINARY: 
                case STRING: 
                case VARCHAR: 
                case CHAR: {
                    return new ByteArrayStreamCheckpoint(InputStreamCheckpoint.createInputStreamCheckpoint(0, 0));
                }
            }
        }
        if (streamId.getStreamKind() == Stream.StreamKind.LENGTH || streamId.getStreamKind() == Stream.StreamKind.DATA) {
            if (columnEncoding == ColumnEncoding.ColumnEncodingKind.DICTIONARY_V2) {
                return new LongStreamV2Checkpoint(0, InputStreamCheckpoint.createInputStreamCheckpoint(0, 0));
            }
            if (columnEncoding == ColumnEncoding.ColumnEncodingKind.DICTIONARY) {
                return new LongStreamV1Checkpoint(0, InputStreamCheckpoint.createInputStreamCheckpoint(0, 0));
            }
        }
        throw new IllegalArgumentException("Unsupported column type " + (Object)((Object)columnType) + " for dictionary stream " + streamId);
    }

    private static Map<StreamId, StreamCheckpoint> getBooleanColumnCheckpoints(int column, boolean compressed, Set<Stream.StreamKind> availableStreams, ColumnPositionsList positionsList) {
        ImmutableMap.Builder checkpoints = ImmutableMap.builder();
        if (availableStreams.contains((Object)Stream.StreamKind.PRESENT)) {
            checkpoints.put((Object)new StreamId(column, Stream.StreamKind.PRESENT), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.DATA)) {
            checkpoints.put((Object)new StreamId(column, Stream.StreamKind.DATA), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        return checkpoints.build();
    }

    private static Map<StreamId, StreamCheckpoint> getByteColumnCheckpoints(int column, boolean compressed, Set<Stream.StreamKind> availableStreams, ColumnPositionsList positionsList) {
        ImmutableMap.Builder checkpoints = ImmutableMap.builder();
        if (availableStreams.contains((Object)Stream.StreamKind.PRESENT)) {
            checkpoints.put((Object)new StreamId(column, Stream.StreamKind.PRESENT), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.DATA)) {
            checkpoints.put((Object)new StreamId(column, Stream.StreamKind.DATA), (Object)new ByteStreamCheckpoint(compressed, positionsList));
        }
        return checkpoints.build();
    }

    private static Map<StreamId, StreamCheckpoint> getLongColumnCheckpoints(int column, ColumnEncoding.ColumnEncodingKind encoding, boolean compressed, Set<Stream.StreamKind> availableStreams, ColumnPositionsList positionsList) {
        ImmutableMap.Builder checkpoints = ImmutableMap.builder();
        if (availableStreams.contains((Object)Stream.StreamKind.PRESENT)) {
            checkpoints.put((Object)new StreamId(column, Stream.StreamKind.PRESENT), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.DATA)) {
            checkpoints.put((Object)new StreamId(column, Stream.StreamKind.DATA), (Object)Checkpoints.createLongStreamCheckpoint(encoding, compressed, positionsList));
        }
        return checkpoints.build();
    }

    private static Map<StreamId, StreamCheckpoint> getFloatColumnCheckpoints(int column, boolean compressed, Set<Stream.StreamKind> availableStreams, ColumnPositionsList positionsList) {
        ImmutableMap.Builder checkpoints = ImmutableMap.builder();
        if (availableStreams.contains((Object)Stream.StreamKind.PRESENT)) {
            checkpoints.put((Object)new StreamId(column, Stream.StreamKind.PRESENT), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.DATA)) {
            checkpoints.put((Object)new StreamId(column, Stream.StreamKind.DATA), (Object)new FloatStreamCheckpoint(compressed, positionsList));
        }
        return checkpoints.build();
    }

    private static Map<StreamId, StreamCheckpoint> getDoubleColumnCheckpoints(int column, boolean compressed, Set<Stream.StreamKind> availableStreams, ColumnPositionsList positionsList) {
        ImmutableMap.Builder checkpoints = ImmutableMap.builder();
        if (availableStreams.contains((Object)Stream.StreamKind.PRESENT)) {
            checkpoints.put((Object)new StreamId(column, Stream.StreamKind.PRESENT), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.DATA)) {
            checkpoints.put((Object)new StreamId(column, Stream.StreamKind.DATA), (Object)new DoubleStreamCheckpoint(compressed, positionsList));
        }
        return checkpoints.build();
    }

    private static Map<StreamId, StreamCheckpoint> getTimestampColumnCheckpoints(int column, ColumnEncoding.ColumnEncodingKind encoding, boolean compressed, Set<Stream.StreamKind> availableStreams, ColumnPositionsList positionsList) {
        ImmutableMap.Builder checkpoints = ImmutableMap.builder();
        if (availableStreams.contains((Object)Stream.StreamKind.PRESENT)) {
            checkpoints.put((Object)new StreamId(column, Stream.StreamKind.PRESENT), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.DATA)) {
            checkpoints.put((Object)new StreamId(column, Stream.StreamKind.DATA), (Object)Checkpoints.createLongStreamCheckpoint(encoding, compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.SECONDARY)) {
            checkpoints.put((Object)new StreamId(column, Stream.StreamKind.SECONDARY), (Object)Checkpoints.createLongStreamCheckpoint(encoding, compressed, positionsList));
        }
        return checkpoints.build();
    }

    private static Map<StreamId, StreamCheckpoint> getSliceColumnCheckpoints(int column, ColumnEncoding.ColumnEncodingKind encoding, boolean compressed, Set<Stream.StreamKind> availableStreams, ColumnPositionsList positionsList) {
        ImmutableMap.Builder checkpoints = ImmutableMap.builder();
        if (availableStreams.contains((Object)Stream.StreamKind.PRESENT)) {
            checkpoints.put((Object)new StreamId(column, Stream.StreamKind.PRESENT), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        if (encoding == ColumnEncoding.ColumnEncodingKind.DIRECT || encoding == ColumnEncoding.ColumnEncodingKind.DIRECT_V2) {
            if (availableStreams.contains((Object)Stream.StreamKind.DATA)) {
                checkpoints.put((Object)new StreamId(column, Stream.StreamKind.DATA), (Object)new ByteArrayStreamCheckpoint(compressed, positionsList));
            }
            if (availableStreams.contains((Object)Stream.StreamKind.LENGTH)) {
                checkpoints.put((Object)new StreamId(column, Stream.StreamKind.LENGTH), (Object)Checkpoints.createLongStreamCheckpoint(encoding, compressed, positionsList));
            }
        } else if (encoding == ColumnEncoding.ColumnEncodingKind.DICTIONARY || encoding == ColumnEncoding.ColumnEncodingKind.DICTIONARY_V2) {
            if (availableStreams.contains((Object)Stream.StreamKind.DATA)) {
                checkpoints.put((Object)new StreamId(column, Stream.StreamKind.DATA), (Object)Checkpoints.createLongStreamCheckpoint(encoding, compressed, positionsList));
            }
        } else {
            throw new IllegalArgumentException("Unsupported encoding for slice column: " + (Object)((Object)encoding));
        }
        return checkpoints.build();
    }

    private static Map<StreamId, StreamCheckpoint> getListOrMapColumnCheckpoints(int column, ColumnEncoding.ColumnEncodingKind encoding, boolean compressed, Set<Stream.StreamKind> availableStreams, ColumnPositionsList positionsList) {
        ImmutableMap.Builder checkpoints = ImmutableMap.builder();
        if (availableStreams.contains((Object)Stream.StreamKind.PRESENT)) {
            checkpoints.put((Object)new StreamId(column, Stream.StreamKind.PRESENT), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.LENGTH)) {
            checkpoints.put((Object)new StreamId(column, Stream.StreamKind.LENGTH), (Object)Checkpoints.createLongStreamCheckpoint(encoding, compressed, positionsList));
        }
        return checkpoints.build();
    }

    private static Map<StreamId, StreamCheckpoint> getStructColumnCheckpoints(int column, boolean compressed, Set<Stream.StreamKind> availableStreams, ColumnPositionsList positionsList) {
        ImmutableMap.Builder checkpoints = ImmutableMap.builder();
        if (availableStreams.contains((Object)Stream.StreamKind.PRESENT)) {
            checkpoints.put((Object)new StreamId(column, Stream.StreamKind.PRESENT), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        return checkpoints.build();
    }

    private static Map<StreamId, StreamCheckpoint> getDecimalColumnCheckpoints(int column, ColumnEncoding.ColumnEncodingKind encoding, boolean compressed, Set<Stream.StreamKind> availableStreams, ColumnPositionsList positionsList) {
        ImmutableMap.Builder checkpoints = ImmutableMap.builder();
        if (availableStreams.contains((Object)Stream.StreamKind.PRESENT)) {
            checkpoints.put((Object)new StreamId(column, Stream.StreamKind.PRESENT), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.DATA)) {
            checkpoints.put((Object)new StreamId(column, Stream.StreamKind.DATA), (Object)new DecimalStreamCheckpoint(compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.SECONDARY)) {
            checkpoints.put((Object)new StreamId(column, Stream.StreamKind.SECONDARY), (Object)Checkpoints.createLongStreamCheckpoint(encoding, compressed, positionsList));
        }
        return checkpoints.build();
    }

    private static StreamCheckpoint createLongStreamCheckpoint(ColumnEncoding.ColumnEncodingKind encoding, boolean compressed, ColumnPositionsList positionsList) {
        if (encoding == ColumnEncoding.ColumnEncodingKind.DIRECT_V2 || encoding == ColumnEncoding.ColumnEncodingKind.DICTIONARY_V2) {
            return new LongStreamV2Checkpoint(compressed, positionsList);
        }
        if (encoding == ColumnEncoding.ColumnEncodingKind.DIRECT || encoding == ColumnEncoding.ColumnEncodingKind.DICTIONARY) {
            return new LongStreamV1Checkpoint(compressed, positionsList);
        }
        throw new IllegalArgumentException("Unsupported encoding for long stream: " + (Object)((Object)encoding));
    }

    public static class ColumnPositionsList {
        private final int column;
        private final OrcType.OrcTypeKind columnType;
        private final List<Integer> positionsList;
        private int index;

        private ColumnPositionsList(int column, OrcType.OrcTypeKind columnType, List<Integer> positionsList) {
            this.column = column;
            this.columnType = Objects.requireNonNull(columnType, "columnType is null");
            this.positionsList = ImmutableList.copyOf((Collection)Objects.requireNonNull(positionsList, "positionsList is null"));
        }

        public int getIndex() {
            return this.index;
        }

        public boolean hasNextPosition() {
            return this.index < this.positionsList.size();
        }

        public int nextPosition() {
            if (!this.hasNextPosition()) {
                throw new InvalidCheckpointException("Not enough positions for column %s and sequence %s, of type %s, checkpoints", new Object[]{this.column, this.columnType});
            }
            return this.positionsList.get(this.index++);
        }
    }
}

