/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.metadata.statistics;

import io.prestosql.orc.metadata.statistics.ColumnStatistics;
import io.prestosql.orc.metadata.statistics.IntegerStatistics;
import io.prestosql.orc.metadata.statistics.LongValueStatisticsBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class IntegerStatisticsBuilder
implements LongValueStatisticsBuilder {
    private long nonNullValueCount;
    private long minimum = Long.MAX_VALUE;
    private long maximum = Long.MIN_VALUE;
    private long sum;
    private boolean overflow;

    @Override
    public void addValue(long value) {
        ++this.nonNullValueCount;
        this.minimum = Math.min(value, this.minimum);
        this.maximum = Math.max(value, this.maximum);
        if (!this.overflow) {
            try {
                this.sum = Math.addExact(this.sum, value);
            }
            catch (ArithmeticException e) {
                this.overflow = true;
            }
        }
    }

    private void addIntegerStatistics(long valueCount, IntegerStatistics value) {
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(value.getMin(), "value.getMin() is null");
        Objects.requireNonNull(value.getMax(), "value.getMax() is null");
        this.nonNullValueCount += valueCount;
        this.minimum = Math.min(value.getMin(), this.minimum);
        this.maximum = Math.max(value.getMax(), this.maximum);
        if (value.getSum() == null) {
            this.overflow = true;
        } else if (!this.overflow) {
            try {
                this.sum = Math.addExact(this.sum, value.getSum());
            }
            catch (ArithmeticException e) {
                this.overflow = true;
            }
        }
    }

    private Optional<IntegerStatistics> buildIntegerStatistics() {
        if (this.nonNullValueCount == 0L) {
            return Optional.empty();
        }
        return Optional.of(new IntegerStatistics(this.minimum, this.maximum, this.overflow ? null : Long.valueOf(this.sum)));
    }

    @Override
    public ColumnStatistics buildColumnStatistics() {
        Optional<IntegerStatistics> integerStatistics = this.buildIntegerStatistics();
        return new ColumnStatistics(this.nonNullValueCount, integerStatistics.map(s -> 9L).orElse(0L), null, integerStatistics.orElse(null), null, null, null, null, null, null);
    }

    public static Optional<IntegerStatistics> mergeIntegerStatistics(List<ColumnStatistics> stats) {
        IntegerStatisticsBuilder integerStatisticsBuilder = new IntegerStatisticsBuilder();
        for (ColumnStatistics columnStatistics : stats) {
            IntegerStatistics partialStatistics = columnStatistics.getIntegerStatistics();
            if (columnStatistics.getNumberOfValues() <= 0L) continue;
            if (partialStatistics == null) {
                return Optional.empty();
            }
            integerStatisticsBuilder.addIntegerStatistics(columnStatistics.getNumberOfValues(), partialStatistics);
        }
        return integerStatisticsBuilder.buildIntegerStatistics();
    }
}

