/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.stream;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.orc.OrcOutputBuffer;
import io.prestosql.orc.checkpoint.DoubleStreamCheckpoint;
import io.prestosql.orc.metadata.CompressionKind;
import io.prestosql.orc.metadata.Stream;
import io.prestosql.orc.stream.StreamDataOutput;
import io.prestosql.orc.stream.ValueOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.openjdk.jol.info.ClassLayout;

public class DoubleOutputStream
implements ValueOutputStream<DoubleStreamCheckpoint> {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(DoubleOutputStream.class).instanceSize();
    private final OrcOutputBuffer buffer;
    private final List<DoubleStreamCheckpoint> checkpoints = new ArrayList<DoubleStreamCheckpoint>();
    private boolean closed;

    public DoubleOutputStream(CompressionKind compression, int bufferSize) {
        this.buffer = new OrcOutputBuffer(compression, bufferSize);
    }

    public void writeDouble(double value) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.buffer.writeDouble(value);
    }

    @Override
    public void close() {
        this.closed = true;
        this.buffer.close();
    }

    @Override
    public void recordCheckpoint() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.checkpoints.add(new DoubleStreamCheckpoint(this.buffer.getCheckpoint()));
    }

    @Override
    public List<DoubleStreamCheckpoint> getCheckpoints() {
        Preconditions.checkState((boolean)this.closed);
        return ImmutableList.copyOf(this.checkpoints);
    }

    @Override
    public StreamDataOutput getStreamDataOutput(int column) {
        return new StreamDataOutput(this.buffer::writeDataTo, new Stream(column, Stream.StreamKind.DATA, Math.toIntExact(this.buffer.getOutputDataSize()), false));
    }

    @Override
    public long getBufferedBytes() {
        return this.buffer.estimateOutputDataSize();
    }

    @Override
    public long getRetainedBytes() {
        return (long)INSTANCE_SIZE + this.buffer.getRetainedSize();
    }

    @Override
    public void reset() {
        this.closed = false;
        this.buffer.reset();
        this.checkpoints.clear();
    }
}

