/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.stream;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.prestosql.orc.StreamDescriptor;
import io.prestosql.orc.StreamId;
import io.prestosql.orc.metadata.Stream;
import io.prestosql.orc.stream.InputStreamSource;
import io.prestosql.orc.stream.MissingInputStreamSource;
import io.prestosql.orc.stream.ValueInputStream;
import java.util.Map;
import java.util.Objects;

public class InputStreamSources {
    private final Map<StreamId, InputStreamSource<?>> streamSources;

    public InputStreamSources(Map<StreamId, InputStreamSource<?>> streamSources) {
        this.streamSources = ImmutableMap.copyOf(Objects.requireNonNull(streamSources, "streamSources is null"));
    }

    public <S extends ValueInputStream<?>> InputStreamSource<S> getInputStreamSource(StreamDescriptor streamDescriptor, Stream.StreamKind streamKind, Class<S> streamType) {
        Objects.requireNonNull(streamDescriptor, "streamDescriptor is null");
        Objects.requireNonNull(streamType, "streamType is null");
        InputStreamSource<Object> streamSource = this.streamSources.get(new StreamId(streamDescriptor.getStreamId(), streamKind));
        if (streamSource == null) {
            streamSource = MissingInputStreamSource.missingStreamSource(streamType);
        }
        Preconditions.checkArgument((boolean)streamType.isAssignableFrom(streamSource.getStreamType()), (String)"%s must be of type %s, not %s", (Object)streamDescriptor, (Object)streamType.getName(), (Object)streamSource.getStreamType().getName());
        return streamSource;
    }
}

