/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.stream;

import com.google.common.primitives.Ints;
import io.prestosql.orc.OrcCorruptionException;
import io.prestosql.orc.checkpoint.LongStreamCheckpoint;
import io.prestosql.orc.checkpoint.LongStreamV2Checkpoint;
import io.prestosql.orc.stream.LongBitPacker;
import io.prestosql.orc.stream.LongDecode;
import io.prestosql.orc.stream.LongInputStream;
import io.prestosql.orc.stream.OrcInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LongInputStreamV2
implements LongInputStream {
    private static final int MIN_REPEAT_SIZE = 3;
    private static final int MAX_LITERAL_SIZE = 512;
    private final LongBitPacker packer = new LongBitPacker();
    private final OrcInputStream input;
    private final boolean signed;
    private final long[] literals = new long[512];
    private int numLiterals;
    private int used;
    private final boolean skipCorrupt;
    private long lastReadInputCheckpoint;

    public LongInputStreamV2(OrcInputStream input, boolean signed, boolean skipCorrupt) {
        this.input = input;
        this.signed = signed;
        this.skipCorrupt = skipCorrupt;
        this.lastReadInputCheckpoint = input.getCheckpoint();
    }

    private void readValues() throws IOException {
        this.lastReadInputCheckpoint = this.input.getCheckpoint();
        int firstByte = this.input.read();
        if (firstByte < 0) {
            throw new OrcCorruptionException(this.input.getOrcDataSourceId(), "Read past end of RLE integer");
        }
        int enc = firstByte >>> 6 & 3;
        if (EncodingType.SHORT_REPEAT.ordinal() == enc) {
            this.readShortRepeatValues(firstByte);
        } else if (EncodingType.DIRECT.ordinal() == enc) {
            this.readDirectValues(firstByte);
        } else if (EncodingType.PATCHED_BASE.ordinal() == enc) {
            this.readPatchedBaseValues(firstByte);
        } else {
            this.readDeltaValues(firstByte);
        }
    }

    private void readDeltaValues(int firstByte) throws IOException {
        int fixedBits = firstByte >>> 1 & 0x1F;
        if (fixedBits != 0) {
            fixedBits = LongDecode.decodeBitWidth(fixedBits);
        }
        int length = (firstByte & 1) << 8;
        length |= this.input.read();
        long firstVal = LongDecode.readVInt(this.signed, this.input);
        this.literals[this.numLiterals++] = firstVal;
        if (fixedBits == 0) {
            long fixedDelta = LongDecode.readSignedVInt(this.input);
            for (int i = 0; i < length; ++i) {
                this.literals[this.numLiterals++] = this.literals[this.numLiterals - 2] + fixedDelta;
            }
        } else {
            long deltaBase = LongDecode.readSignedVInt(this.input);
            this.literals[this.numLiterals++] = firstVal + deltaBase;
            long prevVal = this.literals[this.numLiterals - 1];
            this.packer.unpack(this.literals, this.numLiterals, --length, fixedBits, this.input);
            while (length > 0) {
                this.literals[this.numLiterals] = deltaBase < 0L ? prevVal - this.literals[this.numLiterals] : prevVal + this.literals[this.numLiterals];
                prevVal = this.literals[this.numLiterals];
                --length;
                ++this.numLiterals;
            }
        }
    }

    private void readPatchedBaseValues(int firstByte) throws IOException {
        long mask;
        int fb = LongDecode.decodeBitWidth(firstByte >>> 1 & 0x1F);
        int length = (firstByte & 1) << 8;
        length |= this.input.read();
        ++length;
        int thirdByte = this.input.read();
        int baseWidth = thirdByte >>> 5 & 7;
        ++baseWidth;
        int patchWidth = LongDecode.decodeBitWidth(thirdByte & 0x1F);
        int fourthByte = this.input.read();
        int patchGapWidth = fourthByte >>> 5 & 7;
        ++patchGapWidth;
        int patchListLength = fourthByte & 0x1F;
        long base = LongInputStreamV2.bytesToLongBE(this.input, baseWidth);
        if ((base & (mask = 1L << baseWidth * 8 - 1)) != 0L) {
            base &= mask ^ 0xFFFFFFFFFFFFFFFFL;
            base = -base;
        }
        long[] unpacked = new long[length];
        this.packer.unpack(unpacked, 0, length, fb, this.input);
        long[] unpackedPatch = new long[patchListLength];
        if (patchWidth + patchGapWidth > 64 && !this.skipCorrupt) {
            throw new OrcCorruptionException(this.input.getOrcDataSourceId(), "Invalid RLEv2 encoded stream");
        }
        int bitSize = LongDecode.getClosestFixedBits(patchWidth + patchGapWidth);
        this.packer.unpack(unpackedPatch, 0, patchListLength, bitSize, this.input);
        int patchIndex = 0;
        long patchMask = (1L << patchWidth) - 1L;
        long currentGap = unpackedPatch[patchIndex] >>> patchWidth;
        long currentPatch = unpackedPatch[patchIndex] & patchMask;
        long actualGap = 0L;
        while (currentGap == 255L && currentPatch == 0L) {
            actualGap += 255L;
            currentGap = unpackedPatch[++patchIndex] >>> patchWidth;
            currentPatch = unpackedPatch[patchIndex] & patchMask;
        }
        actualGap += currentGap;
        for (int i = 0; i < unpacked.length; ++i) {
            if ((long)i == actualGap) {
                long patchedValue = unpacked[i] | currentPatch << fb;
                this.literals[this.numLiterals++] = base + patchedValue;
                if (++patchIndex >= patchListLength) continue;
                currentGap = unpackedPatch[patchIndex] >>> patchWidth;
                currentPatch = unpackedPatch[patchIndex] & patchMask;
                actualGap = 0L;
                while (currentGap == 255L && currentPatch == 0L) {
                    actualGap += 255L;
                    currentGap = unpackedPatch[++patchIndex] >>> patchWidth;
                    currentPatch = unpackedPatch[patchIndex] & patchMask;
                }
                actualGap += currentGap;
                actualGap += (long)i;
                continue;
            }
            this.literals[this.numLiterals++] = base + unpacked[i];
        }
    }

    private void readDirectValues(int firstByte) throws IOException {
        int fixedBits = LongDecode.decodeBitWidth(firstByte >>> 1 & 0x1F);
        int length = (firstByte & 1) << 8;
        length |= this.input.read();
        this.packer.unpack(this.literals, this.numLiterals, ++length, fixedBits, this.input);
        if (this.signed) {
            for (int i = 0; i < length; ++i) {
                this.literals[this.numLiterals] = LongDecode.zigzagDecode(this.literals[this.numLiterals]);
                ++this.numLiterals;
            }
        } else {
            this.numLiterals += length;
        }
    }

    private void readShortRepeatValues(int firstByte) throws IOException {
        int size = firstByte >>> 3 & 7;
        int length = firstByte & 7;
        length += 3;
        long val = LongInputStreamV2.bytesToLongBE(this.input, ++size);
        if (this.signed) {
            val = LongDecode.zigzagDecode(val);
        }
        for (int i = 0; i < length; ++i) {
            this.literals[this.numLiterals++] = val;
        }
    }

    private static long bytesToLongBE(InputStream input, int n) throws IOException {
        long out = 0L;
        while (n > 0) {
            long val = input.read();
            out |= val << --n * 8;
        }
        return out;
    }

    @Override
    public long next() throws IOException {
        if (this.used == this.numLiterals) {
            this.numLiterals = 0;
            this.used = 0;
            this.readValues();
        }
        return this.literals[this.used++];
    }

    @Override
    public void next(long[] values, int items) throws IOException {
        int offset = 0;
        while (items > 0) {
            if (this.used == this.numLiterals) {
                this.numLiterals = 0;
                this.used = 0;
                this.readValues();
            }
            int chunkSize = Ints.min((int[])new int[]{this.numLiterals - this.used, items});
            System.arraycopy(this.literals, this.used, values, offset, chunkSize);
            this.used += chunkSize;
            offset += chunkSize;
            items -= chunkSize;
        }
    }

    @Override
    public void next(int[] values, int items) throws IOException {
        int offset = 0;
        while (items > 0) {
            if (this.used == this.numLiterals) {
                this.numLiterals = 0;
                this.used = 0;
                this.readValues();
            }
            int chunkSize = Ints.min((int[])new int[]{this.numLiterals - this.used, items});
            for (int i = 0; i < chunkSize; ++i) {
                long literal = this.literals[this.used + i];
                int value = (int)literal;
                if (literal != (long)value) {
                    throw new OrcCorruptionException(this.input.getOrcDataSourceId(), "Decoded value out of range for a 32bit number");
                }
                values[offset + i] = value;
            }
            this.used += chunkSize;
            offset += chunkSize;
            items -= chunkSize;
        }
    }

    @Override
    public void next(short[] values, int items) throws IOException {
        int offset = 0;
        while (items > 0) {
            if (this.used == this.numLiterals) {
                this.numLiterals = 0;
                this.used = 0;
                this.readValues();
            }
            int chunkSize = Ints.min((int[])new int[]{this.numLiterals - this.used, items});
            for (int i = 0; i < chunkSize; ++i) {
                long literal = this.literals[this.used + i];
                short value = (short)literal;
                if (literal != (long)value) {
                    throw new OrcCorruptionException(this.input.getOrcDataSourceId(), "Decoded value out of range for a 16bit number");
                }
                values[offset + i] = value;
            }
            this.used += chunkSize;
            offset += chunkSize;
            items -= chunkSize;
        }
    }

    @Override
    public void seekToCheckpoint(LongStreamCheckpoint checkpoint) throws IOException {
        LongStreamV2Checkpoint v2Checkpoint = (LongStreamV2Checkpoint)checkpoint;
        if (this.lastReadInputCheckpoint == v2Checkpoint.getInputStreamCheckpoint() && v2Checkpoint.getOffset() <= this.numLiterals) {
            this.used = v2Checkpoint.getOffset();
        } else {
            this.input.seekToCheckpoint(v2Checkpoint.getInputStreamCheckpoint());
            this.numLiterals = 0;
            this.used = 0;
            this.skip(v2Checkpoint.getOffset());
        }
    }

    @Override
    public void skip(long items) throws IOException {
        while (items > 0L) {
            if (this.used == this.numLiterals) {
                this.numLiterals = 0;
                this.used = 0;
                this.readValues();
            }
            long consume = Math.min(items, (long)(this.numLiterals - this.used));
            this.used = (int)((long)this.used + consume);
            items -= consume;
        }
    }

    private static enum EncodingType {
        SHORT_REPEAT,
        DIRECT,
        PATCHED_BASE,
        DELTA;

    }
}

