/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.stream;

import com.google.common.base.MoreObjects;
import io.airlift.slice.Slice;
import io.prestosql.orc.OrcDataSourceId;
import io.prestosql.orc.stream.OrcDataReader;
import java.util.Objects;

public class MemoryOrcDataReader
implements OrcDataReader {
    private final OrcDataSourceId orcDataSourceId;
    private final Slice data;
    private final long retainedSize;

    public MemoryOrcDataReader(OrcDataSourceId orcDataSourceId, Slice data, long retainedSize) {
        this.orcDataSourceId = Objects.requireNonNull(orcDataSourceId, "orcDataSourceId is null");
        this.data = Objects.requireNonNull(data, "data is null");
        this.retainedSize = retainedSize;
    }

    @Override
    public OrcDataSourceId getOrcDataSourceId() {
        return this.orcDataSourceId;
    }

    @Override
    public long getRetainedSize() {
        return this.retainedSize;
    }

    @Override
    public int getSize() {
        return this.data.length();
    }

    @Override
    public int getMaxBufferSize() {
        return this.data.length();
    }

    @Override
    public Slice seekBuffer(int newPosition) {
        return this.data.slice(newPosition, this.data.length() - newPosition);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("orcDataSourceId", (Object)this.orcDataSourceId).add("dataSize", this.data.length()).toString();
    }
}

